/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.sum.PropSum;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSumBool
extends PropSum {
    protected final IntVar sum;

    protected PropSumBool(BoolVar[] variables, int pos, Operator o, IntVar sum, int b, boolean reactOnFineEvent) {
        super(ArrayUtils.concat((IntVar[])variables, sum), pos, o, b, PropagatorPriority.BINARY, reactOnFineEvent);
        this.sum = sum;
    }

    public PropSumBool(BoolVar[] variables, int pos, Operator o, IntVar sum, int b) {
        this(variables, pos, o, sum, b, false);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        switch (this.o) {
            case NQ: {
                return IntEventType.INSTANTIATE.getMask();
            }
            case LE: {
                return IntEventType.combine(IntEventType.INSTANTIATE, vIdx == this.l - 1 ? IntEventType.DECUPP : IntEventType.VOID);
            }
            case GE: {
                return IntEventType.combine(IntEventType.INSTANTIATE, vIdx == this.l - 1 ? IntEventType.INCLOW : IntEventType.VOID);
            }
        }
        return IntEventType.boundAndInst();
    }

    @Override
    protected void prepare() {
        int k;
        int i;
        int lb = 0;
        int ub = 0;
        for (i = 0; i < this.pos; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                k = ((IntVar[])this.vars)[i].getLB();
                lb += k;
                ub += k;
                continue;
            }
            ++ub;
        }
        while (i < this.l - 1) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                k = ((IntVar[])this.vars)[i].getLB();
                lb -= k;
                ub -= k;
            } else {
                --lb;
            }
            ++i;
        }
        this.sumLB = lb - this.sum.getUB();
        this.sumUB = ub - this.sum.getLB();
    }

    @Override
    protected void filterOnEq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0 || E < 0) {
            this.fails();
        }
        int i = 0;
        int lb = -this.sum.getUB();
        int ub = -this.sum.getLB();
        if (this.sum.updateLowerBound(-F2 - lb, (ICause)this)) {
            int nub = -this.sum.getLB();
            E += nub - ub;
            ub = nub;
        }
        if (this.sum.updateUpperBound(-ub + E, (ICause)this)) {
            int nlb = -this.sum.getUB();
            F2 -= nlb - lb;
        }
        if (F2 <= 0 || E <= 0) {
            while (i < this.pos) {
                lb = ((IntVar[])this.vars)[i].getLB();
                if (F2 <= 0 && ((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                    ++E;
                }
                ub = ((IntVar[])this.vars)[i].getUB();
                if (E <= 0 && ((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) {
                    ++F2;
                }
                ++i;
            }
            while (i < this.l - 1) {
                lb = ((IntVar[])this.vars)[i].getUB();
                if (F2 <= 0 && ((IntVar[])this.vars)[i].updateLowerBound(-F2 + lb, (ICause)this)) {
                    --E;
                }
                ub = ((IntVar[])this.vars)[i].getLB();
                if (E <= 0 && ((IntVar[])this.vars)[i].updateUpperBound(ub + E, (ICause)this)) {
                    --F2;
                }
                ++i;
            }
        }
    }

    @Override
    protected void filterOnLeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0) {
            this.fails();
        }
        int i = 0;
        int lb = -this.sum.getUB();
        int ub = -this.sum.getLB();
        if (this.sum.updateLowerBound(-F2 - lb, (ICause)this)) {
            int nub = -this.sum.getLB();
            E += nub - ub;
        }
        if (F2 <= 0) {
            while (i < this.pos) {
                lb = ((IntVar[])this.vars)[i].getLB();
                if (((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                    ++E;
                }
                ++i;
            }
            while (i < this.l - 1) {
                lb = ((IntVar[])this.vars)[i].getUB();
                if (((IntVar[])this.vars)[i].updateLowerBound(-F2 + lb, (ICause)this)) {
                    --E;
                }
                ++i;
            }
        }
        if (E <= 0) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnGeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (E < 0) {
            this.fails();
        }
        int i = 0;
        int lb = -this.sum.getUB();
        int ub = -this.sum.getLB();
        if (this.sum.updateUpperBound(-ub + E, (ICause)this)) {
            int nlb = -this.sum.getUB();
            F2 -= nlb - lb;
        }
        if (E <= 0) {
            while (i < this.pos) {
                ub = ((IntVar[])this.vars)[i].getUB();
                if (((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) {
                    ++F2;
                }
                ++i;
            }
            while (i < this.l - 1) {
                ub = ((IntVar[])this.vars)[i].getLB();
                if (((IntVar[])this.vars)[i].updateUpperBound(ub + E, (ICause)this)) {
                    --F2;
                }
                ++i;
            }
        }
        if (F2 <= 0) {
            this.setPassive();
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.pos == 0 ? "-" : "").append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l - 1) {
            linComb.append(" - ").append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(((IntVar[])this.vars)[i].getName()).append(" ").append(this.b < 0 ? "- " : "+ ").append(Math.abs(this.b));
        return linComb.toString();
    }

    @Override
    protected PropSum opposite() {
        BoolVar[] bvars = new BoolVar[((IntVar[])this.vars).length - 1];
        System.arraycopy(this.vars, 0, bvars, 0, bvars.length);
        return new PropSumBool(bvars, this.pos, PropSumBool.nop(this.o), ((IntVar[])this.vars)[((IntVar[])this.vars).length - 1], this.b + PropSumBool.nb(this.o), this.reactToFineEvt);
    }
}

