/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.grid.neighborhood.regular.square;

import java.util.Random;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.neighborhood.Neighborhoods;
import org.flsgen.grid.neighborhood.regular.square.PartialFourConnected;
import org.flsgen.grid.regular.square.PartialRegularSquareGrid;

public class PartialVariableWidthFourConnected<T extends PartialRegularSquareGrid>
implements INeighborhood<T> {
    private int minWidth;
    private int maxWidth;

    public PartialVariableWidthFourConnected(int minWidth, int maxWidth) throws FlsgenException {
        if (maxWidth < minWidth) {
            throw new FlsgenException("Min width must be lower than max width");
        }
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
    }

    @Override
    public int[] getNeighbors(T grid, int i) {
        PartialFourConnected four = Neighborhoods.PARTIAL_FOUR_CONNECTED;
        int[] fourNeigh = four.getNeighbors(grid, i);
        ISet neighbors = SetFactory.makeRangeSet();
        ISet next = SetFactory.makeRangeSet();
        for (int n : fourNeigh) {
            neighbors.add(n);
            next.add(n);
        }
        Random rd = new Random(System.currentTimeMillis());
        int v = rd.nextInt(this.maxWidth - this.minWidth + 1);
        for (int j = 1; j < this.minWidth + v; ++j) {
            int[] nextA = next.toArray();
            next.clear();
            for (int n : nextA) {
                if (j >= this.minWidth && !rd.nextBoolean()) continue;
                for (int neigh : four.getNeighbors(grid, n)) {
                    neighbors.add(neigh);
                    next.add(neigh);
                }
            }
        }
        return neighbors.toArray();
    }
}

