/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.utils;

import java.util.Arrays;
import org.chocosolver.util.graphOperations.connectivity.ConnectivityFinder;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.LandscapeGenerator;

public class CheckLandscape {
    public static final int checkNP(LandscapeGenerator generator, int classId, INeighborhood neighborhood) {
        UndirectedGraph g = CheckLandscape.getClassGraph(generator, classId, neighborhood);
        ConnectivityFinder cf = new ConnectivityFinder(g);
        cf.findAllCC();
        return cf.getNBCC();
    }

    public static final int[] checkAREA(LandscapeGenerator generator, int classId, INeighborhood neighborhood) {
        UndirectedGraph g = CheckLandscape.getClassGraph(generator, classId, neighborhood);
        ConnectivityFinder cf = new ConnectivityFinder(g);
        cf.findAllCC();
        int[] area = new int[cf.getNBCC()];
        for (int i = 0; i < area.length; ++i) {
            area[i] = cf.getSizeCC()[i];
        }
        Arrays.sort(area);
        return area;
    }

    private static UndirectedGraph getClassGraph(LandscapeGenerator generator, int classId, INeighborhood neighborhood) {
        RegularSquareGrid grid = generator.getGrid();
        UndirectedGraph g = GraphFactory.makeUndirectedGraph(grid.getNbCells(), SetType.BIPARTITESET, SetType.BIPARTITESET);
        for (int i = 0; i < grid.getNbCells(); ++i) {
            if (generator.getRasterGrid()[i] != classId) continue;
            g.addNode(i);
        }
        ISetIterator iSetIterator = g.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            for (int j : neighborhood.getNeighbors(grid, i)) {
                if (generator.getRasterGrid()[j] != classId) continue;
                g.addEdge(i, j);
            }
        }
        return g;
    }
}

