/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixHTML
extends ResultMatrix {
    private static final long serialVersionUID = 6672380422544799990L;

    public ResultMatrixHTML() {
        this(1, 1);
    }

    public ResultMatrixHTML(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixHTML(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String getDisplayName() {
        return "HTML";
    }

    @Override
    public void clear() {
        super.clear();
        this.setRowNameWidth(25);
        this.setPrintColNames(false);
        this.setEnumerateColNames(true);
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        result.append("<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n");
        result.append("   <tr>");
        int n = 0;
        while (n < cells[0].length) {
            if (this.isRowName(n)) {
                result.append("<td><b>" + cells[0][n] + "</b></td>");
            } else if (this.isMean(n)) {
                int cols = n == 1 ? 1 : 2;
                if (this.getShowStdDev()) {
                    ++cols;
                }
                result.append("<td align=\"center\" colspan=\"" + cols + "\">");
                result.append("<b>" + cells[0][n] + "</b>");
                result.append("</td>");
            }
            ++n;
        }
        result.append("</tr>\n");
        int i = 1;
        while (i < cells.length) {
            result.append("   <tr>");
            n = 0;
            while (n < cells[i].length) {
                if (this.isRowName(n)) {
                    result.append("<td>");
                } else if (this.isMean(n) || this.isStdDev(n)) {
                    result.append("<td align=\"right\">");
                } else if (this.isSignificance(n)) {
                    result.append("<td align=\"center\">");
                } else {
                    result.append("<td>");
                }
                if (cells[i][n].trim().equals("")) {
                    result.append("&nbsp;");
                } else if (this.isStdDev(n)) {
                    result.append("&plusmn;&nbsp;" + cells[i][n]);
                } else {
                    result.append(cells[i][n]);
                }
                result.append("</td>");
                ++n;
            }
            result.append("</tr>\n");
            ++i;
        }
        result.append("</table>\n");
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n   <tr><td colspan=\"2\"><b>Key</b></td></tr>\n";
        int i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                result = String.valueOf(result) + "   <tr><td><b>(" + (i + 1) + ")</b></td>" + "<td>" + this.removeFilterName(this.m_ColNames[i]) + "</td>" + "</tr>\n";
            }
            ++i;
        }
        result = String.valueOf(result) + "</table>\n";
        return result;
    }

    @Override
    public String toStringSummary() {
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String result = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
        String titles = "   <tr>";
        int resultsetLength = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        int i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                titles = String.valueOf(titles) + "<td align=\"center\"><b>" + this.getSummaryTitle(i) + "</b></td>";
            }
            ++i;
        }
        result = String.valueOf(result) + titles + "<td><b>(No. of datasets where [col] &gt;&gt; [row])</b></td></tr>\n";
        i = 0;
        while (i < this.getColCount()) {
            if (!this.getColHidden(i)) {
                result = String.valueOf(result) + "   <tr>";
                int j = 0;
                while (j < this.getColCount()) {
                    if (!this.getColHidden(j)) {
                        String content = j == i ? Utils.padLeft("-", resultsetLength * 2 + 3) : Utils.padLeft(this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ")", resultsetLength * 2 + 3);
                        result = String.valueOf(result) + "<td>" + content.replaceAll(" ", "&nbsp;") + "</td>";
                    }
                    ++j;
                }
                result = String.valueOf(result) + "<td><b>" + this.getSummaryTitle(i) + "</b> = " + this.removeFilterName(this.m_ColNames[i]) + "</td></tr>\n";
            }
            ++i;
        }
        result = String.valueOf(result) + "</table>\n";
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int biggest = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int width = Math.max(2 + (int)(Math.log(biggest) / Math.log(10.0)), ">-<".length());
        String result = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
        result = String.valueOf(result) + "   <tr><td align=\"center\"><b>&gt;-&lt;</b></td><td align=\"center\"><b>&gt;</b></td><td align=\"center\"><b>&lt;</b></td><td><b>Resultset</b></td></tr>\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        int i = this.getColCount() - 1;
        while (i >= 0) {
            int curr = ranking[i];
            if (!this.getColHidden(curr)) {
                result = String.valueOf(result) + "   <tr><td align=\"right\">" + this.m_RankingDiff[curr] + "</td>" + "<td align=\"right\">" + this.m_RankingWins[curr] + "</td>" + "<td align=\"right\">" + this.m_RankingLosses[curr] + "</td>" + "<td>" + this.removeFilterName(this.m_ColNames[curr]) + "</td>" + "<tr>\n";
            }
            --i;
        }
        result = String.valueOf(result) + "</table>\n";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] args) {
        ResultMatrixHTML matrix = new ResultMatrixHTML(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        int i = 0;
        while (i < matrix.getRowCount()) {
            int n = 0;
            while (n < matrix.getColCount()) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i == n) {
                    if (i % 2 == 1) {
                        matrix.setSignificance(n, i, 1);
                    } else {
                        matrix.setSignificance(n, i, 2);
                    }
                }
                ++n;
            }
            ++i;
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringHeader()) + "\n");
        System.out.println(String.valueOf(((ResultMatrix)matrix).toStringMatrix()) + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

