/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.Value;

public class DistinctionFinder {
    private double currentValue = Double.NaN;
    private int currentValueNumber = 0;
    private DistinctValue currentStoredValue = null;
    private int addedNumber = 0;
    private double previousValue = Double.NaN;
    private int previousValueNumber = 0;
    private int totalNumber = -1;
    private boolean compareTolerant = true;
    private List values;
    private boolean storeValues = false;

    public DistinctionFinder() {
    }

    public DistinctionFinder(boolean storeAllValues) {
        this.setStoreValues(storeAllValues);
    }

    public DistinctionFinder(int totalNumber) {
        this.totalNumber = totalNumber;
    }

    public void addValue(double value) {
        this.previousValue = this.currentValue;
        this.previousValueNumber = this.currentValueNumber++;
        this.currentValue = value;
        ++this.addedNumber;
        if (!Value.equalValues(this.previousValue, this.currentValue, this.isCompareTolerant())) {
            this.currentValueNumber = 1;
        }
        if (this.isStoreValues()) {
            if (this.isNewValue() || this.currentStoredValue == null) {
                this.currentStoredValue = new DistinctValue();
                this.currentStoredValue.setNumber(1);
                this.currentStoredValue.setValue(this.currentValue);
                this.values.add(this.currentStoredValue);
            } else {
                DistinctValue distinctValue = this.currentStoredValue;
                distinctValue.number = distinctValue.number + 1;
            }
        }
    }

    public int getTotalNumber() {
        return this.totalNumber;
    }

    public boolean isNewValue() {
        return this.addedNumber > 1 && !Value.equalValues(this.previousValue, this.currentValue, this.isCompareTolerant());
    }

    public void setTotalNumber(int totalNumber) {
        this.totalNumber = totalNumber;
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public int getCurrentValueNumber() {
        return this.currentValueNumber;
    }

    public double getCurrentRate() {
        if (this.totalNumber < 0) {
            throw new IllegalStateException("Total number is not set");
        }
        return (double)this.currentValueNumber / (double)this.totalNumber;
    }

    public double getPreviousRate() {
        if (this.totalNumber < 0) {
            throw new IllegalStateException("Total number is not set");
        }
        return (double)this.previousValueNumber / (double)this.totalNumber;
    }

    public int getNumber() {
        return this.addedNumber;
    }

    public boolean isCompareTolerant() {
        return this.compareTolerant;
    }

    public void setCompareTolerant(boolean compareTolerant) {
        this.compareTolerant = compareTolerant;
    }

    public double getPreviousValue() {
        return this.previousValue;
    }

    public int getPreviousValueNumber() {
        return this.previousValueNumber;
    }

    public boolean isStoreValues() {
        return this.storeValues;
    }

    public void setStoreValues(boolean storeValues) {
        this.storeValues = storeValues;
        if (storeValues && this.values == null) {
            this.values = new ArrayList();
        }
    }

    public List getValues() {
        return this.values;
    }

    public double getRate(DistinctValue value) {
        return (double)value.getNumber() / (double)this.getNumber();
    }

    public static class DistinctValue {
        private double value = Double.NaN;
        private int number = 0;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }
}

