/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.util.matching.Regex;
import sparklyr.Collectors;
import sparklyr.DaysSinceEpoch;
import sparklyr.Logical;
import sparklyr.Numeric;
import sparklyr.Raw;
import sparklyr.StructTypeAsJSON;
import sparklyr.StructTypeAsJSON$;

public final class Collectors$ {
    public static Collectors$ MODULE$;
    private final Regex ReDecimalType;
    private final Regex ReVectorType;
    private final Regex ReBooleanArrayType;
    private final Regex ReByteArrayType;
    private final Regex ReShortArrayType;
    private final Regex ReIntegerArrayType;
    private final Regex ReLongArrayType;
    private final Regex ReDecimalArrayType;
    private final Regex ReFloatArrayType;
    private final Regex ReDoubleArrayType;
    private final Regex ReStringArrayType;
    private final Regex ReTimestampArrayType;
    private final Regex ReDateArrayType;
    private final Function2<Row, Object, String> collectForceString;
    private final Function2<Row, Object, String> collectString;

    static {
        new Collectors$();
    }

    public Regex ReDecimalType() {
        return this.ReDecimalType;
    }

    public Regex ReVectorType() {
        return this.ReVectorType;
    }

    public Regex ReBooleanArrayType() {
        return this.ReBooleanArrayType;
    }

    public Regex ReByteArrayType() {
        return this.ReByteArrayType;
    }

    public Regex ReShortArrayType() {
        return this.ReShortArrayType;
    }

    public Regex ReIntegerArrayType() {
        return this.ReIntegerArrayType;
    }

    public Regex ReLongArrayType() {
        return this.ReLongArrayType;
    }

    public Regex ReDecimalArrayType() {
        return this.ReDecimalArrayType;
    }

    public Regex ReFloatArrayType() {
        return this.ReFloatArrayType;
    }

    public Regex ReDoubleArrayType() {
        return this.ReDoubleArrayType;
    }

    public Regex ReStringArrayType() {
        return this.ReStringArrayType;
    }

    public Regex ReTimestampArrayType() {
        return this.ReTimestampArrayType;
    }

    public Regex ReDateArrayType() {
        return this.ReDateArrayType;
    }

    public Logical collectLogical(Row row, int idx) {
        return this.extractLogical(row.apply(idx));
    }

    public Logical[] collectLogicalArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (Logical[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractLogical(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Logical.class)))).toArray(ClassTag$.MODULE$.apply(Logical.class));
    }

    private Logical extractLogical(Object x) {
        Object object = x;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new Logical(new RichBoolean(Predef$.MODULE$.booleanWrapper(bl)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }
        return new Logical(Integer.MIN_VALUE);
    }

    public <T> int collectIntegralType(Row row, int idx, Integral<T> evidence$1, ClassTag<T> t) {
        return this.extractIntegralType(row.apply(idx), evidence$1, t);
    }

    public <T> int[] collectIntegralTypeArr(Row row, int idx, Integral<T> evidence$2, ClassTag<T> t) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (int[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.extractIntegralType(x, evidence$2, t)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public Raw collectByteArr(Row row, int idx) {
        int[] intValues = this.collectIntegralTypeArr(row, idx, (Integral)Numeric.ByteIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte());
        if (intValues != null) {
            return new Raw((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(intValues)).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToByte((byte)Collectors$.$anonfun$collectByteArr$1(BoxesRunTime.unboxToInt((Object)x))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).toArray(ClassTag$.MODULE$.Byte()));
        }
        return new Raw(null);
    }

    private <T> int extractIntegralType(Object x, Integral<T> evidence$3, ClassTag<T> t) {
        Object object = x;
        Option option = t.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object) {
            return ((scala.math.Numeric)Predef$.MODULE$.implicitly(evidence$3)).toInt(object);
        }
        return Integer.MIN_VALUE;
    }

    public <T> Numeric collectNumericType(Row row, int idx, scala.math.Numeric<T> evidence$4, ClassTag<T> t) {
        return this.extractNumericType(row.apply(idx), evidence$4, t);
    }

    public <T> Numeric[] collectNumericTypeArr(Row row, int idx, scala.math.Numeric<T> evidence$5, ClassTag<T> t) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (Numeric[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractNumericType(x, evidence$5, t), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    private <T> Numeric extractNumericType(Object x, scala.math.Numeric<T> evidence$6, ClassTag<T> t) {
        Object object;
        Option option;
        return new Numeric((Option<Object>)(x == null ? None$.MODULE$ : (!(option = t.unapply(object = x)).isEmpty() && option.get() instanceof Object ? new Some((Object)BoxesRunTime.boxToDouble((double)((scala.math.Numeric)Predef$.MODULE$.implicitly(evidence$6)).toDouble(object))) : new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN)))));
    }

    public Numeric collectBigDecimal(Row row, int idx) {
        return this.extractBigDecimal(row.apply(idx));
    }

    public Numeric[] collectBigDecimalArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (Numeric[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractBigDecimal(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    private Numeric extractBigDecimal(Object x) {
        None$ none$;
        if (x == null) {
            none$ = None$.MODULE$;
        } else {
            Object object = x;
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                none$ = new Some((Object)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()));
            } else {
                none$ = new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
            }
        }
        return new Numeric((Option<Object>)none$);
    }

    public Function2<Row, Object, String> collectForceString() {
        return this.collectForceString;
    }

    public String[] collectForceStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (String[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractStringRepr(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String extractStringRepr(Object x) {
        if (x == null) {
            return "<NA>";
        }
        return x.toString();
    }

    public Function2<Row, Object, String> collectString() {
        return this.collectString;
    }

    public String[] collectStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (String[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractString(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String extractString(Object x) {
        Object object = x;
        if (object instanceof String) {
            String string = (String)object;
            return string;
        }
        return "<NA>";
    }

    public Object collectVector(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el;
        if (object == null) {
            return Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing());
        }
        if (object instanceof Seq) {
            return ((Seq)el).toArray(ClassTag$.MODULE$.Any());
        }
        return el.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(el, new Object[0]);
    }

    public Object collectJSON(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el;
        if (object instanceof String) {
            return new StructTypeAsJSON((String)el);
        }
        return this.collectDefault(row, idx);
    }

    public Timestamp collectTimestamp(Row row, int idx) {
        return this.extractTimestamp(row.apply(idx));
    }

    public Timestamp[] collectTimestampArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (Timestamp[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractTimestamp(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    private Timestamp extractTimestamp(Object x) {
        Object object = x;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp;
        }
        return null;
    }

    public DaysSinceEpoch collectDate(Row row, int idx) {
        return this.extractDaysSinceEpoch(row.apply(idx));
    }

    public DaysSinceEpoch extractDaysSinceEpoch(Object x) {
        None$ none$;
        Object object = x;
        if (object instanceof Date) {
            Date date = (Date)object;
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date)));
        } else {
            none$ = None$.MODULE$;
        }
        return new DaysSinceEpoch((Option<Object>)none$);
    }

    public DaysSinceEpoch[] collectDateArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        if (arr == null) {
            return null;
        }
        return (DaysSinceEpoch[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractDaysSinceEpoch(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DaysSinceEpoch.class)))).toArray(ClassTag$.MODULE$.apply(DaysSinceEpoch.class));
    }

    public Object collectDefault(Row row, int idx) {
        return row.apply(idx);
    }

    public Collectors.ColumnCtx<? super Logical[]> mkColumnCtx(String colType, Option<Object> initialCapacity) {
        String string = colType;
        if ("BooleanType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectLogical(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Logical.class), initialCapacity);
        }
        if ("ByteType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectIntegralType(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ByteIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())), (Manifest)ManifestFactory$.MODULE$.Int(), initialCapacity);
        }
        if ("ShortType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectIntegralType(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ShortIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Short())), (Manifest)ManifestFactory$.MODULE$.Int(), initialCapacity);
        }
        if ("IntegerType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectIntegralType(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.IntIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int())), (Manifest)ManifestFactory$.MODULE$.Int(), initialCapacity);
        }
        if ("LongType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericType(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Long()), ManifestFactory$.MODULE$.classType(Numeric.class), initialCapacity);
        }
        if ("Decimal".equals(string)) {
            return Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), initialCapacity);
        }
        Option option = this.ReDecimalType().unapplySeq((CharSequence)string);
        if (!option.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBigDecimal(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Numeric.class), initialCapacity);
        }
        if ("FloatType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericType(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Float()), ManifestFactory$.MODULE$.classType(Numeric.class), initialCapacity);
        }
        if ("DoubleType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericType(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()), ManifestFactory$.MODULE$.classType(Numeric.class), initialCapacity);
        }
        if ("StringType".equals(string)) {
            return Collectors$.newColumnCtx$1(this.collectString(), ManifestFactory$.MODULE$.classType(String.class), initialCapacity);
        }
        if ("TimestampType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestamp(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Timestamp.class), initialCapacity);
        }
        if ("CalendarIntervalType".equals(string)) {
            return Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), initialCapacity);
        }
        if ("DateType".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDate(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(DaysSinceEpoch.class), initialCapacity);
        }
        Option option2 = this.ReVectorType().unapplySeq((CharSequence)string);
        if (!option2.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectVector(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), initialCapacity);
        }
        String string2 = StructTypeAsJSON$.MODULE$.DType();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectJSON(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), initialCapacity);
        }
        Option option3 = this.ReBooleanArrayType().unapplySeq((CharSequence)string);
        if (!option3.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectLogicalArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Logical.class)), initialCapacity);
        }
        Option option4 = this.ReByteArrayType().unapplySeq((CharSequence)string);
        if (!option4.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectByteArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Raw.class), initialCapacity);
        }
        Option option5 = this.ReShortArrayType().unapplySeq((CharSequence)string);
        if (!option5.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegralTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ShortIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Short()), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), initialCapacity);
        }
        Option option6 = this.ReIntegerArrayType().unapplySeq((CharSequence)string);
        if (!option6.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegralTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.IntIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), initialCapacity);
        }
        Option option7 = this.ReLongArrayType().unapplySeq((CharSequence)string);
        if (!option7.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Long()), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), initialCapacity);
        }
        Option option8 = this.ReDecimalArrayType().unapplySeq((CharSequence)string);
        if (!option8.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBigDecimalArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), initialCapacity);
        }
        Option option9 = this.ReFloatArrayType().unapplySeq((CharSequence)string);
        if (!option9.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Float()), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), initialCapacity);
        }
        Option option10 = this.ReDoubleArrayType().unapplySeq((CharSequence)string);
        if (!option10.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), initialCapacity);
        }
        Option option11 = this.ReStringArrayType().unapplySeq((CharSequence)string);
        if (!option11.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), initialCapacity);
        }
        Option option12 = this.ReTimestampArrayType().unapplySeq((CharSequence)string);
        if (!option12.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestampArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Timestamp.class)), initialCapacity);
        }
        Option option13 = this.ReDateArrayType().unapplySeq((CharSequence)string);
        if (!option13.isEmpty()) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDateArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(DaysSinceEpoch.class)), initialCapacity);
        }
        if ("ArrayType(CalendarIntervalType,true)".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectForceStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), initialCapacity);
        }
        if ("ArrayType(CalendarIntervalType,false)".equals(string)) {
            return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectForceStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), initialCapacity);
        }
        if ("NullType".equals(string)) {
            return Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), initialCapacity);
        }
        return Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDefault(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), initialCapacity);
    }

    public static final /* synthetic */ byte $anonfun$collectByteArr$1(int x) {
        return (byte)x;
    }

    private static final Collectors.ColumnCtx newColumnCtx$1(Function2 collector, Manifest evidence$8, Option initialCapacity$1) {
        return new Collectors.ColumnCtx(collector, (Option<Object>)initialCapacity$1, evidence$8);
    }

    private Collectors$() {
        MODULE$ = this;
        this.ReDecimalType = new StringOps(Predef$.MODULE$.augmentString("(^DecimalType(\\(.*\\)?)$)")).r();
        this.ReVectorType = new StringOps(Predef$.MODULE$.augmentString("(.*VectorUDT.*)")).r();
        this.ReBooleanArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(BooleanType,(true|false)\\)$)")).r();
        this.ReByteArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(ByteType,(true|false)\\)$)")).r();
        this.ReShortArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(ShortType,(true|false)\\)$)")).r();
        this.ReIntegerArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(IntegerType,(true|false)\\)$)")).r();
        this.ReLongArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(LongType,(true|false)\\)$)")).r();
        this.ReDecimalArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(DecimalType(\\(.*\\)?),(true|false)\\)$)")).r();
        this.ReFloatArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(FloatType,(true|false)\\)$)")).r();
        this.ReDoubleArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(DoubleType,(true|false)\\)$)")).r();
        this.ReStringArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(StringType,(true|false)\\)$)")).r();
        this.ReTimestampArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(TimestampType,(true|false)\\)$)")).r();
        this.ReDateArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(DateType,(true|false)\\)$)")).r();
        this.collectForceString = (Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.extractStringRepr(row.apply(BoxesRunTime.unboxToInt((Object)idx)));
        this.collectString = (Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.extractString(row.apply(BoxesRunTime.unboxToInt((Object)idx)));
    }
}

