/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.oneclass;

import com.yahoo.labs.samoa.instances.Instance;
import java.io.Serializable;

public class HSTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HSTreeNode left;
    private HSTreeNode right;
    private int splitAttribute;
    private int r = 0;
    private int l = 0;
    private int dimensions;
    private int depth;
    private double splitValue;
    private boolean internalNode;

    public HSTreeNode(double[] min, double[] max, int k, int maxDepth) {
        this.dimensions = min.length;
        this.depth = k;
        if (this.depth < maxDepth) {
            this.internalNode = true;
            this.splitAttribute = (int)Math.floor(Math.random() * (double)this.dimensions);
            this.splitValue = (min[this.splitAttribute] + max[this.splitAttribute]) / 2.0;
            double temp = max[this.splitAttribute];
            max[this.splitAttribute] = this.splitValue;
            this.left = new HSTreeNode(min, max, k + 1, maxDepth);
            max[this.splitAttribute] = temp;
            min[this.splitAttribute] = this.splitValue;
            this.right = new HSTreeNode(min, max, k + 1, maxDepth);
        } else {
            this.splitAttribute = -1;
            this.internalNode = false;
        }
    }

    public void updateMass(Instance inst, boolean referenceWindow) {
        if (referenceWindow) {
            ++this.r;
        } else {
            ++this.l;
        }
        if (this.internalNode) {
            if (inst.value(this.splitAttribute) > this.splitValue) {
                this.right.updateMass(inst, referenceWindow);
            } else {
                this.left.updateMass(inst, referenceWindow);
            }
        }
    }

    public void updateModel() {
        this.r = this.l;
        this.l = 0;
        if (this.internalNode) {
            this.left.updateModel();
            this.right.updateModel();
        }
    }

    public double score(Instance inst, int sizeLimit) {
        double anomalyScore = 0.0;
        anomalyScore = this.internalNode && this.r > sizeLimit ? (inst.value(this.splitAttribute) > this.splitValue ? this.right.score(inst, sizeLimit) : this.left.score(inst, sizeLimit)) : (double)this.r * Math.pow(2.0, this.depth);
        return anomalyScore;
    }

    protected void printNode() {
        System.out.println(this.depth + ", " + this.splitAttribute + ", " + this.splitValue + ", " + this.r);
        if (this.internalNode) {
            this.right.printNode();
            this.left.printNode();
        }
    }
}

