/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import java.util.Random;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.core.InstanceExample;
import moa.streams.generators.RandomRBFGenerator;

public class RandomRBFGeneratorDrift
extends RandomRBFGenerator {
    private static final long serialVersionUID = 1L;
    public FloatOption speedChangeOption = new FloatOption("speedChange", 's', "Speed of change of centroids in the model.", 0.0, 0.0, 3.4028234663852886E38);
    public IntOption numDriftCentroidsOption = new IntOption("numDriftCentroids", 'k', "The number of centroids with drift.", 50, 0, Integer.MAX_VALUE);
    protected double[][] speedCentroids;

    @Override
    public String getPurposeString() {
        return "Generates a random radial basis function stream with drift.";
    }

    @Override
    public InstanceExample nextInstance() {
        int len = this.numDriftCentroidsOption.getValue();
        if (len > this.centroids.length) {
            len = this.centroids.length;
        }
        for (int j = 0; j < len; ++j) {
            for (int i = 0; i < this.numAttsOption.getValue(); ++i) {
                int n = i;
                this.centroids[j].centre[n] = this.centroids[j].centre[n] + this.speedCentroids[j][i] * this.speedChangeOption.getValue();
                if (this.centroids[j].centre[i] > 1.0) {
                    this.centroids[j].centre[i] = 1.0;
                    this.speedCentroids[j][i] = -this.speedCentroids[j][i];
                }
                if (!(this.centroids[j].centre[i] < 0.0)) continue;
                this.centroids[j].centre[i] = 0.0;
                this.speedCentroids[j][i] = -this.speedCentroids[j][i];
            }
        }
        return super.nextInstance();
    }

    @Override
    protected void generateCentroids() {
        super.generateCentroids();
        Random modelRand = new Random(this.modelRandomSeedOption.getValue());
        int len = this.numDriftCentroidsOption.getValue();
        if (len > this.centroids.length) {
            len = this.centroids.length;
        }
        this.speedCentroids = new double[len][this.numAttsOption.getValue()];
        for (int i = 0; i < len; ++i) {
            int j;
            double[] randSpeed = new double[this.numAttsOption.getValue()];
            double normSpeed = 0.0;
            for (j = 0; j < randSpeed.length; ++j) {
                randSpeed[j] = modelRand.nextDouble();
                normSpeed += randSpeed[j] * randSpeed[j];
            }
            normSpeed = Math.sqrt(normSpeed);
            j = 0;
            while (j < randSpeed.length) {
                int n = j++;
                randSpeed[n] = randSpeed[n] / normSpeed;
            }
            this.speedCentroids[i] = randSpeed;
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == RandomRBFGeneratorDrift.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }
}

