/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibLeaseCoordinator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ParentsFirstShardPrioritization;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardConsumer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardConsumerShutdownNotification;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardPrioritization;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTaskManager;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownFuture;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.StreamConfig;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.V1ToV2RecordProcessorFactoryAdapter;
import com.amazonaws.services.kinesis.clientlibrary.proxies.KinesisProxyFactory;
import com.amazonaws.services.kinesis.leases.exceptions.LeasingException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseManager;
import com.amazonaws.services.kinesis.metrics.impl.CWMetricsFactory;
import com.amazonaws.services.kinesis.metrics.impl.NullMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Worker
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Worker.class);
    private static final int MAX_INITIALIZATION_ATTEMPTS = 20;
    private WorkerLog wlog = new WorkerLog();
    private final String applicationName;
    private final com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory;
    private final StreamConfig streamConfig;
    private final InitialPositionInStreamExtended initialPosition;
    private final ICheckpoint checkpointTracker;
    private final long idleTimeInMilliseconds;
    private final long parentShardPollIntervalMillis;
    private final ExecutorService executorService;
    private final IMetricsFactory metricsFactory;
    private final long taskBackoffTimeMillis;
    private final long failoverTimeMillis;
    private final KinesisClientLibLeaseCoordinator leaseCoordinator;
    private final ShardSyncTaskManager controlServer;
    private final ShardPrioritization shardPrioritization;
    private volatile boolean shutdown;
    private volatile long shutdownStartTimeMillis;
    private volatile boolean shutdownComplete = false;
    private ConcurrentMap<ShardInfo, ShardConsumer> shardInfoShardConsumerMap = new ConcurrentHashMap<ShardInfo, ShardConsumer>();
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean skipShardSyncAtWorkerInitializationIfLeasesExist;

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config) {
        this(recordProcessorFactory, config, Worker.getExecutorService());
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        this(recordProcessorFactory, config, new AmazonKinesisClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration()), new AmazonDynamoDBClient(config.getDynamoDBCredentialsProvider(), config.getDynamoDBClientConfiguration()), new AmazonCloudWatchClient(config.getCloudWatchCredentialsProvider(), config.getCloudWatchClientConfiguration()), execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, IMetricsFactory metricsFactory) {
        this(recordProcessorFactory, config, metricsFactory, Worker.getExecutorService());
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, IMetricsFactory metricsFactory, ExecutorService execService) {
        this(recordProcessorFactory, config, new AmazonKinesisClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration()), new AmazonDynamoDBClient(config.getDynamoDBCredentialsProvider(), config.getDynamoDBClientConfiguration()), metricsFactory, execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesis kinesisClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        this(recordProcessorFactory, config, kinesisClient, dynamoDBClient, cloudWatchClient, Worker.getExecutorService());
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesis kinesisClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        this(recordProcessorFactory, config, kinesisClient, dynamoDBClient, Worker.getMetricsFactory(cloudWatchClient, config), execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesis kinesisClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        this(config.getApplicationName(), new V1ToV2RecordProcessorFactoryAdapter(recordProcessorFactory), new StreamConfig(new KinesisProxyFactory(config.getKinesisCredentialsProvider(), kinesisClient).getProxy(config.getStreamName()), config.getMaxRecords(), config.getIdleTimeBetweenReadsInMillis(), config.shouldCallProcessRecordsEvenForEmptyRecordList(), config.shouldValidateSequenceNumberBeforeCheckpointing(), config.getInitialPositionInStreamExtended()), config.getInitialPositionInStreamExtended(), config.getParentShardPollIntervalMillis(), config.getShardSyncIntervalMillis(), config.shouldCleanupLeasesUponShardCompletion(), null, new KinesisClientLibLeaseCoordinator(new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient), config.getWorkerIdentifier(), config.getFailoverTimeMillis(), config.getEpsilonMillis(), config.getMaxLeasesForWorker(), config.getMaxLeasesToStealAtOneTime(), metricsFactory).withInitialLeaseTableReadCapacity(config.getInitialLeaseTableReadCapacity()).withInitialLeaseTableWriteCapacity(config.getInitialLeaseTableWriteCapacity()), execService, metricsFactory, config.getTaskBackoffTimeMillis(), config.getFailoverTimeMillis(), config.getSkipShardSyncAtWorkerInitializationIfLeasesExist(), config.getShardPrioritizationStrategy());
        if (config.getRegionName() != null) {
            Region region = RegionUtils.getRegion((String)config.getRegionName());
            kinesisClient.setRegion(region);
            LOG.debug((Object)("The region of Amazon Kinesis client has been set to " + config.getRegionName()));
            dynamoDBClient.setRegion(region);
            LOG.debug((Object)("The region of Amazon DynamoDB client has been set to " + config.getRegionName()));
        }
        if (config.getDynamoDBEndpoint() != null) {
            dynamoDBClient.setEndpoint(config.getDynamoDBEndpoint());
            LOG.debug((Object)("The endpoint of Amazon DynamoDB client has been set to " + config.getDynamoDBEndpoint()));
        }
        if (config.getKinesisEndpoint() != null) {
            kinesisClient.setEndpoint(config.getKinesisEndpoint());
            if (config.getRegionName() != null) {
                LOG.warn((Object)("Received configuration for both region name as " + config.getRegionName() + ", and Amazon Kinesis endpoint as " + config.getKinesisEndpoint() + ". Amazon Kinesis endpoint will overwrite region name."));
                LOG.debug((Object)("The region of Amazon Kinesis client has been overwritten to " + config.getKinesisEndpoint()));
            } else {
                LOG.debug((Object)("The region of Amazon Kinesis client has been set to " + config.getKinesisEndpoint()));
            }
        }
    }

    Worker(String applicationName, com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory, StreamConfig streamConfig, InitialPositionInStreamExtended initialPositionInStream, long parentShardPollIntervalMillis, long shardSyncIdleTimeMillis, boolean cleanupLeasesUponShardCompletion, ICheckpoint checkpoint, KinesisClientLibLeaseCoordinator leaseCoordinator, ExecutorService execService, IMetricsFactory metricsFactory, long taskBackoffTimeMillis, long failoverTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, ShardPrioritization shardPrioritization) {
        this.applicationName = applicationName;
        this.recordProcessorFactory = recordProcessorFactory;
        this.streamConfig = streamConfig;
        this.initialPosition = initialPositionInStream;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.checkpointTracker = checkpoint != null ? checkpoint : leaseCoordinator;
        this.idleTimeInMilliseconds = streamConfig.getIdleTimeInMilliseconds();
        this.executorService = execService;
        this.leaseCoordinator = leaseCoordinator;
        this.metricsFactory = metricsFactory;
        this.controlServer = new ShardSyncTaskManager(streamConfig.getStreamProxy(), leaseCoordinator.getLeaseManager(), initialPositionInStream, cleanupLeasesUponShardCompletion, shardSyncIdleTimeMillis, metricsFactory, this.executorService);
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        this.failoverTimeMillis = failoverTimeMillis;
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
        this.shardPrioritization = shardPrioritization;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void run() {
        if (this.shutdown) {
            return;
        }
        try {
            this.initialize();
            LOG.info((Object)"Initialization complete. Starting worker loop.");
        }
        catch (RuntimeException e1) {
            LOG.error((Object)"Unable to initialize after 20 attempts. Shutting down.", (Throwable)e1);
            this.shutdown();
        }
        while (!this.shouldShutdown()) {
            this.runProcessLoop();
        }
        this.finalShutdown();
        LOG.info((Object)"Worker loop is complete. Exiting from worker.");
    }

    @VisibleForTesting
    void runProcessLoop() {
        try {
            boolean foundCompletedShard = false;
            HashSet<ShardInfo> assignedShards = new HashSet<ShardInfo>();
            for (ShardInfo shardInfo : this.getShardInfoForAssignments()) {
                ShardConsumer shardConsumer = this.createOrGetShardConsumer(shardInfo, this.recordProcessorFactory);
                if (shardConsumer.isShutdown() && shardConsumer.getShutdownReason().equals((Object)ShutdownReason.TERMINATE)) {
                    foundCompletedShard = true;
                } else {
                    shardConsumer.consumeShard();
                }
                assignedShards.add(shardInfo);
            }
            if (foundCompletedShard) {
                this.controlServer.syncShardAndLeaseInfo(null);
            }
            this.cleanupShardConsumers(assignedShards);
            this.wlog.info("Sleeping ...");
            Thread.sleep(this.idleTimeInMilliseconds);
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Worker.run caught exception, sleeping for %s milli seconds!", String.valueOf(this.idleTimeInMilliseconds)), (Throwable)e);
            try {
                Thread.sleep(this.idleTimeInMilliseconds);
            }
            catch (InterruptedException ex) {
                LOG.info((Object)"Worker: sleep interrupted after catching exception ", (Throwable)ex);
            }
        }
        this.wlog.resetInfoLogging();
    }

    private void initialize() {
        boolean isDone = false;
        Exception lastException = null;
        for (int i = 0; !isDone && i < 20; ++i) {
            try {
                LOG.info((Object)("Initialization attempt " + (i + 1)));
                LOG.info((Object)"Initializing LeaseCoordinator");
                this.leaseCoordinator.initialize();
                TaskResult result = null;
                if (!this.skipShardSyncAtWorkerInitializationIfLeasesExist || this.leaseCoordinator.getLeaseManager().isLeaseTableEmpty()) {
                    LOG.info((Object)"Syncing Kinesis shard info");
                    ShardSyncTask shardSyncTask = new ShardSyncTask(this.streamConfig.getStreamProxy(), this.leaseCoordinator.getLeaseManager(), this.initialPosition, this.cleanupLeasesUponShardCompletion, 0L);
                    result = new MetricsCollectingTaskDecorator(shardSyncTask, this.metricsFactory).call();
                } else {
                    LOG.info((Object)"Skipping shard sync per config setting (and lease table is not empty)");
                }
                if (result == null || result.getException() == null) {
                    if (!this.leaseCoordinator.isRunning()) {
                        LOG.info((Object)"Starting LeaseCoordinator");
                        this.leaseCoordinator.start();
                    } else {
                        LOG.info((Object)"LeaseCoordinator is already running. No need to start it.");
                    }
                    isDone = true;
                } else {
                    lastException = result.getException();
                }
            }
            catch (LeasingException e) {
                LOG.error((Object)"Caught exception when initializing LeaseCoordinator", (Throwable)e);
                lastException = e;
            }
            catch (Exception e) {
                lastException = e;
            }
            try {
                Thread.sleep(this.parentShardPollIntervalMillis);
                continue;
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Sleep interrupted while initializing worker.");
            }
        }
        if (!isDone) {
            throw new RuntimeException(lastException);
        }
    }

    void cleanupShardConsumers(Set<ShardInfo> assignedShards) {
        for (ShardInfo shard : this.shardInfoShardConsumerMap.keySet()) {
            boolean isShutdown;
            if (assignedShards.contains(shard) || !(isShutdown = ((ShardConsumer)this.shardInfoShardConsumerMap.get(shard)).beginShutdown())) continue;
            this.shardInfoShardConsumerMap.remove(shard);
        }
    }

    private List<ShardInfo> getShardInfoForAssignments() {
        List<ShardInfo> assignedStreamShards = this.leaseCoordinator.getCurrentAssignments();
        List<ShardInfo> prioritizedShards = this.shardPrioritization.prioritize(assignedStreamShards);
        if (prioritizedShards != null && !prioritizedShards.isEmpty()) {
            if (this.wlog.isInfoEnabled()) {
                StringBuilder builder = new StringBuilder();
                boolean firstItem = true;
                for (ShardInfo shardInfo : prioritizedShards) {
                    if (!firstItem) {
                        builder.append(", ");
                    }
                    builder.append(shardInfo.getShardId());
                    firstItem = false;
                }
                this.wlog.info("Current stream shard assignments: " + builder.toString());
            }
        } else {
            this.wlog.info("No activities assigned");
        }
        return prioritizedShards;
    }

    public Future<Void> requestShutdown() {
        this.leaseCoordinator.stopLeaseTaker();
        Collection leases = this.leaseCoordinator.getAssignments();
        if (leases == null || leases.isEmpty()) {
            this.shutdown();
            return Futures.immediateFuture(null);
        }
        CountDownLatch shutdownCompleteLatch = new CountDownLatch(leases.size());
        CountDownLatch notificationCompleteLatch = new CountDownLatch(leases.size());
        for (KinesisClientLease lease : leases) {
            ShardConsumerShutdownNotification shutdownNotification = new ShardConsumerShutdownNotification(this.leaseCoordinator, lease, notificationCompleteLatch, shutdownCompleteLatch);
            ShardInfo shardInfo = KinesisClientLibLeaseCoordinator.convertLeaseToAssignment(lease);
            ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shardInfo);
            if (consumer != null) {
                consumer.notifyShutdownRequested(shutdownNotification);
                continue;
            }
            notificationCompleteLatch.countDown();
            shutdownCompleteLatch.countDown();
        }
        return new ShutdownFuture(shutdownCompleteLatch, notificationCompleteLatch, this);
    }

    boolean isShutdownComplete() {
        return this.shutdownComplete;
    }

    ConcurrentMap<ShardInfo, ShardConsumer> getShardInfoShardConsumerMap() {
        return this.shardInfoShardConsumerMap;
    }

    public void shutdown() {
        if (this.shutdown) {
            LOG.warn((Object)"Shutdown requested a second time.");
            return;
        }
        LOG.info((Object)"Worker shutdown requested.");
        this.shutdown = true;
        this.shutdownStartTimeMillis = System.currentTimeMillis();
        this.leaseCoordinator.stop();
    }

    private void finalShutdown() {
        LOG.info((Object)"Starting worker's final shutdown.");
        if (this.executorService instanceof WorkerThreadPoolExecutor) {
            this.executorService.shutdownNow();
        }
        if (this.metricsFactory instanceof WorkerCWMetricsFactory) {
            ((CWMetricsFactory)this.metricsFactory).shutdown();
        }
        this.shutdownComplete = true;
    }

    @VisibleForTesting
    boolean shouldShutdown() {
        if (this.executorService.isShutdown()) {
            LOG.error((Object)"Worker executor service has been shutdown, so record processors cannot be shutdown.");
            return true;
        }
        if (this.shutdown) {
            if (this.shardInfoShardConsumerMap.isEmpty()) {
                LOG.info((Object)"All record processors have been shutdown successfully.");
                return true;
            }
            if (System.currentTimeMillis() - this.shutdownStartTimeMillis >= this.failoverTimeMillis) {
                LOG.info((Object)"Lease failover time is reached, so forcing shutdown.");
                return true;
            }
        }
        return false;
    }

    ShardConsumer createOrGetShardConsumer(ShardInfo shardInfo, com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory factory) {
        ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shardInfo);
        if (consumer == null || consumer.isShutdown() && consumer.getShutdownReason().equals((Object)ShutdownReason.ZOMBIE)) {
            consumer = this.buildConsumer(shardInfo, factory);
            this.shardInfoShardConsumerMap.put(shardInfo, consumer);
            this.wlog.infoForce("Created new shardConsumer for : " + shardInfo);
        }
        return consumer;
    }

    protected ShardConsumer buildConsumer(ShardInfo shardInfo, com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory factory) {
        IRecordProcessor recordProcessor = factory.createProcessor();
        return new ShardConsumer(shardInfo, this.streamConfig, this.checkpointTracker, recordProcessor, this.leaseCoordinator.getLeaseManager(), this.parentShardPollIntervalMillis, this.cleanupLeasesUponShardCompletion, this.executorService, this.metricsFactory, this.taskBackoffTimeMillis, this.skipShardSyncAtWorkerInitializationIfLeasesExist);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesisClient kinesisClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        this(recordProcessorFactory, config, (AmazonKinesis)kinesisClient, (AmazonDynamoDB)dynamoDBClient, (AmazonCloudWatch)cloudWatchClient);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesisClient kinesisClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        this(recordProcessorFactory, config, (AmazonKinesis)kinesisClient, (AmazonDynamoDB)dynamoDBClient, (AmazonCloudWatch)cloudWatchClient, execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesisClient kinesisClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        this(recordProcessorFactory, config, (AmazonKinesis)kinesisClient, (AmazonDynamoDB)dynamoDBClient, metricsFactory, execService);
    }

    private static IMetricsFactory getMetricsFactory(AmazonCloudWatch cloudWatchClient, KinesisClientLibConfiguration config) {
        IMetricsFactory metricsFactory;
        if (config.getMetricsLevel() == MetricsLevel.NONE) {
            metricsFactory = new NullMetricsFactory();
        } else {
            if (config.getRegionName() != null) {
                Region region = RegionUtils.getRegion((String)config.getRegionName());
                cloudWatchClient.setRegion(region);
                LOG.debug((Object)("The region of Amazon CloudWatch client has been set to " + config.getRegionName()));
            }
            metricsFactory = new WorkerCWMetricsFactory(cloudWatchClient, config.getApplicationName(), config.getMetricsBufferTimeMillis(), config.getMetricsMaxQueueSize(), config.getMetricsLevel(), config.getMetricsEnabledDimensions());
        }
        return metricsFactory;
    }

    private static ExecutorService getExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RecordProcessor-%04d").build();
        return new WorkerThreadPoolExecutor(threadFactory);
    }

    public static class Builder {
        private com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory;
        private KinesisClientLibConfiguration config;
        private AmazonKinesis kinesisClient;
        private AmazonDynamoDB dynamoDBClient;
        private AmazonCloudWatch cloudWatchClient;
        private IMetricsFactory metricsFactory;
        private ExecutorService execService;
        private ShardPrioritization shardPrioritization;

        public Builder recordProcessorFactory(IRecordProcessorFactory recordProcessorFactory) {
            this.recordProcessorFactory = new V1ToV2RecordProcessorFactoryAdapter(recordProcessorFactory);
            return this;
        }

        public Builder recordProcessorFactory(com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory) {
            this.recordProcessorFactory = recordProcessorFactory;
            return this;
        }

        public Builder config(KinesisClientLibConfiguration config) {
            this.config = config;
            return this;
        }

        public Builder kinesisClient(AmazonKinesis kinesisClient) {
            this.kinesisClient = kinesisClient;
            return this;
        }

        public Builder dynamoDBClient(AmazonDynamoDB dynamoDBClient) {
            this.dynamoDBClient = dynamoDBClient;
            return this;
        }

        public Builder cloudWatchClient(AmazonCloudWatch cloudWatchClient) {
            this.cloudWatchClient = cloudWatchClient;
            return this;
        }

        public Builder metricsFactory(IMetricsFactory metricsFactory) {
            this.metricsFactory = metricsFactory;
            return this;
        }

        public Builder execService(ExecutorService execService) {
            this.execService = execService;
            return this;
        }

        public Builder shardPrioritization(ShardPrioritization shardPrioritization) {
            this.shardPrioritization = shardPrioritization;
            return this;
        }

        public Worker build() {
            if (this.config == null) {
                throw new IllegalArgumentException("Kinesis Client Library configuration needs to be provided to build Worker");
            }
            if (this.recordProcessorFactory == null) {
                throw new IllegalArgumentException("A Record Processor Factory needs to be provided to build Worker");
            }
            if (this.execService == null) {
                this.execService = Worker.getExecutorService();
            }
            if (this.kinesisClient == null) {
                this.kinesisClient = new AmazonKinesisClient(this.config.getKinesisCredentialsProvider(), this.config.getKinesisClientConfiguration());
            }
            if (this.dynamoDBClient == null) {
                this.dynamoDBClient = new AmazonDynamoDBClient(this.config.getDynamoDBCredentialsProvider(), this.config.getDynamoDBClientConfiguration());
            }
            if (this.cloudWatchClient == null) {
                this.cloudWatchClient = new AmazonCloudWatchClient(this.config.getCloudWatchCredentialsProvider(), this.config.getCloudWatchClientConfiguration());
            }
            if (this.config.getRegionName() != null) {
                Region region = RegionUtils.getRegion((String)this.config.getRegionName());
                this.cloudWatchClient.setRegion(region);
                LOG.debug((Object)("The region of Amazon CloudWatch client has been set to " + this.config.getRegionName()));
                this.kinesisClient.setRegion(region);
                LOG.debug((Object)("The region of Amazon Kinesis client has been set to " + this.config.getRegionName()));
                this.dynamoDBClient.setRegion(region);
                LOG.debug((Object)("The region of Amazon DynamoDB client has been set to " + this.config.getRegionName()));
            }
            if (this.config.getDynamoDBEndpoint() != null) {
                this.dynamoDBClient.setEndpoint(this.config.getDynamoDBEndpoint());
                LOG.debug((Object)("The endpoint of Amazon DynamoDB client has been set to " + this.config.getDynamoDBEndpoint()));
            }
            if (this.config.getKinesisEndpoint() != null) {
                this.kinesisClient.setEndpoint(this.config.getKinesisEndpoint());
                if (this.config.getRegionName() != null) {
                    LOG.warn((Object)("Received configuration for both region name as " + this.config.getRegionName() + ", and Amazon Kinesis endpoint as " + this.config.getKinesisEndpoint() + ". Amazon Kinesis endpoint will overwrite region name."));
                    LOG.debug((Object)("The region of Amazon Kinesis client has been overwritten to " + this.config.getKinesisEndpoint()));
                } else {
                    LOG.debug((Object)("The region of Amazon Kinesis client has been set to " + this.config.getKinesisEndpoint()));
                }
            }
            if (this.metricsFactory == null) {
                this.metricsFactory = Worker.getMetricsFactory(this.cloudWatchClient, this.config);
            }
            if (this.shardPrioritization == null) {
                this.shardPrioritization = new ParentsFirstShardPrioritization(1);
            }
            return new Worker(this.config.getApplicationName(), this.recordProcessorFactory, new StreamConfig(new KinesisProxyFactory(this.config.getKinesisCredentialsProvider(), this.kinesisClient).getProxy(this.config.getStreamName()), this.config.getMaxRecords(), this.config.getIdleTimeBetweenReadsInMillis(), this.config.shouldCallProcessRecordsEvenForEmptyRecordList(), this.config.shouldValidateSequenceNumberBeforeCheckpointing(), this.config.getInitialPositionInStreamExtended()), this.config.getInitialPositionInStreamExtended(), this.config.getParentShardPollIntervalMillis(), this.config.getShardSyncIntervalMillis(), this.config.shouldCleanupLeasesUponShardCompletion(), null, new KinesisClientLibLeaseCoordinator(new KinesisClientLeaseManager(this.config.getTableName(), this.dynamoDBClient), this.config.getWorkerIdentifier(), this.config.getFailoverTimeMillis(), this.config.getEpsilonMillis(), this.config.getMaxLeasesForWorker(), this.config.getMaxLeasesToStealAtOneTime(), this.metricsFactory).withInitialLeaseTableReadCapacity(this.config.getInitialLeaseTableReadCapacity()).withInitialLeaseTableWriteCapacity(this.config.getInitialLeaseTableWriteCapacity()), this.execService, this.metricsFactory, this.config.getTaskBackoffTimeMillis(), this.config.getFailoverTimeMillis(), this.config.getSkipShardSyncAtWorkerInitializationIfLeasesExist(), this.shardPrioritization);
        }
    }

    static class WorkerThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;

        WorkerThreadPoolExecutor(ThreadFactory threadFactory) {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
    }

    static class WorkerCWMetricsFactory
    extends CWMetricsFactory {
        WorkerCWMetricsFactory(AmazonCloudWatch cloudWatchClient, String namespace, long bufferTimeMillis, int maxQueueSize, MetricsLevel metricsLevel, Set<String> metricsEnabledDimensions) {
            super(cloudWatchClient, namespace, bufferTimeMillis, maxQueueSize, metricsLevel, metricsEnabledDimensions);
        }
    }

    private static class WorkerLog {
        private long reportIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
        private long nextReportTime = System.currentTimeMillis() + this.reportIntervalMillis;
        private boolean infoReporting;

        private WorkerLog() {
        }

        public void debug(Object message, Throwable t) {
            LOG.debug(message, t);
        }

        public void info(Object message) {
            if (this.isInfoEnabled()) {
                LOG.info(message);
            }
        }

        public void infoForce(Object message) {
            LOG.info(message);
        }

        public void warn(Object message) {
            LOG.warn(message);
        }

        public void error(Object message, Throwable t) {
            LOG.error(message, t);
        }

        private boolean isInfoEnabled() {
            return this.infoReporting;
        }

        private void resetInfoLogging() {
            if (this.infoReporting) {
                if (LOG.isInfoEnabled()) {
                    this.infoReporting = false;
                    this.nextReportTime = System.currentTimeMillis() + this.reportIntervalMillis;
                }
            } else if (this.nextReportTime <= System.currentTimeMillis()) {
                this.infoReporting = true;
            }
        }
    }
}

