/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MachineAccuracy;
import dr.math.NumericalDerivative;
import dr.math.UnivariateFunction;

public class UnivariateMinimum {
    public double minx;
    public double fminx;
    public double f2minx;
    public int numFun;
    public int maxFun = 0;
    private static final double C = (3.0 - Math.sqrt(5.0)) / 2.0;
    private static final double GOLD = (Math.sqrt(5.0) + 1.0) / 2.0;
    private static final double delta = 0.01;

    public double findMinimum(double d, UnivariateFunction univariateFunction) {
        double d2 = MachineAccuracy.EPSILON;
        return this.optimize(d, univariateFunction, d2);
    }

    public double findMinimum(double d, UnivariateFunction univariateFunction, int n) {
        double d2 = Math.pow(10.0, -1 - n);
        double d3 = this.optimize(d, univariateFunction, d2);
        return d3;
    }

    public double findMinimum(UnivariateFunction univariateFunction) {
        double d = MachineAccuracy.EPSILON;
        return this.optimize(univariateFunction, d);
    }

    public double findMinimum(UnivariateFunction univariateFunction, int n) {
        double d = Math.pow(10.0, -1 - n);
        double d2 = this.optimize(univariateFunction, d);
        return d2;
    }

    public double optimize(UnivariateFunction univariateFunction, double d, double d2, double d3) {
        this.numFun = 2;
        return this.minin(d2, d3, univariateFunction.evaluate(d2), univariateFunction.evaluate(d3), univariateFunction, d);
    }

    public double optimize(UnivariateFunction univariateFunction, double d) {
        return this.optimize(univariateFunction, d, univariateFunction.getLowerBound(), univariateFunction.getUpperBound());
    }

    public double optimize(double d, UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        double[] dArray = this.bracketize(d3, d, d4, univariateFunction);
        return this.minin(dArray[0], dArray[1], dArray[2], dArray[3], univariateFunction, d2);
    }

    public double optimize(double d, UnivariateFunction univariateFunction, double d2) {
        return this.optimize(d, univariateFunction, d2, univariateFunction.getLowerBound(), univariateFunction.getUpperBound());
    }

    private double constrain(double d, boolean bl, double d2, double d3) {
        if (bl) {
            if (d > d3) {
                return d3;
            }
            return d;
        }
        if (d < d2) {
            return d2;
        }
        return d;
    }

    private double[] bracketize(double d, double d2, double d3, UnivariateFunction univariateFunction) {
        double d4;
        boolean bl;
        if (d > d3) {
            throw new IllegalArgumentException("Argument min (" + d + ") larger than argument max (" + d3 + ")");
        }
        if (d2 < d) {
            d2 = d;
        } else if (d2 > d3) {
            d2 = d3;
        }
        if (d2 < d || d2 > d3) {
            throw new IllegalArgumentException("Starting point not in given range (" + d + ", " + d2 + ", " + d3 + ")");
        }
        double d5 = d2 - d < d3 - d2 ? d2 + 0.01 * (d3 - d2) : d2 - 0.01 * (d2 - d);
        this.numFun = 0;
        double d6 = univariateFunction.evaluate(d2);
        ++this.numFun;
        double d7 = univariateFunction.evaluate(d5);
        ++this.numFun;
        if (d7 > d6) {
            double d8 = d2;
            d2 = d5;
            d5 = d8;
            d8 = d6;
            d6 = d7;
            d7 = d8;
        }
        if (d5 > d2) {
            bl = true;
            d4 = d3;
        } else {
            bl = false;
            d4 = d;
        }
        double d9 = d5 + GOLD * (d5 - d2);
        d9 = this.constrain(d9, bl, d, d3);
        double d10 = univariateFunction.evaluate(d9);
        ++this.numFun;
        while (d7 > d10) {
            double d11 = (d5 - d9) * (d7 - d6);
            double d12 = (d5 - d2) * (d7 - d10);
            if (d11 == d12) {
                d11 += MachineAccuracy.EPSILON;
            }
            double d13 = d5 - ((d5 - d9) * d11 - (d5 - d2) * d12) / 2.0 / (d11 - d12);
            d13 = this.constrain(d13, bl, d, d3);
            double d14 = 0.0;
            boolean bl2 = false;
            if ((d5 - d13) * (d13 - d9) > 0.0) {
                d14 = univariateFunction.evaluate(d13);
                ++this.numFun;
                if (d14 < d10) {
                    d2 = d5;
                    d5 = d13;
                    d6 = d7;
                    d7 = d14;
                    break;
                }
                if (d14 > d7) {
                    d9 = d13;
                    d10 = d14;
                    break;
                }
                bl2 = true;
            } else if ((d9 - d13) * (d13 - d4) > 0.0) {
                d14 = univariateFunction.evaluate(d13);
                ++this.numFun;
                if (d14 < d10) {
                    d5 = d9;
                    d9 = d13;
                    d7 = d10;
                    d10 = d14;
                    bl2 = true;
                }
            } else if (d13 == d4) {
                d14 = univariateFunction.evaluate(d13);
                ++this.numFun;
            } else {
                bl2 = true;
            }
            if (bl2) {
                d13 = d9 + GOLD * (d9 - d5);
                d13 = this.constrain(d13, bl, d, d3);
                d14 = univariateFunction.evaluate(d13);
                ++this.numFun;
            }
            d2 = d5;
            d5 = d9;
            d9 = d13;
            d6 = d7;
            d7 = d10;
            d10 = d14;
        }
        double[] dArray = new double[]{d2, d9, d6, d10};
        return dArray;
    }

    private double minin(double d, double d2, double d3, double d4, UnivariateFunction univariateFunction, double d5) {
        double d6;
        double d7 = 0.0;
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("Nonpositive absolute tolerance tol");
        }
        if (d == d2) {
            this.minx = d;
            this.fminx = d3;
            this.f2minx = NumericalDerivative.secondDerivative(univariateFunction, this.minx);
            return this.minx;
        }
        if (d2 < d) {
            double d8 = d;
            d = d2;
            d2 = d8;
            d8 = d3;
            d3 = d4;
            d4 = d8;
        }
        double d9 = d;
        double d10 = d3;
        double d11 = d2;
        double d12 = d4;
        if (d12 > d10) {
            d6 = d11;
            d11 = d9;
            d9 = d6;
            d6 = d12;
            d12 = d10;
            d10 = d6;
        }
        d6 = d9;
        double d13 = d10;
        double d14 = 0.0;
        while (this.maxFun == 0 || this.numFun <= this.maxFun) {
            double d15;
            double d16 = (d + d2) * 0.5;
            double d17 = MachineAccuracy.SQRT_EPSILON + d5;
            double d18 = 2.0 * d17;
            if (Math.abs(d11 - d16) <= d18 - (d2 - d) * 0.5) break;
            double d19 = 0.0;
            double d20 = 0.0;
            double d21 = 0.0;
            if (Math.abs(d14) > d17) {
                d19 = (d11 - d9) * (d12 - d13);
                d20 = (d11 - d6) * (d12 - d10);
                d21 = (d11 - d6) * d20 - (d11 - d9) * d19;
                if ((d20 = (d20 - d19) * 2.0) > 0.0) {
                    d21 = -d21;
                } else {
                    d20 = -d20;
                }
                d19 = d14;
                d14 = d7;
            }
            if (Math.abs(d21) < Math.abs(d20 * d19 * 0.5) && d21 > (d - d11) * d20 && d21 < (d2 - d11) * d20) {
                d7 = d21 / d20;
                d15 = d11 + d7;
                if (d15 - d < d18 || d2 - d15 < d18) {
                    d7 = d11 < d16 ? d17 : -d17;
                }
            } else {
                d14 = (d11 < d16 ? d2 : d) - d11;
                d7 = C * d14;
            }
            d15 = d11 + (Math.abs(d7) >= d17 ? d7 : (d7 > 0.0 ? d17 : -d17));
            double d22 = univariateFunction.evaluate(d15);
            ++this.numFun;
            if (d22 <= d12) {
                if (d15 < d11) {
                    d2 = d11;
                } else {
                    d = d11;
                }
                d6 = d9;
                d13 = d10;
                d9 = d11;
                d10 = d12;
                d11 = d15;
                d12 = d22;
                continue;
            }
            if (d15 < d11) {
                d = d15;
            } else {
                d2 = d15;
            }
            if (d22 <= d10) {
                d6 = d9;
                d13 = d10;
                d9 = d15;
                d10 = d22;
                continue;
            }
            if (!(d22 <= d13) && d6 != d9) continue;
            d6 = d15;
            d13 = d22;
        }
        this.minx = d11;
        this.fminx = d12;
        this.f2minx = NumericalDerivative.secondDerivative(univariateFunction, this.minx);
        return d11;
    }
}

