/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.Tree;
import dr.evomodel.speciation.NewBirthDeathSerialSamplingModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.math.MathUtils;
import java.util.Arrays;

public class NewBDSSHistorySimulator
implements Loggable {
    private final NewBirthDeathSerialSamplingModel bdss;
    private final Tree tree;
    private final boolean startAtOrigin;
    private final boolean conditionOnSurvivalToPresent;
    private final boolean recordBeforeSampling;
    private final int dim;
    private double[] history;
    private int nSeen;
    private NewBDSSHistorySimulatorColumn[] columns = null;

    public NewBDSSHistorySimulator(NewBirthDeathSerialSamplingModel newBirthDeathSerialSamplingModel, Tree tree, boolean bl, boolean bl2, boolean bl3) {
        this.bdss = newBirthDeathSerialSamplingModel;
        this.tree = tree;
        this.startAtOrigin = bl;
        this.conditionOnSurvivalToPresent = bl2;
        this.recordBeforeSampling = bl3;
        this.dim = newBirthDeathSerialSamplingModel.getDeathRateParameter().getDimension();
        this.history = new double[this.dim];
        this.nSeen = 0;
    }

    private double getStartTime() {
        double d = this.bdss.originTime.getParameterValue(0);
        if (!this.startAtOrigin) {
            d = this.tree.getNodeHeight(this.tree.getRoot());
        }
        return d;
    }

    private int getStartingIndex() {
        double d = this.getStartTime();
        double[] dArray = this.bdss.getBreakPoints();
        int n = 0;
        while (dArray[n] < d) {
            ++n;
        }
        return n;
    }

    private int drawNext(int n, int n2, double d, double d2) {
        double d3 = this.bdss.getBirthRateParameter().getParameterValue(n);
        double d4 = this.bdss.getDeathRateParameter().getParameterValue(n);
        double d5 = this.bdss.getSamplingRateParameter().getParameterValue(n);
        double d6 = this.bdss.getTreatmentProbabilityParameter().getParameterValue(n);
        double d7 = d4 + d5 * d6;
        double d8 = d3 - d7;
        int n3 = 0;
        double d9 = Math.exp(d8 * (d - d2));
        double d10 = 1.0 - d7 * (d9 - 1.0) / (d3 * d9 - d7);
        double d11 = d3 / d7 * (1.0 - d10);
        double d12 = -Math.log(d11);
        for (int i = 0; i < n2; ++i) {
            if (!(MathUtils.nextDouble() < d10)) continue;
            n3 = (int)((double)n3 + (1.0 + Math.floor(MathUtils.nextExponential(d12))));
        }
        return n3;
    }

    private int doMassSampling(int n, int n2) {
        int n3 = n2;
        double d = this.bdss.getSamplingProbabilityParameter().getParameterValue(n);
        double d2 = this.bdss.getTreatmentProbabilityParameter().getParameterValue(n);
        if (d > 0.0) {
            for (int i = 0; i < n3; ++i) {
                if (!(MathUtils.nextDouble() < d * d2)) continue;
                --n3;
            }
        }
        return n3;
    }

    private void simulateHistory() {
        boolean bl = false;
        while (!bl) {
            Arrays.fill(this.history, 0.0);
            double d = this.getStartTime();
            int n = this.startAtOrigin ? 1 : 2;
            double[] dArray = this.bdss.getBreakPoints();
            for (int i = this.getStartingIndex(); i > -1; --i) {
                double d2 = i == 0 ? 0.0 : dArray[i - 1];
                n = this.drawNext(i, n, d, d2);
                this.history[i] = n;
                n = this.doMassSampling(i, n);
                if (!this.recordBeforeSampling) {
                    this.history[i] = n;
                }
                d = d2;
            }
            if (this.conditionOnSurvivalToPresent && !(this.history[0] > 0.0)) continue;
            bl = true;
        }
    }

    private double getHistory(int n) {
        return this.history[n];
    }

    @Override
    public LogColumn[] getColumns() {
        if (this.columns == null) {
            this.columns = new NewBDSSHistorySimulatorColumn[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                this.columns[i] = new NewBDSSHistorySimulatorColumn(i);
            }
        }
        return this.columns;
    }

    private class NewBDSSHistorySimulatorColumn
    extends NumberColumn {
        final int index;

        public NewBDSSHistorySimulatorColumn(int n) {
            super("NewBDSSHistorySimulatorColumn");
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            if (this.index == 0) {
                NewBDSSHistorySimulator.this.simulateHistory();
            }
            return NewBDSSHistorySimulator.this.getHistory(this.index);
        }
    }
}

