/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.ROWID;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public abstract class OracleType
implements Serializable {
    static final long serialVersionUID = -4124152314660261528L;
    public static final int STYLE_ARRAY_LENGTH = 0;
    public static final int STYLE_DATUM = 1;
    public static final int STYLE_JAVA = 2;
    public static final int STYLE_RAWBYTE = 3;
    public static final int STYLE_INT = 4;
    public static final int STYLE_DOUBLE = 5;
    public static final int STYLE_FLOAT = 6;
    public static final int STYLE_LONG = 7;
    public static final int STYLE_SHORT = 8;
    public static final int STYLE_SKIP = 9;
    static final int FORMAT_ADT_ATTR = 1;
    static final int FORMAT_COLL_ELEM = 2;
    static final int FORMAT_COLL_ELEM_NO_INDICATOR = 3;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;
    int typeCode;
    int dbTypeCode;
    boolean metaDataInitialized = false;

    public OracleType() {
    }

    public OracleType(int n2) {
        this();
        this.typeCode = n2;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public TypeDescriptor getTypeDescriptor() {
        return null;
    }

    private Class getOracleSqlClassType() throws SQLException {
        Class clazz;
        int n2 = this.getTypeCode();
        switch (n2) {
            case -2: {
                clazz = RAW.class;
                break;
            }
            case 101: {
                clazz = BINARY_DOUBLE.class;
                break;
            }
            case 100: {
                clazz = BINARY_FLOAT.class;
                break;
            }
            case 1: {
                clazz = CHAR.class;
                break;
            }
            case 2005: {
                clazz = CLOB.class;
                break;
            }
            case 91: {
                clazz = DATE.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = NUMBER.class;
                break;
            }
            case -104: {
                clazz = INTERVALDS.class;
                break;
            }
            case -103: {
                clazz = INTERVALYM.class;
                break;
            }
            case -8: {
                clazz = ROWID.class;
                break;
            }
            case 93: {
                clazz = TIMESTAMP.class;
                break;
            }
            case -102: {
                clazz = TIMESTAMPLTZ.class;
                break;
            }
            case -101: {
                clazz = TIMESTAMPTZ.class;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    public abstract Datum toDatum(Object var1, oracle.jdbc.internal.OracleConnection var2) throws SQLException;

    public Datum toDatumInternal(Object object, oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        return this.toDatum(object, oracleConnection);
    }

    public Datum[] toDatumArrayInternal(Object object, oracle.jdbc.internal.OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return this.toDatumArray(object, oracleConnection, l2, n2);
    }

    public Datum[] toDatumArray(Object object, oracle.jdbc.internal.OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    Class clazz;
                    Object object2 = objectArray[(int)l2 + i2 - 1];
                    if (oracleConnection != null && oracleConnection instanceof OracleConnection && object2 != null && (clazz = this.getOracleSqlClassType()) != null) {
                        try {
                            object2 = JavaToJavaConverter.convert(object2, clazz, (OracleConnection)oracleConnection, null, null);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    datumArray[i2] = this.toDatum(object2, oracleConnection);
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
            }
        }
        return datumArray;
    }

    public void setTypeCode(int n2) {
        this.typeCode = n2;
    }

    public int getTypeCode() throws SQLException {
        return this.typeCode;
    }

    public void setDBTypeCode(int n2) {
        this.dbTypeCode = n2;
    }

    public int getDBTypeCode() throws SQLException {
        return this.dbTypeCode;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        if (n2 == 9) {
            pickleContext.skipDataValue();
            return null;
        }
        byte[] byArray = pickleContext.readDataValue();
        return this.toObject(byArray, n2, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        if (n2 == 9) {
            pickleContext.skipDataValue();
            return null;
        }
        byte[] byArray = pickleContext.readDataValue(by);
        return this.toObject(byArray, n2, map);
    }

    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        return null;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n2 = pickleContext.writeLength((int)datum.getLength());
        return n2 += pickleContext.writeData(datum.shareBytes());
    }

    void writeSerializedFields(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeObject(objectOutputStream);
    }

    void readSerializedFields(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.readObject(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(this.typeCode);
        objectOutputStream.writeInt(this.dbTypeCode);
        objectOutputStream.writeBoolean(this.metaDataInitialized);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        int n4 = objectInputStream.readInt();
        int n5 = objectInputStream.readInt();
        this.typeCode = objectInputStream.readInt();
        this.dbTypeCode = objectInputStream.readInt();
        this.metaDataInitialized = objectInputStream.readBoolean();
    }

    public void setConnection(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
    }

    public boolean isNCHAR() throws SQLException {
        return false;
    }

    public int getPrecision() throws SQLException {
        return 0;
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public void initMetadataRecursively() throws SQLException {
    }

    public void initNamesRecursively() throws SQLException {
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
    }

    public void cacheDescriptor() throws SQLException {
    }

    public void setNames(String string, String string2) throws SQLException {
    }

    public String toXMLString() throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0);
        return stringWriter.getBuffer().substring(0);
    }

    public void printXML(PrintStream printStream) throws SQLException {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0);
    }

    void printXMLHeader(PrintWriter printWriter) throws SQLException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    }

    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleType typecode=\"" + this.typeCode + "\" />");
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

