/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.widgets.VectorBuilderWidget;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamVectorBuilderWidget
extends ParamWidget {
    private VectorBuilderWidget vectorBuilder;

    public ParamVectorBuilderWidget() {
    }

    public ParamVectorBuilderWidget(Param param) {
        this.setModel(param);
    }

    @Override
    public void setModel(Param param) {
        this.model = param;
        this.initAsVectorBuilder();
        this.vectorBuilder.removeAllItems();
        this.vectorBuilder.addItems((String[])(this.model.getValue() != null ? this.model.getValue() : new String[]{}));
        this.vectorBuilder.setNumeric(((ParamVector)param).isNumeric());
    }

    @Override
    public void updateModel() {
        DefaultListModel defaultListModel = this.vectorBuilder.getListModel();
        if (defaultListModel.size() == 0) {
            this.model.setValue(null);
        } else {
            String[] stringArray = new String[defaultListModel.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = defaultListModel.get(i).toString();
            }
            this.model.setValue(stringArray);
        }
    }

    @Override
    public Param getModel() {
        this.updateModel();
        return this.model;
    }

    private void initAsVectorBuilder() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(291, 166));
            int n = 58;
            this.label = new JLabel();
            this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
            if (this.model != null) {
                this.label.setText(this.model.getTitle());
                n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
            }
            int n2 = Math.max(n + 22, 80);
            this.vectorBuilder = new VectorBuilderWidget();
            this.add((Component)this.vectorBuilder, new AnchorConstraint(3, 750, 1003, n2, 1, 1, 1, 2));
            this.vectorBuilder.setPreferredSize(new Dimension(113, 166));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPreferredSize(new Dimension(200, 100));
        this.setMaximumSize(new Dimension(2000, 100));
    }
}

