/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.rdql.ResultBindingImpl;
import java.util.Iterator;

public class ResultBindingIterator
implements Iterator {
    boolean active;
    boolean doneThisOne;
    ResultBindingImpl binding;
    int i;

    ResultBindingIterator(ResultBindingImpl _binding) {
        this.binding = _binding;
        this.i = -1;
        this.doneThisOne = true;
        this.active = true;
    }

    public boolean hasNext() {
        if (this.doneThisOne) {
            this.advance();
        }
        return this.active;
    }

    public Object next() {
        this.advance();
        this.doneThisOne = true;
        return this.binding.varNames.get(this.i);
    }

    public String varName() {
        if (!this.active) {
            return null;
        }
        return (String)this.binding.varNames.get(this.i);
    }

    public void remove() {
        throw new UnsupportedOperationException("ResultsBindingIterator.remove");
    }

    private boolean advance() {
        if (!this.active) {
            return false;
        }
        if (!this.doneThisOne) {
            return true;
        }
        ++this.i;
        if (this.i >= this.binding.varNames.size()) {
            this.i = -1;
            this.binding = this.binding.parent;
            this.doneThisOne = true;
            if (this.binding == null) {
                this.active = false;
                return this.active;
            }
            return this.advance();
        }
        this.doneThisOne = false;
        return this.active;
    }
}

