## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)

## ----load-package, message=FALSE----------------------------------------------
library(WaterBalanceR)

## ----setup-paths, eval=FALSE--------------------------------------------------
# mypath <- system.file("sample_data", package = "WaterBalanceR")
# 
# shape_site <- file.path(mypath, "Shapefile/sample_2023.shp")
# et0_file   <- file.path(mypath, "DWD_ET0_2023.csv")
# precip_dir <- file.path(mypath, "Radolan_2023_processed_daily")
# irrig_file <- file.path(mypath, "Shapefile/Buffer_36m_all_interp.shp")

## ----run-calcWB, eval=FALSE---------------------------------------------------
# test_wb <- WaterBalanceR::calcWB(
#   mypath = mypath,
#   shape_site = shape_site,
#   target_res = 10,
#   last_NDVI_0 = 132,
#   ET_ref = read.csv(et0_file),
#   ET_ref_dl = "DWD",
#   path_WR_precip = precip_dir,
#   precip_source = "radolan",
#   irrig_sf = irrig_file,
#   irrigation_efficiency = 1.0,
#   output_year = 2023,
#   save_shape = TRUE,
#   save_geotiff = TRUE,
#   save_RDATA = TRUE
# )

## ----run-plots, eval=FALSE----------------------------------------------------
# buffer20 <- file.path(mypath, "Shapefile/Buffer_5_WB.shp")
# 
# WaterBalanceR::calcWBplots(
#   source_path = file.path(
#     mypath,
#     "radolan_1_132_10",
#     "WBR_radolan_1_132_10.RData"
#   ),
#   plant_doy = 109,
#   buffer20 = buffer20,
#   shape_site = shape_site
# )

## ----reproducibility, eval=FALSE----------------------------------------------
# system.file("sample_data", package = "WaterBalanceR")

## ----session-info-------------------------------------------------------------
sessionInfo()

