/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PPrimCircle;
import org.rosuda.ibase.toolkit.PlotPrimitive;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Global;
import org.rosuda.util.SpacingPanel;
import org.rosuda.util.Tools;

public class ScatterCanvas
extends BaseCanvas {
    static final String M_PLUS = "+";
    static final String M_EQUISCALE = "equiscale";
    static final String M_MINUS = "-";
    static final String M_LABELS = "labels";
    static final String M_FIELDBG = "customFieldBg";
    static final String M_XRANGEDLG = "XrangeDlg";
    static final String M_YRANGEDLG = "YrangeDlg";
    static final String M_POINTSUP = "points+";
    static final String M_POINTSDOWN = "points-";
    protected SVar[] v;
    protected boolean showLabels = true;
    public boolean bgTopOnly = false;
    public int ptDiam = 3;
    public int minimalDiam = 1;
    public boolean customFieldBg = false;
    protected int pts;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected boolean drag;
    protected MenuItem MIlabels = null;
    private MenuItem MIequiscale = null;
    protected int Y;
    protected int W;
    protected int H;
    protected int TW;
    protected int TH;
    private final int[] axcoordX;
    private final int[] axcoordY;
    private final int[] aycoordX;
    private final int[] aycoordY;
    protected int[] filter = null;
    protected boolean zoomRetainsAspect = false;
    private final int standardMLeft = 40;
    public Color COL_CUSTOMBG = Color.WHITE;
    private boolean crosshairs = false;
    private int qx;
    private int qy;
    public int changePtDiamBy = 2;
    public boolean drawAxes = true;
    private boolean equiscale = false;
    private double spaceprop = 1.1;
    protected TreeMap sortedPointsX;
    protected TreeMap sortedPointsY;
    boolean hasLeft;
    boolean hasTop;
    boolean hasRight;
    boolean hasBot;
    private double[] maxVal;
    private double[] minVal;

    public ScatterCanvas(int n, Frame frame, SVar sVar, SVar sVar2, SMarker sMarker) {
        super(n, frame, sMarker);
        this.setDefaultMargins(new int[]{40, 10, 10, 30});
        this.axcoordX = new int[2];
        this.axcoordY = new int[2];
        this.aycoordX = new int[2];
        this.aycoordY = new int[2];
        this.v = new SVar[2];
        this.v[0] = sVar;
        this.v[1] = sVar2;
        this.m = sMarker;
        this.ax = new Axis(this.v[0], 0, this.v[0].isCat() ? 1 : 0);
        this.ax.addDepend(this);
        this.ay = new Axis(this.v[1], 1, this.v[1].isCat() ? 1 : 0);
        this.ay.addDepend(this);
        this.setValueRange();
        this.drag = false;
        this.createMenu(frame, true, true, true, false, new String[]{"Same Scale", M_EQUISCALE, M_MINUS, "@LHide Labels", M_LABELS, "Change Background", M_FIELDBG, M_MINUS, "Set X Range ...", M_XRANGEDLG, "Set Y Range ...", M_YRANGEDLG, M_MINUS, "Larger Points (up)", M_POINTSUP, "Smaller Points (down)", M_POINTSDOWN});
        this.MIequiscale = EzMenu.getItem(frame, M_EQUISCALE);
        this.MIlabels = EzMenu.getItem(frame, M_LABELS);
        this.MItransHighl = EzMenu.getItem(frame, "transparentHighlighting");
        this.objectClipping = true;
        this.dontPaint = false;
        try {
            Class<?> clazz = Class.forName("org.rosuda.iModels.ScatterMenu");
            if (clazz != null) {
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("setCanvas", this.getClass());
                if (method != null) {
                    method.invoke(obj, this);
                }
                this.pop.addSeparator();
                this.pop.add((Menu)obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SVar getData(int n) {
        return n < 0 || n > 1 ? null : this.v[n];
    }

    public void setFilter(int[] nArray) {
        this.filter = nArray;
        this.setUpdateRoot(1);
        this.repaint();
    }

    public void setFilter(Vector vector) {
        if (vector == null) {
            this.filter = null;
            return;
        }
        this.filter = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.filter[i] = (Integer)vector.elementAt(i);
        }
    }

    public void rotate() {
        try {
            ((Frame)this.getParent()).setTitle("Scatterplot (" + this.v[this.orientation + 1 & 1].getName() + " vs " + this.v[this.orientation & 1].getName() + ")");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateObjects() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.TW = n;
        this.TH = n2;
        int n3 = n - this.mLeft - this.mRight;
        int n4 = n2 - this.mBottom - this.mTop;
        this.W = n3;
        (this.orientation == 0 ? this.ax : this.ay).setGeometry(0, this.mLeft, this.W);
        this.H = n4;
        (this.orientation == 0 ? this.ay : this.ax).setGeometry(1, n2 - this.mBottom, -this.H);
        this.Y = this.TH - this.mBottom - n4;
        this.hasBot = false;
        this.hasTop = false;
        this.hasRight = false;
        this.hasLeft = false;
        this.pts = this.v[0].size();
        if (this.v[1].size() < this.pts) {
            this.pts = this.v[1].size();
        }
        this.sortedPointsX = new TreeMap(new PointComparator(0));
        this.sortedPointsY = new TreeMap(new PointComparator(1));
        for (int i = 0; i < this.pts; ++i) {
            Object object;
            int n5;
            if (this.v[0].isMissingAt(i) && !this.v[0].isCat() || this.v[1].isMissingAt(i) && !this.v[1].isCat()) continue;
            int n6 = 0 + this.ax.getCasePos(i);
            int n7 = 0 + this.ay.getCasePos(i);
            int n8 = this.orientation == 0 ? n6 : n7;
            int n9 = n5 = this.orientation == 0 ? n7 : n6;
            if (n8 < this.mLeft) {
                this.hasLeft = true;
                continue;
            }
            if (n5 < this.mTop) {
                this.hasTop = true;
                continue;
            }
            if (n8 > n - this.mRight) {
                this.hasRight = true;
                continue;
            }
            if (n5 > n2 - this.mBottom) {
                this.hasBot = true;
                continue;
            }
            PPrimCircle pPrimCircle = (PPrimCircle)this.sortedPointsX.get(new Point(n6, n7));
            if (pPrimCircle != null) {
                object = new int[pPrimCircle.ref.length + 1];
                System.arraycopy(pPrimCircle.ref, 0, object, 0, pPrimCircle.ref.length);
                object[pPrimCircle.ref.length] = i;
                pPrimCircle.ref = object;
                continue;
            }
            pPrimCircle = new PPrimCircle();
            if (this.orientation == 0) {
                pPrimCircle.x = n6;
                pPrimCircle.y = n7;
            } else {
                pPrimCircle.x = n7;
                pPrimCircle.y = n6;
            }
            pPrimCircle.diam = this.ptDiam;
            pPrimCircle.ref = new int[]{i};
            pPrimCircle.fillColor = pPrimCircle.borderColor;
            object = new Point(n6, n7);
            this.sortedPointsX.put(object, pPrimCircle);
            this.sortedPointsY.put(object, pPrimCircle);
        }
        Collection collection = this.sortedPointsX.values();
        this.pp = new PlotPrimitive[collection.size()];
        collection.toArray(this.pp);
        for (int i = 0; i < this.pp.length; ++i) {
            this.setColors((PPrimBase)this.pp[i]);
        }
        this.setBoundValues();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (Global.DEBUG > 0) {
            System.out.println("ScatterCanvas: " + keyEvent);
        }
        if (keyEvent.getKeyCode() == 38 && !keyEvent.isShiftDown()) {
            this.ptDiam += this.changePtDiamBy;
            this.setUpdateRoot(0);
            for (n = 0; n < this.pp.length; ++n) {
                if (this.pp[n] == null) continue;
                ((PPrimCircle)this.pp[n]).diam = this.ptDiam;
            }
            this.repaint();
        }
        if (keyEvent.getKeyCode() == 40 && this.ptDiam >= this.minimalDiam + this.changePtDiamBy && !keyEvent.isShiftDown()) {
            this.ptDiam -= this.changePtDiamBy;
            this.setUpdateRoot(0);
            for (n = 0; n < this.pp.length; ++n) {
                if (this.pp[n] == null) continue;
                ((PPrimCircle)this.pp[n]).diam = this.ptDiam;
            }
            this.repaint();
        }
        if (keyEvent.getKeyCode() == 520 && keyEvent.getModifiersEx() == 640) {
            for (n = 0; n < this.pp.length; ++n) {
                ((PPrimCircle)this.pp[n]).startArc += 5;
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
        super.keyPressed(keyEvent);
    }

    public Object run(Object object, String string) {
        int n;
        super.run(object, string);
        if (string == M_LABELS) {
            this.showLabels = !this.showLabels;
            this.MIlabels.setLabel(this.showLabels ? "Hide labels" : "Show labels");
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "rotate") {
            this.rotate();
        }
        if (string == M_POINTSUP) {
            this.ptDiam += this.changePtDiamBy;
            for (n = 0; n < this.pp.length; ++n) {
                if (this.pp[n] == null) continue;
                ((PPrimCircle)this.pp[n]).diam = this.ptDiam;
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == M_POINTSDOWN && this.ptDiam > this.minimalDiam + this.changePtDiamBy) {
            this.ptDiam -= this.changePtDiamBy;
            for (n = 0; n < this.pp.length; ++n) {
                if (this.pp[n] == null) continue;
                ((PPrimCircle)this.pp[n]).diam = this.ptDiam;
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == M_EQUISCALE) {
            this.setEquiscale(!this.equiscale);
        }
        if (string == M_YRANGEDLG || string == M_XRANGEDLG) {
            Axis axis = string == M_YRANGEDLG ? this.ay : this.ax;
            Dialog dialog = this.intDlg = new Dialog(this.myFrame, string == M_YRANGEDLG ? "Y range" : "X range", true);
            PGSCanvas.IDlgCL iDlgCL = new PGSCanvas.IDlgCL(this);
            dialog.setBackground(Color.white);
            dialog.setLayout(new BorderLayout());
            dialog.add((Component)new SpacingPanel(), "West");
            dialog.add((Component)new SpacingPanel(), "East");
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            Button button = new Button("OK");
            panel.add(button);
            Button button2 = new Button("Cancel");
            panel.add(button2);
            dialog.add((Component)panel, "South");
            dialog.add((Component)new Label(" "), "North");
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout());
            dialog.add(panel2);
            panel2.add(new Label("start: "));
            TextField textField = new TextField("" + axis.vBegin, 6);
            TextField textField2 = new TextField("" + (axis.vBegin + axis.vLen), 6);
            panel2.add(textField);
            panel2.add(new Label(", end: "));
            panel2.add(textField2);
            dialog.pack();
            button.addActionListener(iDlgCL);
            button2.addActionListener(iDlgCL);
            dialog.setVisible(true);
            if (!this.cancel) {
                double d = Tools.parseDouble(textField.getText());
                double d2 = Tools.parseDouble(textField2.getText());
                axis.setValueRange(d, d2 - d);
                this.updateObjects();
                this.setUpdateRoot(0);
                this.repaint();
            }
            dialog.dispose();
        }
        if (string == M_FIELDBG) {
            this.customFieldBg = !this.customFieldBg;
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "resetZoom") {
            this.resetZoom();
            this.repaint();
        }
        return null;
    }

    public void paintBack(PoGraSS poGraSS) {
        Dimension dimension = this.getSize();
        if (dimension.width != this.TW || dimension.height != this.TH) {
            this.updateObjects();
        }
        if (this.TW < 50 || this.TH < 50) {
            poGraSS.setColor(this.COL_INVALID);
            poGraSS.drawLine(0, 0, this.TW, this.TH);
            poGraSS.drawLine(0, this.TH, this.TW, 0);
            return;
        }
        if (this.customFieldBg) {
            poGraSS.setColor(this.COL_CUSTOMBG);
            poGraSS.fillRect(this.mLeft, this.Y, this.W, this.H);
        }
        poGraSS.setColor(this.COL_OUTLINE);
        if (this.orientation == 0) {
            this.setAyCoord(this.mLeft, this.Y, this.mLeft, this.Y + this.H);
            this.setAxCoord(this.mLeft, this.Y + this.H, this.mLeft + this.W, this.Y + this.H);
        } else {
            this.setAxCoord(this.mLeft, this.Y, this.mLeft, this.Y + this.H);
            this.setAyCoord(this.mLeft, this.Y + this.H, this.mLeft + this.W, this.Y + this.H);
        }
        if (this.drawAxes) {
            poGraSS.drawLine(this.axcoordX[0], this.axcoordY[0], this.axcoordX[1], this.axcoordY[1]);
            poGraSS.drawLine(this.aycoordX[0], this.aycoordY[0], this.aycoordX[1], this.aycoordY[1]);
        }
        this.startAddingLabels();
        int n = this.orientation == 0 ? 0 : 1;
        Axis axis = this.orientation == 0 ? this.ax : this.ay;
        double d = axis.getSensibleTickDistance(this.horizontalMedDist, this.horizontalMinDist);
        double d2 = axis.getSensibleTickStart(d);
        if (Global.DEBUG > 1) {
            System.out.println("SP.A[0]:" + axis.toString() + ", distance=" + d + ", start=" + d2);
        }
        try {
            while (d2 < axis.vBegin + axis.vLen) {
                int n2 = axis.getValuePos(d2);
                poGraSS.drawLine(n2, this.Y + this.H, n2, this.Y + this.H + 5);
                if (this.showLabels) {
                    this.xLabels.add(n2, this.Y + this.H + 20, 0.5, 0.0, this.v[n].isCat() ? this.v[n].getCatAt((int)(d2 + 0.5)).toString() : axis.getDisplayableValue(d2));
                }
                d2 += d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = this.orientation == 0 ? 1 : 0;
        Axis axis2 = axis = this.orientation == 0 ? this.ay : this.ax;
        if (this.showLabels) {
            if (this.v[n].isCat()) {
                this.addYLabels(poGraSS, axis, this.v[n], true, true);
            } else {
                this.addYLabels(poGraSS, axis, true, false);
            }
        }
        this.endAddingLabels();
    }

    public String queryObject(PlotPrimitive plotPrimitive) {
        String string;
        String string2;
        PPrimCircle pPrimCircle = (PPrimCircle)plotPrimitive;
        String string3 = "";
        boolean bl = this.isExtQuery;
        if (pPrimCircle.ref.length == 1) {
            string2 = this.v[0].isCat() ? this.v[0].atS(pPrimCircle.ref[0]) : "" + this.v[0].atD(pPrimCircle.ref[0]);
            string = this.v[1].isCat() ? this.v[1].atS(pPrimCircle.ref[0]) : "" + this.v[1].atD(pPrimCircle.ref[0]);
        } else {
            Object object;
            if (this.v[0].isCat()) {
                object = this.catsIn(pPrimCircle.ref, 0);
                string2 = object.toString();
            } else {
                object = this.minMax(pPrimCircle.ref, 0);
                string2 = "[" + (double)object[0] + ", " + (double)object[1] + "]";
            }
            if (this.v[1].isCat()) {
                object = this.catsIn(pPrimCircle.ref, 1);
                string = object.toString();
            } else {
                object = this.minMax(pPrimCircle.ref, 1);
                string = "[" + (double)object[0] + ", " + (double)object[1] + "]";
            }
        }
        string3 = bl ? (pPrimCircle.ref.length == 1 ? this.v[0].getName() + ": " + string2 + "\n" + this.v[1].getName() + ": " + string + "\n" + pPrimCircle.ref.length + " case(s) " + Tools.getDisplayableValue(100.0 * (double)pPrimCircle.ref.length / (double)this.v[0].size(), 2) + "% of var, " + Tools.getDisplayableValue(100.0 * (double)pPrimCircle.ref.length / (double)(this.v[0].size() + this.v[1].size()), 2) + "% of total)" + (this.m.marked() > 0 ? "\n" + this.getMarked(plotPrimitive) + " selected (" + Tools.getDisplayableValue(100.0 * (double)this.getMarked(plotPrimitive) / (double)this.m.marked(), 2) + "% of total selected)" : "") : this.v[0].getName() + ": " + string2 + "\n" + this.v[1].getName() + ": " + string + "\n" + pPrimCircle.ref.length + " case(s) (" + Tools.getDisplayableValue(100.0 * (double)pPrimCircle.ref.length / (double)this.v[0].size(), 2) + "% of var, " + Tools.getDisplayableValue(100.0 * (double)pPrimCircle.ref.length / (double)(this.v[0].size() + this.v[1].size()), 2) + "% of total)" + (this.m.marked() > 0 ? "\n" + this.getMarked(plotPrimitive) + " selected (" + Tools.getDisplayableValue(100.0 * (double)this.getMarked(plotPrimitive) / (double)this.m.marked(), 2) + "% of total selected)" : "")) : (pPrimCircle.ref.length == 1 ? this.v[0].getName() + ": " + string2 + "\n" + this.v[1].getName() + ": " + string + "\n" + pPrimCircle.ref.length + " case(s)" : this.v[0].getName() + ": " + string2 + "\n" + this.v[1].getName() + ": " + string + "\n" + pPrimCircle.ref.length + " case(s)");
        return string3;
    }

    public String queryPlotSpace() {
        return "Values range:\n" + this.v[0].getName() + ": [" + this.minVal[0] + ", " + this.maxVal[0] + "]\n" + this.v[1].getName() + ": [" + this.minVal[1] + ", " + this.maxVal[1] + "]";
    }

    private void setBoundValues() {
        if (this.pp == null || this.v == null || this.v.length < 2) {
            return;
        }
        if (this.maxVal == null) {
            this.maxVal = new double[2];
        }
        if (this.minVal == null) {
            this.minVal = new double[2];
        }
        for (int i = 0; i < 2; ++i) {
            this.minVal[i] = this.v[i].getMin();
            this.maxVal[i] = this.v[i].getMax();
        }
    }

    private double[] minMax(int[] nArray, int n) {
        double[] dArray = new double[2];
        dArray[0] = dArray[1] = this.v[n].atD(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            double d = this.v[n].atD(nArray[i]);
            if (d < dArray[0]) {
                dArray[0] = d;
            }
            if (!(d > dArray[1])) continue;
            dArray[1] = d;
        }
        return dArray;
    }

    public void paintPost(PoGraSS poGraSS) {
        if (this.crosshairs) {
            poGraSS.setColor(this.COL_OUTLINE);
            if ((this.orientation & 1) == 0) {
                if (this.qx == this.ax.clip(this.qx) && this.qy == this.ay.clip(this.qy)) {
                    poGraSS.drawLine(this.ax.gBegin, this.qy, this.ax.gBegin + this.ax.gLen, this.qy);
                    poGraSS.drawLine(this.qx, this.ay.gBegin, this.qx, this.ay.gBegin + this.ay.gLen);
                    poGraSS.drawString(this.ay.getDisplayableValue(this.ax.getValueForPos(this.qx)), this.qx + 2, this.getHeight() - this.mBottom - 2);
                    poGraSS.drawString(this.ay.getDisplayableValue(this.ay.getValueForPos(this.qy)), this.mLeft + 2, this.qy + 11);
                }
            } else if (this.qx == this.ay.clip(this.qx) && this.qy == this.ax.clip(this.qy)) {
                poGraSS.drawLine(this.qx, this.ax.gBegin, this.qx, this.ax.gBegin + this.ax.gLen);
                poGraSS.drawLine(this.ay.gBegin, this.qy, this.ay.gBegin + this.ay.gLen, this.qy);
                poGraSS.drawString(this.ax.getDisplayableValue(this.ay.getValueForPos(this.qx)), this.qx + 2, this.getHeight() - this.mBottom - 2);
                poGraSS.drawString(this.ax.getDisplayableValue(this.ax.getValueForPos(this.qy)), this.mLeft + 2, this.qy + 11);
            }
        }
        super.paintPost(poGraSS);
    }

    protected PlotPrimitive getFirstPrimitiveContaining(int n, int n2) {
        PlotPrimitive plotPrimitive = (PlotPrimitive)this.sortedPointsX.get(new Point(n, n2));
        if (plotPrimitive != null) {
            return plotPrimitive;
        }
        PlotPrimitive[] plotPrimitiveArray = this.getPrimitivesContaining(n, n2);
        PPrimCircle pPrimCircle = null;
        int n3 = this.ptDiam * this.ptDiam;
        for (int i = 0; i < plotPrimitiveArray.length; ++i) {
            if (plotPrimitiveArray[i] == null) continue;
            PPrimCircle pPrimCircle2 = (PPrimCircle)plotPrimitiveArray[i];
            int n4 = pPrimCircle2.x - n;
            int n5 = pPrimCircle2.y - n2;
            int n6 = n4 * n4 + n5 * n5;
            if (n6 == 1) {
                return pPrimCircle2;
            }
            if (n6 >= n3) continue;
            n3 = n6;
            pPrimCircle = pPrimCircle2;
        }
        return pPrimCircle;
    }

    protected PlotPrimitive[] getPrimitivesContaining(int n, int n2) {
        PlotPrimitive[] plotPrimitiveArray = this.getPrimitivesIntersecting(new Rectangle(n - this.ptDiam / 2, n2 - this.ptDiam / 2, this.ptDiam, this.ptDiam));
        for (int i = 0; i < plotPrimitiveArray.length; ++i) {
            PPrimCircle pPrimCircle = (PPrimCircle)plotPrimitiveArray[i];
            int n3 = pPrimCircle.x - n;
            int n4 = pPrimCircle.y - n2;
            if (n3 * n3 + n4 * n4 <= this.ptDiam * this.ptDiam / 4) continue;
            plotPrimitiveArray[i] = null;
        }
        return plotPrimitiveArray;
    }

    protected PlotPrimitive[] getPrimitivesIntersecting(Rectangle rectangle) {
        int n = this.orientation == 0 ? rectangle.x : rectangle.y;
        int n2 = this.orientation == 0 ? rectangle.y : rectangle.x;
        int n3 = this.orientation == 0 ? rectangle.width : rectangle.height;
        int n4 = this.orientation == 0 ? rectangle.height : rectangle.width;
        Point point = new Point(n, n2);
        Point point2 = new Point(n + n3, n2 + n4);
        SortedMap sortedMap = this.sortedPointsX.subMap(point, point2);
        SortedMap sortedMap2 = this.sortedPointsY.subMap(point, point2);
        TreeMap treeMap = new TreeMap(sortedMap);
        treeMap.keySet().retainAll(sortedMap2.keySet());
        Collection collection = treeMap.values();
        PlotPrimitive[] plotPrimitiveArray = new PlotPrimitive[collection.size()];
        collection.toArray(plotPrimitiveArray);
        return plotPrimitiveArray;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        boolean bl = this.crosshairs;
        this.crosshairs = Common.isMoveTrigger(mouseEvent);
        this.qx = mouseEvent.getX();
        this.qy = mouseEvent.getY();
        if (this.crosshairs || this.crosshairs != bl) {
            this.setUpdateRoot(3);
            this.repaint();
        }
    }

    private int getMarked(PlotPrimitive plotPrimitive) {
        return (int)((double)plotPrimitive.cases() * plotPrimitive.getMarkedProportion(this.m, -1) + 0.5);
    }

    private void setAxCoord(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.axcoordX[0] = n;
            this.axcoordX[1] = n3;
        } else {
            this.axcoordX[0] = n3;
            this.axcoordX[1] = n;
        }
        if (n2 < n4) {
            this.axcoordY[0] = n2;
            this.axcoordY[1] = n4;
        } else {
            this.axcoordY[0] = n4;
            this.axcoordY[1] = n2;
        }
    }

    private void setAyCoord(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.aycoordX[0] = n;
            this.aycoordX[1] = n3;
        } else {
            this.aycoordX[0] = n3;
            this.aycoordX[1] = n;
        }
        if (n2 < n4) {
            this.aycoordY[0] = n2;
            this.aycoordY[1] = n4;
        } else {
            this.aycoordY[0] = n4;
            this.aycoordY[1] = n2;
        }
    }

    protected Axis getMouseOverAxis(int n, int n2) {
        if (n >= this.axcoordX[0] - 2 && n <= this.axcoordX[1] + 2 && n2 >= this.axcoordY[0] - 2 && n2 <= this.axcoordY[1] + 2) {
            return this.ax;
        }
        if (n >= this.aycoordX[0] - 2 && n <= this.aycoordX[1] + 2 && n2 >= this.aycoordY[0] - 2 && n2 <= this.aycoordY[1] + 2) {
            return this.ay;
        }
        return null;
    }

    protected String getAxisQuery(int n, int n2) {
        Axis axis = this.getMouseOverAxis(n, n2);
        if (axis == null) {
            return null;
        }
        return "axis name: " + axis.getVariable().getName() + "\nrange: " + Tools.getDisplayableValue(axis.vBegin, 2) + " ... " + Tools.getDisplayableValue(axis.vBegin + axis.vLen, 2);
    }

    public double getSpaceprop() {
        return this.spaceprop;
    }

    public void setSpaceprop(double d) {
        this.spaceprop = d;
        this.setValueRange();
    }

    private void setValueRange() {
        if (this.equiscale) {
            double d;
            double d2 = (double)this.ax.gLen / this.ax.vLen;
            double d3 = d2 < 0.0 ? -d2 : d2;
            double d4 = (double)this.ay.gLen / this.ay.vLen;
            double d5 = d = d4 < 0.0 ? -d4 : d4;
            if (d3 < d) {
                this.ay.setValueRange(this.ay.vBegin, this.ay.vLen * (d / d3));
            } else {
                this.ax.setValueRange(this.ax.vBegin, this.ax.vLen * (d3 / d));
            }
        } else {
            if (!this.v[0].isCat()) {
                this.ax.setValueRange(this.v[0].getMin() - (this.v[0].getMax() - this.v[0].getMin()) * (this.spaceprop - 1.0) / 2.0, (this.v[0].getMax() - this.v[0].getMin()) * this.spaceprop);
            }
            if (!this.v[1].isCat()) {
                this.ay.setValueRange(this.v[1].getMin() - (this.v[1].getMax() - this.v[1].getMin()) * (this.spaceprop - 1.0) / 2.0, (this.v[1].getMax() - this.v[1].getMin()) * this.spaceprop);
            }
            if (!this.v[0].isCat() && Math.abs(this.v[0].getMax() - this.v[0].getMin()) < 1.0E-4) {
                this.ax.setValueRange(this.v[0].getMin() - 0.5, 1.0);
            }
            if (!this.v[1].isCat() && Math.abs(this.v[1].getMax() - this.v[1].getMin()) < 1.0E-4) {
                this.ay.setValueRange(this.v[1].getMin() - 0.5, 1.0);
            }
        }
    }

    private SortedSet catsIn(int[] nArray, int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < nArray.length; ++i) {
            treeSet.add(this.v[n].atS(nArray[i]));
        }
        return treeSet;
    }

    public void setEquiscale(boolean bl) {
        this.equiscale = bl;
        this.MIequiscale.setLabel(bl ? "Individual scale" : "Same scale");
        this.setValueRange();
        this.updateObjects();
        this.setUpdateRoot(0);
        this.repaint();
    }

    private class PointComparator
    implements Comparator {
        private int type;
        public static final int TYPE_X = 0;
        public static final int TYPE_Y = 1;

        public PointComparator(int n) {
            this.type = n;
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            int n3;
            int n4;
            switch (this.type) {
                case 0: {
                    n4 = ((Point)object).x;
                    n3 = ((Point)object2).x;
                    n2 = ((Point)object).y;
                    n = ((Point)object2).y;
                    break;
                }
                default: {
                    n4 = ((Point)object).y;
                    n3 = ((Point)object2).y;
                    n2 = ((Point)object).x;
                    n = ((Point)object2).x;
                }
            }
            if (n4 < n3 || n4 == n3 && n2 < n) {
                return -1;
            }
            if (n4 == n3 && n2 == n) {
                return 0;
            }
            return 1;
        }
    }
}

