## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo = FALSE, message = FALSE-------------------------------------
library(pacta.loanbook)

plot_table <- function(dataset_name) {
  table <- data_dictionary
  table <- dplyr::filter(table, .data[["dataset"]] == dataset_name)
  table <- dplyr::arrange(table, match(column, names(get(dataset_name))))
  table_plot <- gt::gt(dplyr::select(table, -"dataset"))
  
  table_plot <- 
    gt::cols_width(
      .data = table_plot,
      column ~ gt::px(150),
      typeof ~ gt::px(90)
    )
  
  table_plot <-
    gt::tab_style(
      data = table_plot,
      style = gt::cell_text(size = "smaller"),
      locations = gt::cells_body(columns = 1:2)
    )
  
  table_plot <-
    gt::tab_options(
      data = table_plot,
      ihtml.active = TRUE,
      ihtml.use_pagination = FALSE,
      ihtml.use_sorting = TRUE,
      ihtml.use_highlight = TRUE
    )
  
  gt::fmt_passthrough(table_plot)
}

## ----echo = FALSE-------------------------------------------------------------
plot_table("sector_classifications")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
sector_classifications

## ----echo = FALSE-------------------------------------------------------------
plot_table("gics_classification")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gics_classification

## ----echo = FALSE-------------------------------------------------------------
plot_table("isic_classification")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
isic_classification

## ----echo = FALSE-------------------------------------------------------------
plot_table("nace_classification")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
nace_classification

## ----echo = FALSE-------------------------------------------------------------
plot_table("naics_classification")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
naics_classification

## ----echo = FALSE-------------------------------------------------------------
plot_table("psic_classification")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
psic_classification

## ----echo = FALSE-------------------------------------------------------------
plot_table("sic_classification")

## ----R.options = list(width = 400)----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
sic_classification

