/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.EnumDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IGraphDelta;

public class GraphDelta
extends TimeStampedObject
implements IGraphDelta {
    private final IEnumDelta[] deltaOfType = new IEnumDelta[6];

    public GraphDelta(IEnvironment environment) {
        super(environment);
        for (int i = 0; i < 6; ++i) {
            this.deltaOfType[i] = new EnumDelta(environment);
        }
    }

    @Override
    public int getSize(int i) {
        return this.deltaOfType[i].size();
    }

    @Override
    public void add(int element, int type, ICause cause) {
        this.lazyClear();
        this.deltaOfType[type].add(element, cause);
    }

    @Override
    public void lazyClear() {
        if (this.needReset()) {
            for (int i = 0; i < 6; ++i) {
                this.deltaOfType[i].lazyClear();
            }
            this.resetStamp();
        }
    }

    @Override
    public int get(int index, int type) {
        return this.deltaOfType[type].get(index);
    }

    @Override
    public ICause getCause(int index, int type) {
        return this.deltaOfType[type].getCause(index);
    }
}

