/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chocosolver.solver.Solution;
import org.restopt.RestoptProblem;
import org.restopt.objectives.AbstractRestoptObjective;

public class NbPatchesObjective
extends AbstractRestoptObjective {
    public static final String KEY_NB_PATCHES_INITIAL = "nb_patches_initial";
    public static final String KEY_NB_PATCHES = "nb_patches";
    public static final String KEY_NB_PATCHES_BEST = "nb_patches_best";
    int initialValue;

    public NbPatchesObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, String search, boolean lns) {
        super(problem, timeLimit, verbose, maximize, search, lns);
    }

    public NbPatchesObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize) {
        this(problem, timeLimit, verbose, maximize, "", false);
    }

    @Override
    public void initObjective() {
        this.objective = this.problem.getModel().intVar(1, this.problem.getLandscapeArea());
        this.problem.getModel().nbConnectedComponents(this.problem.getHabitatGraphVar(), this.objective).post();
        this.initialValue = this.problem.getHabitatGraph().getNBCC();
    }

    @Override
    public String getInitialValueMessage() {
        return "NB_PATCHES initial = " + this.initialValue + "\n";
    }

    @Override
    public String[] getAdditionalKeys() {
        return new String[]{KEY_NB_PATCHES_INITIAL, KEY_NB_PATCHES, KEY_NB_PATCHES_BEST};
    }

    @Override
    public Map<String, String> appendCharacteristics(Solution solution) {
        HashMap<String, String> charact = new HashMap<String, String>();
        charact.put(KEY_NB_PATCHES_INITIAL, String.valueOf(this.initialValue));
        charact.put(KEY_NB_PATCHES, String.valueOf(solution.getIntVal(this.objective)));
        charact.put(KEY_NB_PATCHES_BEST, String.valueOf(this.getOptimalValue()));
        return charact;
    }

    @Override
    public List<String[]> appendMessages() {
        ArrayList<String[]> messages = new ArrayList<String[]>();
        messages.add(new String[]{KEY_NB_PATCHES_INITIAL, "Initial number of habitat patches: "});
        messages.add(new String[]{KEY_NB_PATCHES, "Number of habitat patches after restoration: "});
        messages.add(new String[]{KEY_NB_PATCHES_BEST, "Best known value for the number of habitat patches: "});
        return messages;
    }
}

