/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import standalone_spreadsheet.com.github.miachm.sods.OdsOptionParameters;
import standalone_spreadsheet.com.github.miachm.sods.Sheet;
import standalone_spreadsheet.com.github.miachm.sods.SheetParser;
import standalone_spreadsheet.com.github.miachm.sods.SpreadSheet;
import standalone_spreadsheet.com.github.miachm.sods.StylesParser;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;

class SpreadsheetParser {
    private final StylesParser stylesParser;
    private final SpreadSheet spread;
    private final OdsOptionParameters options;

    public SpreadsheetParser(StylesParser stylesParser, SpreadSheet spread, OdsOptionParameters options) {
        this.stylesParser = stylesParser;
        this.spread = spread;
        this.options = options;
    }

    public void parseContent(XmlReaderInstance bodyInstance) {
        if (bodyInstance == null) {
            return;
        }
        XmlReaderInstance spreadsheetInstance = bodyInstance.nextElement("office:spreadsheet");
        if (spreadsheetInstance != null) {
            int currentSheetIndex = 0;
            while (spreadsheetInstance.hasNext()) {
                boolean shouldLoadSheet;
                XmlReaderInstance tableInstance = spreadsheetInstance.nextElement("table:table");
                if (tableInstance == null) continue;
                boolean bl = shouldLoadSheet = this.options.getSheetNumbers() == null || this.options.getSheetNumbers().contains(currentSheetIndex);
                if (shouldLoadSheet) {
                    String name = tableInstance.getAttribValue("table:name");
                    Sheet sheet = new Sheet(name, 0, 0);
                    SheetParser sheetParser = new SheetParser(sheet, this.stylesParser);
                    sheetParser.parseSheet(tableInstance);
                    this.spread.appendSheet(sheet);
                }
                ++currentSheetIndex;
            }
        }
    }
}

