/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import internal.toolkit.base.tsp.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.fixme.SortedMaps;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DataSet {
    @NonNull
    private final DataSource dataSource;
    @NonNull
    private final Kind kind;
    @NonNull
    private final SortedMap<String, String> parameters;
    private static final String SCHEME = "demetra";
    private static final String HOST = "tsprovider";

    public @Nullable String getParameter(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (String)this.getParameters().get(key);
    }

    @NonNull
    public Builder toBuilder(@NonNull Kind kind) {
        Objects.requireNonNull(kind, "kind");
        return this.toBuilder().kind(kind);
    }

    public String toString() {
        return DataSet.formatAsUri(this).buildString();
    }

    @NonNull
    public URI toURI() {
        return DataSet.formatAsUri(this).build();
    }

    @NonNull
    public static DataSet parse(@NonNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return DataSet.parseAsUri(URI.create(input.toString()));
    }

    @NonNull
    public static DataSet parseURI(@NonNull URI input) throws IllegalArgumentException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return DataSet.parseAsUri(input);
    }

    @NonNull
    public static DataSet of(@NonNull DataSource dataSource, @NonNull Kind kind) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new DataSet(dataSource, kind, Collections.emptySortedMap());
    }

    @NonNull
    public static DataSet of(@NonNull DataSource dataSource, @NonNull Kind kind, @NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new DataSet(dataSource, kind, SortedMaps.immutableOf(key, value));
    }

    @NonNull
    public static DataSet deepCopyOf(@NonNull DataSource dataSource, @NonNull Kind kind, @NonNull Map<String, String> params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new DataSet(dataSource, kind, SortedMaps.immutableCopyOf(params));
    }

    @NonNull
    public static Builder builder(@NonNull DataSource dataSource, @NonNull Kind kind) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new Builder().dataSource(dataSource).kind(kind);
    }

    private static DataSet parseAsUri(URI uri) throws IllegalArgumentException {
        if (!SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("Invalid scheme: " + uri.getScheme());
        }
        if (!HOST.equals(uri.getHost())) {
            throw new IllegalArgumentException("Invalid host: " + uri.getHost());
        }
        String[] path = UriBuilder.getPathArray(uri, 3);
        if (path == null) {
            throw new IllegalArgumentException("Invalid path: " + uri.getRawPath());
        }
        Map<String, String> query = UriBuilder.getQueryMap(uri);
        if (query == null) {
            throw new IllegalArgumentException("Invalid query: " + uri.getRawQuery());
        }
        Map<String, String> fragment = UriBuilder.getFragmentMap(uri);
        if (fragment == null) {
            throw new IllegalArgumentException("Invalid fragment: " + uri.getRawFragment());
        }
        DataSource dataSource = new DataSource(path[0], path[1], SortedMaps.immutableCopyOf(query));
        return new DataSet(dataSource, Kind.valueOf(path[2]), SortedMaps.immutableCopyOf(fragment));
    }

    private static UriBuilder formatAsUri(DataSet value) {
        DataSource dataSource = value.getDataSource();
        return new UriBuilder(SCHEME, HOST).path(dataSource.getProviderName(), dataSource.getVersion(), value.getKind().name()).query(dataSource.getParameters()).fragment(value.getParameters());
    }

    @Generated
    DataSet(@NonNull DataSource dataSource, @NonNull Kind kind, @NonNull SortedMap<String, String> parameters) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.dataSource = dataSource;
        this.kind = kind;
        this.parameters = parameters;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().dataSource(this.dataSource).kind(this.kind);
        if (this.parameters != null) {
            builder.parameters(this.parameters);
        }
        return builder;
    }

    @NonNull
    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @NonNull
    @Generated
    public Kind getKind() {
        return this.kind;
    }

    @NonNull
    @Generated
    public SortedMap<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)o;
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        SortedMap<String, String> this$parameters = this.getParameters();
        SortedMap<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        SortedMap<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private DataSource dataSource;
        @Generated
        private Kind kind;
        @Generated
        private ArrayList<String> parameters$key;
        @Generated
        private ArrayList<String> parameters$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder dataSource(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.dataSource = dataSource;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder kind(@NonNull Kind kind) {
            if (kind == null) {
                throw new NullPointerException("kind is marked non-null but is null");
            }
            this.kind = kind;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder parameter(String parameterKey, String parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder parameters(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters cannot be null");
            }
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearParameters() {
            if (this.parameters$key != null) {
                this.parameters$key.clear();
                this.parameters$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull DataSet build() {
            TreeMap<String, String> parameters = new TreeMap();
            if (this.parameters$key != null) {
                for (int $i = 0; $i < (this.parameters$key == null ? 0 : this.parameters$key.size()); ++$i) {
                    parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                }
            }
            parameters = Collections.unmodifiableSortedMap(parameters);
            return new DataSet(this.dataSource, this.kind, parameters);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "DataSet.Builder(dataSource=" + String.valueOf(this.dataSource) + ", kind=" + String.valueOf((Object)this.kind) + ", parameters$key=" + String.valueOf(this.parameters$key) + ", parameters$value=" + String.valueOf(this.parameters$value) + ")";
        }
    }

    public static enum Kind {
        SERIES,
        COLLECTION,
        DUMMY;

    }

    public static interface Converter<P> {
        @NonNull
        public P getDefaultValue();

        @NonNull
        public P get(@NonNull DataSet var1);

        public void set(@NonNull Builder var1, @Nullable P var2);
    }
}

