/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.matrices;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;

class LightMutableMatrix
implements Matrix.Mutable {
    private final double[] storage;
    private final int nrows;
    private final int ncolumns;

    LightMutableMatrix(double[] storage, int nrows, int ncolumns) {
        this.storage = storage;
        this.nrows = nrows;
        this.ncolumns = ncolumns;
    }

    @Override
    public double[] toArray() {
        return (double[])this.storage.clone();
    }

    @Override
    public double get(int row, int column) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nrows || column < 0 || column >= this.ncolumns) {
            throw new IndexOutOfBoundsException();
        }
        return this.storage[row + column * this.nrows];
    }

    @Override
    public void set(int row, int column, double value) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nrows || column < 0 || column >= this.ncolumns) {
            throw new IndexOutOfBoundsException();
        }
        this.storage[row + column * this.nrows] = value;
    }

    @Override
    public void apply(int row, int column, DoubleUnaryOperator fn) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nrows || column < 0 || column >= this.ncolumns) {
            throw new IndexOutOfBoundsException();
        }
        int idx = row + column * this.nrows;
        this.storage[idx] = fn.applyAsDouble(this.storage[idx]);
    }

    @Override
    public DoubleSeq.Mutable row(int irow) {
        if (irow < 0 || irow >= this.nrows) {
            throw new IndexOutOfBoundsException();
        }
        return DoubleSeq.Mutable.of(this.storage, irow, this.ncolumns, this.nrows);
    }

    @Override
    public DoubleSeq.Mutable column(int icolumn) {
        if (icolumn < 0 || icolumn >= this.ncolumns) {
            throw new IndexOutOfBoundsException();
        }
        return DoubleSeq.Mutable.of(this.storage, icolumn * this.nrows, this.nrows, 1);
    }

    @Override
    public DoubleSeq.Mutable subDiagonal(int pos) {
        int n;
        if (pos >= this.ncolumns) {
            return DoubleSeq.Mutable.empty();
        }
        if (-pos >= this.nrows) {
            return DoubleSeq.Mutable.empty();
        }
        int beg = 0;
        int inc = 1 + this.nrows;
        if (pos > 0) {
            beg = pos * this.nrows;
            n = Math.min(this.nrows, this.ncolumns - pos);
        } else if (pos < 0) {
            beg = -pos;
            n = Math.min(this.nrows + pos, this.ncolumns);
        } else {
            n = Math.min(this.nrows, this.ncolumns);
        }
        return DoubleSeq.Mutable.of(this.storage, beg, n, inc);
    }

    @Override
    public DoubleSeq.Mutable diagonal() {
        int inc = 1 + this.nrows;
        int n = Math.min(this.nrows, this.ncolumns);
        return DoubleSeq.Mutable.of(this.storage, 0, n, inc);
    }

    @Override
    public int getColumnsCount() {
        return this.ncolumns;
    }

    @Override
    public int getRowsCount() {
        return this.nrows;
    }

    public String toString() {
        return Matrix.format(this);
    }
}

