/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.OldHiddenNucleotides;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;

public abstract class AbstractCovarionDNAModel
extends AbstractSubstitutionModel {
    public static final String HIDDEN_CLASS_RATES = "hiddenClassRates";
    public static final String SWITCHING_RATES = "switchingRates";
    public static final String FREQUENCIES = "frequencies";
    Parameter switchingRates;
    Parameter hiddenClassRates;
    byte[] rateMatrixMap;
    byte[] hiddenClassMap;
    private int hiddenClassCount;

    public AbstractCovarionDNAModel(String string, OldHiddenNucleotides oldHiddenNucleotides, Parameter parameter, Parameter parameter2, FrequencyModel frequencyModel) {
        super(string, oldHiddenNucleotides, frequencyModel);
        this.hiddenClassCount = oldHiddenNucleotides.getHiddenClassCount();
        this.hiddenClassRates = parameter;
        this.switchingRates = parameter2;
        assert (parameter.getDimension() == this.hiddenClassCount - 1);
        int n = this.getHiddenClassCount();
        int n2 = n * (n - 1) / 2;
        if (parameter2.getDimension() != n2) {
            throw new IllegalArgumentException("switching rate parameter must have " + n2 + " rates for " + n + " classes");
        }
        this.addVariable(parameter2);
        this.addVariable(parameter);
        this.constructRateMatrixMap();
    }

    abstract double[] getRelativeDNARates();

    public final int getHiddenClassCount() {
        return this.hiddenClassCount;
    }

    @Override
    public void frequenciesChanged() {
    }

    @Override
    public void ratesChanged() {
        this.setupRelativeRates();
    }

    @Override
    protected void setupRelativeRates() {
        double[] dArray = this.switchingRates.getParameterValues();
        double[] dArray2 = this.getRelativeDNARates();
        double[] dArray3 = this.hiddenClassRates.getParameterValues();
        for (int i = 0; i < this.rateCount; ++i) {
            if (this.rateMatrixMap[i] == 0) {
                this.relativeRates[i] = 0.0;
                continue;
            }
            if (this.rateMatrixMap[i] < 7) {
                if (this.hiddenClassMap[i] == 0) {
                    this.relativeRates[i] = dArray2[this.rateMatrixMap[i] - 1];
                    continue;
                }
                this.relativeRates[i] = dArray2[this.rateMatrixMap[i] - 1] * dArray3[this.hiddenClassMap[i] - 1];
                continue;
            }
            this.relativeRates[i] = dArray[this.rateMatrixMap[i] - 7];
        }
    }

    private void constructRateMatrixMap() {
        int n = 0;
        this.rateMatrixMap = new byte[this.rateCount];
        this.hiddenClassMap = new byte[this.rateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = i + 1; j < this.stateCount; ++j) {
                byte by;
                int n2 = i % 4;
                int n3 = j % 4;
                int n4 = i / 4;
                int n5 = j / 4;
                if (n2 == n3) {
                    if (n4 == n5) {
                        throw new RuntimeException("Shouldn't be possible");
                    }
                    by = (byte)(7 + this.getIndex(n4, n5, this.hiddenClassCount));
                } else {
                    by = n4 != n5 ? (byte)0 : (byte)(1 + this.getIndex(n2, n3, 4));
                }
                this.rateMatrixMap[n] = by;
                this.hiddenClassMap[n] = (byte)n4;
                ++n;
            }
        }
    }

    private int getIndex(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n5 > 0) {
            n4 += n3 - 1;
            --n5;
            --n3;
        }
        return n4 += n2 - n - 1;
    }

    @Override
    void normalize(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        double d = 0.0;
        int n4 = dArray2.length;
        for (n3 = 0; n3 < n4; ++n3) {
            d += -dArray[n3][n3] * dArray2[n3];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i < n4; ++i) {
                dArray[n3][i] = dArray[n3][i] / d;
            }
        }
        double d2 = 0.0;
        for (n2 = 0; n2 < this.hiddenClassCount; ++n2) {
            for (n = n2 + 1; n < this.hiddenClassCount; ++n) {
                for (int i = 0; i < 4; ++i) {
                    int n5 = n2 * 4 + i;
                    int n6 = n * 4 + i;
                    d2 += dArray[n5][n6] * dArray2[n6];
                    d2 += dArray[n6][n5] * dArray2[n5];
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n4; ++n) {
                dArray[n2][n] = dArray[n2][n] / (1.0 - d2);
            }
        }
    }
}

