# Licensing Information for `OncoDataSets` Package

This package, `OncoDataSets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **cancer_in_dogs_tbl_df**: 
  Originally cancer_in_dogs from the openintro package, licensed under GPL-3. The dataset name has been changed to 'cancer_in_dogs_tbl_df' to indicate that this dataset is a tibble object.

- **Melanoma_df**: 
  Originally Melanoma from the MASS package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'Melanoma_df' to indicate that this dataset is a data frame object.
   
- **ChildCancer_df**: 
  Originally ChildCancer from the DTDA package, licensed under GPL-2. The dataset name has been changed to 'ChildCancer_df' to indicate that this dataset is a data frame object.
   
- **SmallCellLung_tbl_df**: 
  Originally Censored from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'SmallCellLung_tbl_df' to indicate that this dataset is a tibble object.
  
- **BreastCancerWI_df**: 
  Originally data_wdbc from the cases package, licensed under MIT + file LICENSE. The dataset name has been changed to 'BreastCancerWI_df' to indicate that this dataset is a data frame object.   

- **WBreastCancer_tbl_df**: 
  Originally mammaca from the psfmi package, licensed under GPL (>= 2). The dataset name has been changed to 'WBreastCancer_tbl_df' to indicate that this dataset is a tibble object.    


- **CASP8BreastCancer_df**: 
  Originally dat.frank2008 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'CASP8BreastCancer_df' to indicate that this dataset is a data frame object.   

- **LungCancerETS_df**: 
  Originally dat.hackshaw1998 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'LungCancerETS_df' to indicate that this dataset is a data frame object.   

- **HeadNeckCarcinoma_df**: 
  Originally dat.pignon2000 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'HeadNeckCarcinoma_df' to indicate that this dataset is a data frame object.   


- **LeukemiaSurvival_df**: 
  Originally anderson from the autoReg package, licensed under GPL-3. The dataset name has been changed to 'LeukemiaSurvival_df' to indicate that this dataset is a data frame object.     

- **BRCA1BreastCancer_df**: 
  Originally BRCA1 from the riskyr package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'BRCA1BreastCancer_df' to indicate that this dataset is a data frame object.   

- **BRCA1OvarianCancer_df**: 
  Originally BRCA1_ova from the riskyr package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'BRCA1OvarianCancer_df' to indicate that this dataset is a data frame object.   

- **BRCA2BreastCancer_df**: 
  Originally BRCA2 from the riskyr package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'BRCA2BreastCancer_df' to indicate that this dataset is a data frame object.   

- **BRCA2OvarianCancer_df**: 
  Originally BRCA2_ova from riskyr package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'BRCA2OvarianCancer_df' to indicate that this dataset is a data frame object.   

- **CancerSmokeCity_array**: 
  Originally lung_cancer from the flatr package, licensed under MIT + file LICENSE. The dataset name has been changed to 'CancerSmokeCity_array' to indicate that this dataset is an array object.   

- **VALungCancer_list**: 
  Originally Lung from the ncvreg package, licensed under GPL-3. The dataset name has been changed to 'VALungCancer_list' to indicate that this dataset is a list object.     

- **PSAProstateCancer_df**: 
  Originally prostate from the ncvreg package, licensed under GPL-3. The dataset name has been changed to 'PSAProstateCancer_df' to indicate that this dataset is a data frame object.


- **NCCTGLungCancer_df**: 
  Originally lung from the nftbart package, licensed under GPL (>= 2). The dataset name has been changed to 'NCCTGLungCancer_df' to indicate that this dataset is a data frame object.  

- **BladderCancer_df**: 
  Originally bladder from the survival package, licensed under LGPL (>= 2). The dataset name has been changed to 'BladderCancer_df' to indicate that this dataset is a data frame object.  

- **ColonCancerChemo_df**: 
  Originally colon from the survival package, licensed under LGPL (>= 2). The dataset name has been changed to 'ColonCancerChemo_df' to indicate that this dataset is a data frame object.  

- **MaleMiceCancer_df**: 
  Originally hoel from the survival package, licensed under LGPL (>= 2). The dataset name has been changed to 'MaleMiceCancer_df' to indicate that this dataset is a data frame object.  

- **OvarianCancer_df**: 
  Originally ovarian from the survival package, licensed under LGPL (>= 2). The dataset name has been changed to 'OvarianCancer_df' to indicate that this dataset is a data frame object.  

- **RotterdamBreastCancer_df**: 
  Originally rotterdam from the survival package, licensed under LGPL (>= 2). The dataset name has been changed to 'RotterdamBreastCancer_df' to indicate that this dataset is a data frame object.   

- **UKLungCancerDeaths_df**: 
  Originally lung.cancer from the SMPracticals package, licensed under GPL (>= 2). The dataset name has been changed to 'UKLungCancerDeaths_df' to indicate that this dataset is a data frame object.   

- **MiceDeathRadiation_df**: 
  Originally mice from the SMPracticals package, licensed under GPL (>= 2). The dataset name has been changed to 'MiceDeathRadiation_df' to indicate that this dataset is a data frame object.   

- **NodalProstate_df**: 
  Originally nodal from the SMPracticals package, licensed under GPL (>= 2). The dataset name has been changed to 'NodalProstate_df' to indicate that this dataset is a data frame object.   

- **ProstateMethylation_df**: 
  Originally pca.methylation.data from the betaclust package, licensed under GPL-3. The dataset name has been changed to 'ProstateMethylation_df' to indicate that this dataset is a data frame object.   

- **ProstateSurvival_df**: 
  Originally prostateSurvival from the asaur package, licensed under CC0. The dataset name has been changed to 'ProstateSurvival_df' to indicate that this dataset is a data frame object.  

- **BloodStorageProstate_df**: 
  Originally blood_storage from the medicaldata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'BloodStorageProstate_df' to indicate that this dataset is a data frame object.   

- **RadiationEffects_df**: 
  Originally dicentric from the faraway package, licensed under GPL. The dataset name has been changed to 'RadiationEffects_df' to indicate that this dataset is a data frame object.  

- **ProstateSurgery_df**: 
  Originally prostate from the faraway package, licensed under GPL. The dataset name has been changed to 'ProstateSurgery_df' to indicate that this dataset is a data frame object. 

- **AflatoxinLiverCancer_df**: 
  Originally aflatoxin from the faraway package, licensed under GPL. The dataset name has been changed to 'AflatoxinLiverCancer_df' to indicate that this dataset is a data frame object.   

- **VinylideneLiverCancer_df**: 
  Originally vinylidene from the goric package, licensed under GPL (>= 2). The dataset name has been changed to 'VinylideneLiverCancer_df' to indicate that this dataset is a data frame object.   

- **ICGCLiver_df**: 
  Originally LIRI from the ggrisk package, licensed under GPL-2. The dataset name has been changed to 'ICGCLiver_df' to indicate that this dataset is a data frame object.   

- **CA19PancreaticCancer_df**: 
  Originally CA19 from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'CA19PancreaticCancer_df' to indicate that this dataset is a data frame object.  


- **AIPulmonaryNodules_df**: 
  Originally IPNs from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'AIPulmonaryNodules_df' to indicate that this dataset is a data frame object.   

- **SmokingLungCancer_df**: 
  Originally LungCa from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'SmokingLungCancer_df' to indicate that this dataset is a data frame object.   

- **LungNodulesDetected_df**: 
  Originally Nodules from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'LungNodulesDetected_df' to indicate that this dataset is a data frame object. 

- **LeukemiaRemission_df**: 
  Originally Remission from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'LeukemiaRemission_df' to indicate that this dataset is a data frame object.    


- **SuspectedCancer_df**: 
  Originally SCAN from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'SuspectedCancer_df' to indicate that this dataset is a data frame object. 

- **CervicalCancer_df**: 
  Originally Smartphone from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'CervicalCancer_df' to indicate that this dataset is a data frame object.   

- **USCancerStats_df**: 
  Originally USCancerStats from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'USCancerStats_df' to indicate that this dataset is a data frame object.   

- **LeukemiaLymphomaCases_df**: 
  Originally NHumbersidecas from the rsatscan package, licensed under GPL-3. The dataset name has been changed to 'LeukemiaLymphomaCases_df' to indicate that this dataset is a data frame object.   

- **LeukemiaLymphomaControl_df**: 
  Originally NHumbersidectl from the rsatscan package, licensed under GPL-3. The dataset name has been changed to 'LeukemiaLymphomaControl_df' to indicate that this dataset is a data frame object.   


- **LeukemiaLymphomaGeo_df**: 
  Originally NHumbersidegeo from the rsatscan package, licensed under GPL-3. The dataset name has been changed to 'LeukemiaLymphomaGeo_df' to indicate that this dataset is a data frame object.   


- **BrainCancerCases_df**: 
  Originally NMcas from the rsatscan package, licensed under GPL-3. The dataset name has been changed to 'BrainCancerCases_df' to indicate that this dataset is a data frame object.   

- **BrainCancerGeo_df**: 
  Originally NMgeo from the rsatscan package, licensed under GPL-3. The dataset name has been changed to 'BrainCancerGeo_df' to indicate that this dataset is a data frame object.   


- **AlcoholIntakeCancer_df**: 
  Originally alcohol from the mixmeta package, licensed under GPL (>= 2). The dataset name has been changed to 'AlcoholIntakeCancer_df' to indicate that this dataset is a data frame object.    

- **Carcinoma_p53_df**: 
  Originally p53 from the mixmeta package, licensed under GPL (>= 2). The dataset name has been changed to 'Carcinoma_p53_df' to indicate that this dataset is a data frame object.    
  
- **ColorectalMiRNAs_tbl_df**: 
  Originally df_crc from the miRetrieve package, licensed under GPL (>= 2). The dataset name has been changed to 'ColorectalMiRNAs_tbl_df' to indicate that this dataset is a tibble object.    

- **PancreaticMiRNAs_tbl_df**: 
  Originally df_panc from the miRetrieve package, licensed under GPL (>= 2). The dataset name has been changed to 'PancreaticMiRNAs_tbl_df' to indicate that this dataset is a tibble object.    
      
- **EndometrialCancer_df**: 
  Originally endometrial from the enrichwith package, licensed under GPL-2 or GPL-3. The dataset name has been changed to 'EndometrialCancer_df' to indicate that this dataset is a data frame object.    
      
- **USMortalityCancer_df**: 
  Originally USMortality from the lattice package, licensed under GPL (>= 2). The dataset name has been changed to 'USMortalityCancer_df' to indicate that this dataset is a data frame object.    
      
- **USRegionalMortality_df**: 
  Originally USRegionalMortality from the lattice package, licensed under GPL (>= 2). The dataset name has been changed to 'USRegionalMortality_df' to indicate that this dataset is a data frame object.    
        
- **SkinCancerChemo_df**: 
  Originally skiTum from the spef package, licensed under GPL (>= 3). The dataset name has been changed to 'SkinCancerChemo_df' to indicate that this dataset is a data frame object.  
  
  
 
## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `OncoDataSets`, is licensed under the GPL-3 License.
 
