/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;

public class Personality {
    private Map types = CollectionFactory.createHashedMap();

    protected Personality() {
    }

    public Personality(Personality other) {
        this();
        this.add(other);
    }

    public Personality add(Class interf, Implementation impl) {
        this.types.put(interf, impl);
        return this;
    }

    public Personality copy() {
        return new Personality(this);
    }

    Implementation getImplementation(Class t) {
        return (Implementation)this.types.get(t);
    }

    Personality add(Personality p) {
        this.types.putAll(p.types);
        return this;
    }

    public Polymorphic newInstance(Class interf, Node n, Polymorphic that) {
        Implementation impl = (Implementation)this.types.get(interf);
        if (impl == null) {
            throw new PersonalityConfigException(interf + " not in Personality.");
        }
        EnhNode rslt = impl.wrap(n, (EnhGraph)that);
        if (!interf.isInstance(rslt)) {
            throw new PersonalityConfigException(interf + " misconfigured.");
        }
        return rslt;
    }

    protected Map getMap() {
        return this.types;
    }
}

