/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.TitledBorder;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.functions.Logistic;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ThresholdVisualizePanel
extends VisualizePanel {
    private String m_ROCString = "";
    private String m_savePanelBorderText;

    public ThresholdVisualizePanel() {
        TitledBorder titledBorder = (TitledBorder)this.m_plotSurround.getBorder();
        this.m_savePanelBorderText = titledBorder.getTitle();
    }

    public void setROCString(String string) {
        this.m_ROCString = string;
    }

    public String getROCString() {
        return this.m_ROCString;
    }

    public void setUpComboBoxes(Instances instances) {
        super.setUpComboBoxes(instances);
        this.m_XCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdVisualizePanel.this.setBorderText();
            }
        });
        this.m_YCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdVisualizePanel.this.setBorderText();
            }
        });
        this.setBorderText();
    }

    private void setBorderText() {
        String string = this.m_XCombo.getSelectedItem().toString();
        String string2 = this.m_YCombo.getSelectedItem().toString();
        if (string.equals("X: False Positive Rate (Num)") && string2.equals("Y: True Positive Rate (Num)")) {
            this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(this.m_savePanelBorderText + " " + this.m_ROCString));
        } else {
            this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(this.m_savePanelBorderText));
        }
    }

    protected void openVisibleInstances(Instances instances) throws Exception {
        super.openVisibleInstances(instances);
        this.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances), 4) + ")");
        this.setBorderText();
    }

    public static void main(String[] stringArray) {
        Instances instances = null;
        Classifier classifier = null;
        int n = 2;
        int n2 = 10;
        boolean bl = true;
        Instances instances2 = null;
        SingleIndex singleIndex = null;
        SingleIndex singleIndex2 = null;
        int n3 = 1;
        try {
            Object object;
            Object object2;
            Object object3;
            if (Utils.getFlag('h', stringArray)) {
                System.out.println("\nOptions for " + ThresholdVisualizePanel.class.getName() + ":\n");
                System.out.println("-h\n\tThis help.");
                System.out.println("-t <file>\n\tDataset to process with given classifier.");
                System.out.println("-c <num>\n\tThe class index. first and last are valid, too (default: last).");
                System.out.println("-C <num>\n\tThe index of the class value to get the the curve for (default: first).");
                System.out.println("-W <classname>\n\tFull classname of classifier to run.\n\tOptions after '--' are passed to the classifier.\n\t(default: weka.classifiers.functions.Logistic)");
                System.out.println("-r <number>\n\tThe number of runs to perform (default: 1).");
                System.out.println("-x <number>\n\tThe number of Cross-validation folds (default: 10).");
                System.out.println("-S <number>\n\tThe seed value for randomizing the data (default: 1).");
                System.out.println("-l <file>\n\tPreviously saved threshold curve ARFF file.");
                return;
            }
            String string = Utils.getOption('l', stringArray);
            if (string.length() != 0) {
                instances2 = new Instances(new BufferedReader(new FileReader(string)));
                bl = false;
            }
            if (bl) {
                String[] stringArray2;
                string = Utils.getOption('r', stringArray);
                n = string.length() != 0 ? Integer.parseInt(string) : 1;
                string = Utils.getOption('x', stringArray);
                n2 = string.length() != 0 ? Integer.parseInt(string) : 10;
                string = Utils.getOption('S', stringArray);
                n3 = string.length() != 0 ? Integer.parseInt(string) : 1;
                string = Utils.getOption('t', stringArray);
                if (string.length() != 0) {
                    instances = new Instances(new BufferedReader(new FileReader(string)));
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                if ((string = Utils.getOption('W', stringArray)).length() != 0) {
                    stringArray2 = Utils.partitionOptions(stringArray);
                } else {
                    string = Logistic.class.getName();
                    stringArray2 = new String[]{};
                }
                classifier = Classifier.forName(string, stringArray2);
                string = Utils.getOption('c', stringArray);
                singleIndex = string.length() != 0 ? new SingleIndex(string) : new SingleIndex("last");
                string = Utils.getOption('C', stringArray);
                singleIndex2 = string.length() != 0 ? new SingleIndex(string) : new SingleIndex("first");
            }
            if (bl) {
                if (singleIndex != null) {
                    singleIndex.setUpper(instances.numAttributes() - 1);
                    instances.setClassIndex(singleIndex.getIndex());
                } else {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                if (singleIndex2 != null) {
                    singleIndex2.setUpper(instances.classAttribute().numValues() - 1);
                }
                object3 = new ThresholdCurve();
                object2 = new EvaluationUtils();
                object = new FastVector();
                for (int i = 0; i < n; ++i) {
                    ((EvaluationUtils)object2).setSeed(n3 + i);
                    ((FastVector)object).appendElements(((EvaluationUtils)object2).getCVPredictions(classifier, instances, n2));
                }
                instances2 = singleIndex2 != null ? ((ThresholdCurve)object3).getCurve((FastVector)object, singleIndex2.getIndex()) : ((ThresholdCurve)object3).getCurve((FastVector)object);
            }
            object3 = new ThresholdVisualizePanel();
            ((ThresholdVisualizePanel)object3).setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances2), 4) + ")");
            if (bl) {
                ((VisualizePanel)object3).setName(instances2.relationName() + ". (Class value " + instances.classAttribute().value(singleIndex2.getIndex()) + ")");
            } else {
                ((VisualizePanel)object3).setName(instances2.relationName() + " (display only)");
            }
            object2 = new PlotData2D(instances2);
            ((PlotData2D)object2).setPlotName(instances2.relationName());
            ((PlotData2D)object2).addInstanceNumberAttribute();
            ((VisualizePanel)object3).addPlot((PlotData2D)object2);
            object = ((VisualizePanel)object3).getName();
            final JFrame jFrame = new JFrame("Weka Classifier Visualize: " + (String)object);
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)object3, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

