/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.sol;

import com.dashoptimization.XPRMInitializationFrom;
import com.dashoptimization.XPRMInitializeContext;
import com.dashoptimization.XPRMLicenseError;
import com.dashoptimization.XPRMModel;
import com.dashoptimization.XPRMTyped;
import com.dashoptimization.XPRMValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.act.rscat.cat.ExposureControlType;
import org.act.rscat.mip.Constraint;
import org.act.rscat.mip.SolverConfig;
import org.act.rscat.mip.SolverOutput;
import org.act.rscat.testdef.Item;
import org.act.rscat.testdef.ItemRealTimeData;
import org.act.rscat.testdef.Passage;
import org.act.rscat.testdef.PassageRealTimeData;
import org.act.rscat.testdef.TestConfig;
import org.act.rscat.util.ContentTable;
import org.act.rscat.util.Xprm;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAssembly {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAssembly.class);
    private static final String MILLIS = "ms";
    private static final String ATTR_DELIMITER = "\\|";
    private DynamicModelInit dmInit;
    private final TestConfig testConfig;
    private final SolverConfig solverConfig;
    private int itemNum;
    private int passageNum;
    private int constraintNum;
    private int reqPassageNumLB;
    private int reqPassageNumUB;
    private List<Item> itemList = new ArrayList<Item>();
    private List<ItemRealTimeData> itemRealTimeDataList = new ArrayList<ItemRealTimeData>();
    private List<String> itemIdList = new ArrayList<String>();
    private List<Passage> passageList = new ArrayList<Passage>();
    private List<PassageRealTimeData> passageRealTimeDataList = new ArrayList<PassageRealTimeData>();
    private List<String> passageIdList = new ArrayList<String>();
    private List<Integer> itemPassageIndices = new ArrayList<Integer>();
    private double objCost;
    private Map<String, List<String>> selectedPassageItemMap = new HashMap<String, List<String>>();
    private List<String> adminedItemList = new ArrayList<String>();
    private List<Constraint> constraintList = new ArrayList<Constraint>();
    private MoselInput moselInput;
    private MoselOutput moselOutput;
    private XPRMModel mod = Xprm.newModel();
    private double buildingTime;
    private double solvingTime;
    private double otherTime;
    private double totalSolverTime;

    public TestAssembly(TestConfig testConfig, SolverConfig solverConfig) throws IOException {
        this.testConfig = testConfig;
        this.solverConfig = solverConfig;
        this.reqPassageNumLB = testConfig.getNumPassageLB();
        this.reqPassageNumUB = testConfig.getNumPassageUB();
        this.loadDataFromTable(testConfig);
        this.itemNum = this.itemList.size();
        this.constraintNum = this.constraintList.size();
        this.dmInit = new DynamicModelInit(this.itemList, this.itemIdList, this.passageList, this.constraintList);
    }

    public SolverOutput assembleTest(int stageIndex, double theta, double bigM, ExposureControlType exposureType) throws IOException {
        int exposureTypeIndicator;
        if (stageIndex == 0) {
            this.prepareModel();
        }
        this.updateModel(stageIndex);
        this.mod.setExecParam("STUDENT_THETA", theta);
        this.mod.setExecParam("BIG_M", bigM);
        switch (exposureType) {
            case ITEM: {
                exposureTypeIndicator = 1;
                break;
            }
            case PASSAGE: {
                exposureTypeIndicator = 2;
                break;
            }
            case NONE: {
                exposureTypeIndicator = 0;
                break;
            }
            default: {
                exposureTypeIndicator = 0;
            }
        }
        this.mod.setExecParam("EXPOSURE_TYPE", exposureTypeIndicator);
        this.mod.run();
        SolverOutput optResult = this.processMIPSol(this.mod);
        this.mod.reset();
        return optResult;
    }

    private void updateModel(int stepIndex) {
        long updateModelStart = System.currentTimeMillis();
        for (ItemRealTimeData itemRealTimeData : this.moselInput.itemRealTimeDataArr) {
            itemRealTimeData.info = this.itemRealTimeDataList.get((int)itemRealTimeData.rowIndex).info;
            itemRealTimeData.isAdmined = this.itemRealTimeDataList.get((int)itemRealTimeData.rowIndex).isAdmined;
            itemRealTimeData.isEligible = this.itemRealTimeDataList.get((int)itemRealTimeData.rowIndex).isEligible;
            itemRealTimeData.isEligibleHard = this.itemRealTimeDataList.get((int)itemRealTimeData.rowIndex).isEligibleHard;
        }
        this.mod.setExecParam("STEP_INDEX", stepIndex);
        long updateModelEnd = System.currentTimeMillis();
        LOGGER.trace("Update model time: {} {}", (Object)(updateModelEnd - updateModelStart), (Object)MILLIS);
    }

    private void prepareModel() throws XPRMLicenseError {
        long prepareModelStart = System.currentTimeMillis();
        this.moselInput = new MoselInput(this.itemList, this.passageList, this.constraintList, ArrayUtils.toPrimitive((Integer[])this.itemPassageIndices.toArray(new Integer[this.itemPassageIndices.size()])));
        this.moselOutput = new MoselOutput(this.itemNum, this.passageNum, this.constraintNum);
        this.mod.unbindAll();
        this.mod.bind("dti", (Object)this.moselInput.itemRealTimeDataArr);
        this.mod.bind("dtp", (Object)this.moselInput.passageRealTimeDataArr);
        this.mod.bind("cnst", (Object)this.moselInput.constraintArr);
        this.mod.bind("pidc", (Object)this.moselInput.itemPassageIndicesArr);
        this.mod.bind("solx", (Object)this.moselOutput.xSolutions);
        this.mod.bind("solz", (Object)this.moselOutput.zSolutions);
        this.mod.bind("dmInitInst", (Object)this.dmInit);
        this.mod.setExecParam("ITEM_REALTIME_DATA", "dti(rowIndex,info,isEligible,isEligibleHard,isAdmined)");
        this.mod.setExecParam("PASSAGE_REALTIME_DATA", "dtp(rowIndex,isEligible)");
        this.mod.setExecParam("LENGTH", this.testConfig.getTestLength());
        this.mod.setExecParam("PASSAGE_NUM_LB", this.reqPassageNumLB);
        this.mod.setExecParam("PASSAGE_NUM_UB", this.reqPassageNumUB);
        this.mod.setExecParam("ITEM_NUM_PER_PASSAGE_LB", this.testConfig.getNumItemPerPassageLB());
        this.mod.setExecParam("ITEM_NUM_PER_PASSAGE_UB", this.testConfig.getNumItemPerPassageUB());
        this.mod.setExecParam("CNST_DATA", "cnst(rowIndex,type,level,calAttr,calLB,calUB)");
        this.mod.setExecParam("ITEM_PASSAGE_INDEX_DATA", "noindex,pidc");
        this.mod.setExecParam("DYNAMIC_DATAFILE", "java:dmInitInst");
        this.mod.setExecParam("SOL_X", "noindex,solx");
        this.mod.setExecParam("SOL_Z", "noindex,solz");
        this.mod.setExecParam("WEIGHT_ELG", this.testConfig.getEligibilityPriority());
        this.mod.setExecParam("WEIGHT_LENGTH", this.testConfig.getLengthPriority());
        this.mod.setExecParam("ENABLE_ENEMY_ITEM", this.testConfig.isEnableEnemyItemConstraint());
        this.mod.setExecParam("USED_BIT_LENGTH", 31);
        this.mod.setExecParam("CNST_GA_BIT_ARRAY_ITEM_NUM", this.itemNum / 31 + 1);
        this.mod.setExecParam("CNST_GA_BIT_ARRAY_PASSAGE_NUM", this.passageNum / 32 + 1);
        this.mod.setExecParam("STAND_ALONE", false);
        this.mod.setExecParam("SAVE_INPUT", this.solverConfig.isSaveInput());
        long prepareModelEnd = System.currentTimeMillis();
        LOGGER.trace("prepare model time: {}{}", (Object)(prepareModelEnd - prepareModelStart), (Object)MILLIS);
    }

    private SolverOutput processMIPSol(XPRMModel modSol) {
        int solverStatusCode = ((XPRMValue)modSol.findIdentifier("probstat")).asInteger();
        this.buildingTime = ((XPRMValue)modSol.findIdentifier("build_time")).asReal();
        this.solvingTime = ((XPRMValue)modSol.findIdentifier("solve_time")).asReal();
        this.otherTime = ((XPRMValue)modSol.findIdentifier("other_time")).asReal();
        this.totalSolverTime = this.buildingTime + this.solvingTime + this.otherTime;
        this.objCost = modSol.getObjectiveValue();
        LOGGER.trace("Shadow test assembly objective value = {}", (Object)this.objCost);
        this.selectedPassageItemMap.clear();
        ArrayList<String> selectedItemIdentifiers = new ArrayList<String>();
        ArrayList<Integer> selectedItemRowIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.moselOutput.xSolutions.length; ++i) {
            if (!(this.moselOutput.xSolutions[i] >= 0.9)) continue;
            Item selectedItem = this.itemList.get(i);
            String selectedPassageId = selectedItem.getCategAttrs().get(1);
            if (!"".equals(selectedPassageId)) {
                if (this.selectedPassageItemMap.keySet() == null || !this.selectedPassageItemMap.keySet().contains(selectedPassageId)) {
                    ArrayList<String> selectedItemList = new ArrayList<String>();
                    selectedItemList.add(this.itemIdList.get(i));
                    this.selectedPassageItemMap.put(selectedPassageId, selectedItemList);
                } else {
                    this.selectedPassageItemMap.get(selectedPassageId).add(this.itemIdList.get(i));
                }
            }
            selectedItemIdentifiers.add(this.itemIdList.get(i));
            selectedItemRowIndices.add(i);
        }
        LOGGER.trace("Total number of items in the shadow test: {}", (Object)selectedItemIdentifiers.size());
        ArrayList<String> selectedPassageIdentifiers = new ArrayList<String>();
        ArrayList<Integer> selectedPassageRowIndices = new ArrayList<Integer>();
        ArrayList<Integer> passageSequence = new ArrayList<Integer>();
        TreeMap map = new TreeMap();
        for (int j = 0; j < this.moselOutput.zSolutions.length; ++j) {
            if (!(this.moselOutput.zSolutions[j] >= 0.9)) continue;
            selectedPassageIdentifiers.add(this.passageIdList.get(j));
            selectedPassageRowIndices.add(j);
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            passageSequence.add(i);
        }
        return new SolverOutput.SolverOutputBuilder().selectedItemIdentifiers(selectedItemIdentifiers).selectedItemRowIndices(selectedItemRowIndices).selectedPassageIdentifiers(selectedPassageIdentifiers).selectedPassageRowIndices(selectedPassageRowIndices).passageRowIndexSequence(passageSequence).objective(this.objCost).solverStatus(solverStatusCode).build();
    }

    private void loadDataFromTable(TestConfig testConfig) {
        List<String> columnNames;
        int rowIndex = 0;
        ContentTable itemPoolTable = testConfig.getItemPoolTable();
        int itemIdColumnIndex = testConfig.getItemIdColumnIndex();
        int passageIdColumnIndexItemPool = testConfig.getPassageIdColumnIndexItemPool();
        boolean[] itemNumericColumns = testConfig.getItemNumericColumn();
        ContentTable passageTable = testConfig.getPassageTable();
        int passageIdColumnIndex = testConfig.getPassageIdColumnIndexPassagePool();
        boolean[] passageNumericColumns = testConfig.getPassageNumericColumn();
        ContentTable constraintTable = testConfig.getConstraintTable();
        if (passageTable != null) {
            columnNames = passageTable.columnNames();
            for (List<String> row : passageTable.rows()) {
                String passageId = row.get(passageIdColumnIndex);
                Passage passage = new Passage(passageId, row, columnNames, passageNumericColumns, rowIndex);
                this.passageList.add(passage);
                PassageRealTimeData realTimeData = new PassageRealTimeData(passageId, rowIndex, true);
                this.passageRealTimeDataList.add(realTimeData);
                this.passageIdList.add(passageId);
                ++rowIndex;
            }
        }
        this.passageNum = this.passageList.size();
        rowIndex = 0;
        columnNames = itemPoolTable.columnNames();
        for (List<String> row : itemPoolTable.rows()) {
            String itemId = row.get(itemIdColumnIndex);
            Item item = new Item(itemId, row, columnNames, itemNumericColumns, rowIndex);
            this.itemList.add(item);
            this.itemIdList.add(itemId);
            ItemRealTimeData itemRealTimeData = new ItemRealTimeData(itemId, rowIndex, 0.0, true, true, false);
            this.itemRealTimeDataList.add(itemRealTimeData);
            String passageId = row.get(passageIdColumnIndexItemPool);
            int passageIndex = this.passageIdList.indexOf(passageId);
            this.itemPassageIndices.add(passageIndex);
            item.getCategAttrsNames().add("IsDiscreteItem");
            item.getCategAttrs().add(passageIndex >= 0 ? String.valueOf(false) : String.valueOf(true));
            ++rowIndex;
        }
        this.itemNum = this.itemList.size();
        if (constraintTable != null) {
            int loadColumnIndex = constraintTable.columnNames().indexOf(Constraint.ColumnName.IS_LOADED.getName());
            for (List<String> row : constraintTable.rows()) {
                String[] data = row.toArray(new String[0]);
                if (!String.valueOf(true).equalsIgnoreCase(data[loadColumnIndex])) continue;
                Constraint constraint = new Constraint(constraintTable.columnNames(), data, this.constraintList.size());
                this.constraintList.add(constraint);
            }
        }
        this.constraintNum = this.constraintList.size();
    }

    public List<Item> getItemList() {
        return this.itemList;
    }

    public List<String> getAdminedItemList() {
        return this.adminedItemList;
    }

    public List<Constraint> getConstraintList() {
        return this.constraintList;
    }

    public List<String> getItemIdList() {
        return this.itemIdList;
    }

    public double getBuildingTime() {
        return this.buildingTime;
    }

    public double getSolvingTime() {
        return this.solvingTime;
    }

    public double getOtherTime() {
        return this.otherTime;
    }

    public double getTotalSolverTime() {
        return this.totalSolverTime;
    }

    public List<Passage> getPassageList() {
        return this.passageList;
    }

    public List<String> getPassageIdList() {
        return this.passageIdList;
    }

    public double getObjCost() {
        return this.objCost;
    }

    public List<ItemRealTimeData> getItemRealTimeDataList() {
        return this.itemRealTimeDataList;
    }

    public List<PassageRealTimeData> getPassageRealTimeDataList() {
        return this.passageRealTimeDataList;
    }

    public static class DynamicModelInit
    implements XPRMInitializationFrom {
        private List<Item> itemList;
        private List<String> itemIdList;
        private List<Passage> passageList;
        private List<Constraint> constraintList;

        public DynamicModelInit(List<Item> itemList, List<String> itemIdList, List<Passage> passageList, List<Constraint> constraintList) {
            this.itemList = itemList;
            this.itemIdList = itemIdList;
            this.passageList = passageList;
            this.constraintList = constraintList;
        }

        public boolean initializeFrom(XPRMInitializeContext ictx, String label, XPRMTyped type) {
            try {
                switch (label) {
                    case "ITEM_NUM_ATTRS_DATA": {
                        ictx.sendControl(1);
                        for (Item item : this.itemList) {
                            int attrIndx = 0;
                            for (String attrName : item.getNumericAttrsNames()) {
                                ictx.sendControl(3);
                                ictx.send(item.getRowIndex());
                                ictx.send(attrName);
                                ictx.sendControl(4);
                                ictx.send(item.getNumericAttrs().get(attrIndx).doubleValue());
                                ++attrIndx;
                            }
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "ITEM_CATG_ATTRS_DATA": {
                        ictx.sendControl(1);
                        for (Item item : this.itemList) {
                            int attrIndx = 0;
                            for (String attrName : item.getCategAttrsNames()) {
                                ictx.sendControl(3);
                                ictx.send(item.getRowIndex());
                                ictx.send(attrName);
                                ictx.sendControl(4);
                                ictx.send(item.getCategAttrs().get(attrIndx));
                                ++attrIndx;
                            }
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "ITEM_PRECLUDES_DATA": {
                        ictx.sendControl(1);
                        int precludesIdx = this.itemList.get(0).getCategAttrsNames().indexOf("Precludes");
                        if (precludesIdx != -1) {
                            for (Item item : this.itemList) {
                                ictx.sendControl(3);
                                ictx.send(item.getRowIndex());
                                ictx.sendControl(4);
                                String precludesStr = item.getCategAttrs().get(precludesIdx);
                                ictx.sendControl(1);
                                if (!"None".equalsIgnoreCase(precludesStr)) {
                                    String[] precludeItems;
                                    for (String itemId : precludeItems = precludesStr.split(TestAssembly.ATTR_DELIMITER)) {
                                        if (!this.itemIdList.contains(itemId)) continue;
                                        ictx.send(this.itemIdList.indexOf(itemId));
                                    }
                                }
                                ictx.sendControl(2);
                            }
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "PASSAGE_NUM_ATTRS_DATA": {
                        ictx.sendControl(1);
                        for (Passage passage : this.passageList) {
                            int attrIndx = 0;
                            for (String attrName : passage.getNumericAttrsNames()) {
                                ictx.sendControl(3);
                                ictx.send(passage.getRowIndex());
                                ictx.send(attrName);
                                ictx.sendControl(4);
                                ictx.send(passage.getNumericAttrs().get(attrIndx).doubleValue());
                                ++attrIndx;
                            }
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "PASSAGE_CATG_ATTRS_DATA": {
                        ictx.sendControl(1);
                        for (Passage passage : this.passageList) {
                            int attrIndx = 0;
                            for (String attrName : passage.getCategAttrsNames()) {
                                ictx.sendControl(3);
                                ictx.send(passage.getRowIndex());
                                ictx.send(attrName);
                                ictx.sendControl(4);
                                ictx.send(passage.getCategAttrs().get(attrIndx));
                                ++attrIndx;
                            }
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "CNST_FILTER_SET_ATTR_DATA": {
                        ictx.sendControl(1);
                        for (Constraint cnst : this.constraintList) {
                            ictx.sendControl(3);
                            ictx.send(cnst.rowIndex);
                            ictx.sendControl(4);
                            ictx.sendControl(1);
                            for (String data : cnst.filterSetData.keySet()) {
                                ictx.send(data);
                            }
                            ictx.sendControl(2);
                            ictx.sendControl(127);
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "CNST_FILTER_BOUND_ATTR_DATA": {
                        ictx.sendControl(1);
                        for (Constraint cnst : this.constraintList) {
                            ictx.sendControl(3);
                            ictx.send(cnst.rowIndex);
                            ictx.sendControl(4);
                            ictx.sendControl(1);
                            for (String data : cnst.filterBoundsData.keySet()) {
                                ictx.send(data);
                            }
                            ictx.sendControl(2);
                            ictx.sendControl(127);
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "CNST_FILTER_SET_DATA": {
                        ictx.sendControl(1);
                        for (Constraint cnst : this.constraintList) {
                            for (Map.Entry<String, Set<String>> entry : cnst.filterSetData.entrySet()) {
                                ictx.sendControl(3);
                                ictx.send(cnst.rowIndex);
                                ictx.send(entry.getKey());
                                ictx.sendControl(4);
                                ictx.sendControl(1);
                                for (String data : entry.getValue()) {
                                    ictx.send(data);
                                }
                                ictx.sendControl(2);
                            }
                            ictx.sendControl(127);
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                    case "CNST_FILTER_BOUND_DATA": {
                        ictx.sendControl(1);
                        for (Constraint cnst : this.constraintList) {
                            for (Map.Entry<String, List<Double>> entry : cnst.filterBoundsData.entrySet()) {
                                ictx.sendControl(3);
                                ictx.send(cnst.rowIndex);
                                ictx.send(entry.getKey());
                                ictx.sendControl(4);
                                ictx.sendControl(1);
                                for (double data : entry.getValue()) {
                                    ictx.send(data);
                                }
                                ictx.sendControl(2);
                            }
                            ictx.sendControl(127);
                        }
                        ictx.sendControl(2);
                        return true;
                    }
                }
                LOGGER.error("Label {} not found.", (Object)label);
                return false;
            }
            catch (IOException e) {
                LOGGER.error("{} could not be initialized", (Object)label);
                return false;
            }
        }
    }

    public class DoubleWithStrIdx {
        public String key;
        public double value;
    }

    public class DoubleWithIntIdx {
        public int key = -1;
        public double value;
    }

    private static class MoselOutput {
        double[] xSolutions;
        double[] zSolutions;

        MoselOutput(int itemNum, int passagePoolSize, int cnstNum) {
            this.xSolutions = new double[itemNum];
            this.zSolutions = new double[passagePoolSize];
        }
    }

    private class MoselInput {
        ItemRealTimeData[] itemRealTimeDataArr;
        PassageRealTimeData[] passageRealTimeDataArr;
        String[] itemIdArr;
        Constraint[] constraintArr;
        int[] itemPassageIndicesArr;

        MoselInput(List<Item> itemList, List<Passage> passageList, List<Constraint> constraintList, int[] itemPassageIndices) {
            int i;
            this.itemIdArr = new String[itemList.size()];
            this.itemRealTimeDataArr = new ItemRealTimeData[itemList.size()];
            this.passageRealTimeDataArr = new PassageRealTimeData[passageList.size()];
            this.constraintArr = new Constraint[constraintList.size()];
            this.itemPassageIndicesArr = itemPassageIndices;
            for (i = 0; i < itemList.size(); ++i) {
                this.itemIdArr[i] = itemList.get(i).getId();
                this.itemRealTimeDataArr[i] = (ItemRealTimeData)TestAssembly.this.itemRealTimeDataList.get(i);
            }
            for (i = 0; i < passageList.size(); ++i) {
                this.passageRealTimeDataArr[i] = (PassageRealTimeData)TestAssembly.this.passageRealTimeDataList.get(i);
            }
            for (i = 0; i < constraintList.size(); ++i) {
                this.constraintArr[i] = constraintList.get(i);
            }
        }
    }
}

