## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>", 
  collapse = TRUE
)
library(UAHDataScienceSF)

## -----------------------------------------------------------------------------
data <- c(1,1,2,3,4,7,8,8,8,10,10,11,12,15,20,22,25)
plot(data); 
data2 <- c(1,1,4,5,5,5,7,8,10,10,10,11,20,22,22,24,25)
plot(data2);

#Binomial variables
n = 3
x = 2
p = 0.7
    
#Poisson variables
lam = 2
k = 3

#Normal variables
nor = 0.1

#T-Student variables
xt = 290 
ut = 310
st = 50
nt = 16


## -----------------------------------------------------------------------------
# Simple calculation
mean_(data)

# Learning mode with step-by-step explanation
mean_(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# mean_(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
geometric_mean(data)

# Learning mode with step-by-step explanation
geometric_mean(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# geometric_mean(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
mode_(data)

# Learning mode with step-by-step explanation
mode_(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# mode_(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
median_(data)

# Learning mode with step-by-step explanation
median_(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# median_(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
standard_deviation(data)

# Learning mode with step-by-step explanation
standard_deviation(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# standard_deviation(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
average_deviation(data)

# Learning mode with step-by-step explanation
average_deviation(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# average_deviation(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
variance(data)

# Learning mode with step-by-step explanation
variance(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# variance(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
quartile(data)

# Learning mode with step-by-step explanation
quartile(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# quartile(interactive = TRUE)


## -----------------------------------------------------------------------------
# Simple calculation
percentile(data, 0.3)

# Learning mode with step-by-step explanation
percentile(data, 0.3, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# percentile(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
absolute_frequency(data, 1)

# Learning mode with step-by-step explanation
absolute_frequency(data, 1, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# absolute_frequency(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
relative_frequency(data, 20)

# Learning mode with step-by-step explanation
relative_frequency(data, 20, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# relative_frequency(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
absolute_acum_frequency(data, 1)

# Learning mode with step-by-step explanation
absolute_acum_frequency(data, 1, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# absolute_acum_frequency(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
relative_acum_frequency(data, 20)

# Learning mode with step-by-step explanation
relative_acum_frequency(data, 20, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# relative_acum_frequency(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
covariance(data, data2)

# Learning mode with step-by-step explanation
covariance(data, data2, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# covariance(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
harmonic_mean(data)

# Learning mode with step-by-step explanation
harmonic_mean(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# harmonic_mean(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
pearson(data, data2)

# Learning mode with step-by-step explanation
pearson(data, data2, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# pearson(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
cv(data)

# Learning mode with step-by-step explanation
cv(data, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# cv(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
laplace(data, data2)

# Learning mode with step-by-step explanation
laplace(data, data2, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# laplace(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
binomial_(n, x, p)

# Learning mode with step-by-step explanation
binomial_(n, x, p, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# binomial_(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
poisson_(k, lam)

# Learning mode with step-by-step explanation
poisson_(k, lam, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# poisson_(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
normal(nor)

# Learning mode with step-by-step explanation
normal(nor, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# normal(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
tstudent(xt, ut, st, nt)

# Learning mode with step-by-step explanation
tstudent(xt, ut, st, nt, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# tstudent(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
chisquared(data, data2)

# Learning mode with step-by-step explanation
chisquared(data, data2, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# chisquared(interactive = TRUE)

## -----------------------------------------------------------------------------
# Simple calculation
fisher(data, data2)

# Learning mode with step-by-step explanation
fisher(data, data2, learn = TRUE)

# Interactive mode would be called like this (cannot be ran in vignette):
# fisher(interactive = TRUE)

