/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import com.miraisolutions.xlconnect.utils.DateTimeFormatter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class RPOSIXDateTimeFormatter
implements DateTimeFormatter {
    private final Map<String, java.time.format.DateTimeFormatter> cache = new HashMap<String, java.time.format.DateTimeFormatter>();

    private java.time.format.DateTimeFormatter getFormatter(String format) {
        if (this.cache.containsKey(format)) {
            return this.cache.get(format);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        block21: for (int i = 0; i < format.length(); ++i) {
            if (format.charAt(i) == '%' && i + 1 < format.length()) {
                char specifier = format.charAt(++i);
                switch (specifier) {
                    case '%': {
                        builder.appendLiteral("%");
                        break;
                    }
                    case 'a': {
                        builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT);
                        break;
                    }
                    case 'A': {
                        builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.FULL);
                        break;
                    }
                    case 'b': {
                        builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT);
                        break;
                    }
                    case 'B': {
                        builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL);
                        break;
                    }
                    case 'c': {
                        throw new UnsupportedOperationException("%c not yet implemented");
                    }
                    case 'd': {
                        builder.appendValue(ChronoField.DAY_OF_MONTH, 2);
                        break;
                    }
                    case 'H': {
                        builder.appendValue(ChronoField.HOUR_OF_DAY, 2);
                        break;
                    }
                    case 'I': {
                        builder.appendValue(ChronoField.CLOCK_HOUR_OF_AMPM, 2);
                        break;
                    }
                    case 'j': {
                        builder.appendValue(ChronoField.DAY_OF_YEAR, 3);
                        break;
                    }
                    case 'm': {
                        builder.appendValue(ChronoField.MONTH_OF_YEAR, 2);
                        break;
                    }
                    case 'M': {
                        builder.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
                        break;
                    }
                    case 'p': {
                        builder.appendText(ChronoField.AMPM_OF_DAY);
                        break;
                    }
                    case 'O': {
                        if (i + 1 >= format.length()) {
                            builder.appendLiteral("%O");
                            break;
                        }
                        if (format.charAt(++i) == 'S') {
                            int n = 3;
                            if (i + 1 < format.length()) {
                                n = Integer.parseInt(Character.toString(format.charAt(++i)));
                            }
                            builder.appendValue(ChronoField.SECOND_OF_MINUTE);
                            if (n <= 0) continue block21;
                            builder.appendLiteral('.');
                            builder.appendFraction(ChronoField.SECOND_OF_MINUTE, n, n, true);
                            break;
                        }
                        throw new UnsupportedOperationException("%O[dHImMUVwWy] not yet implemented");
                    }
                    case 'S': {
                        builder.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
                        break;
                    }
                    case 'y': {
                        builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, 1969);
                        break;
                    }
                    case 'Y': {
                        builder.appendValue(ChronoField.YEAR, 4);
                        break;
                    }
                    case 'z': {
                        builder.appendOffset("+HH:mm", "+0000");
                        break;
                    }
                    case 'Z': {
                        builder.appendZoneOrOffsetId();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("%" + specifier + " not yet implemented");
                    }
                }
                continue;
            }
            builder.appendLiteral(format.substring(i, i + 1));
        }
        java.time.format.DateTimeFormatter formatter = builder.toFormatter();
        this.cache.put(format, formatter);
        return formatter;
    }

    @Override
    public String format(Date d, String format) {
        StringBuffer sb = new StringBuffer();
        this.getFormatter(format).formatTo(LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()), sb);
        return sb.toString();
    }

    @Override
    public Date parse(String s, String format) {
        ZonedDateTime zoned;
        java.time.format.DateTimeFormatter formatter = this.getFormatter(format);
        try {
            zoned = ZonedDateTime.parse(s, formatter);
        }
        catch (DateTimeParseException e) {
            TemporalAccessor parsed = formatter.parse(s);
            zoned = ZonedDateTime.of(LocalDateTime.from(parsed), ZoneId.systemDefault());
        }
        return new Date(Instant.from(zoned).toEpochMilli());
    }
}

