## ----include=FALSE------------------------------------------------------------
# Keep vignette fast and CRAN-safe: disable evaluation by default
knitr::opts_chunk$set(
  collapse = TRUE, comment = "#>",
  eval = FALSE, message = FALSE, warning = FALSE
)

## -----------------------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#   install.packages("BiocManager")
# BiocManager::install(c("Biostrings", "BSgenome.Hsapiens.UCSC.hg38"))
# 
# install.packages("gwasrapidd")  # required for GWAS retrieval
# 
# if (!requireNamespace("devtools", quietly = TRUE))
#   install.packages("devtools")
# devtools::install_github("leopard0ly/gwas2crispr")

## -----------------------------------------------------------------------------
# library(gwas2crispr)
# 
# # Lung disease (EFO_0000707), GRCh38/hg38
# run_gwas2crispr(
#   efo_id     = "EFO_0000707",
#   p_cut      = 1e-6,
#   flank_bp   = 300,
#   out_prefix = "lung"   # produces: lung_snps_full.csv / lung_snps_hg38.bed / lung_snps_flank300.fa
# )

## -----------------------------------------------------------------------------
# library(gwas2crispr)
# 
# tmp <- tempdir()  # CRAN-safe target
# res <- run_gwas2crispr(
#   efo_id     = "EFO_0000707",
#   p_cut      = 1e-6,
#   flank_bp   = 300,
#   out_prefix = file.path(tmp, "lung"),  # writes here, not to user's home
#   verbose    = FALSE
# )
# 
# # Files written (list components or vector of paths, depending on return structure):
# res$csv
# res$bed
# res$fasta  # present only if BSgenome/Biostrings are installed

## ----eval=TRUE----------------------------------------------------------------
sessionInfo()

