/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PPrimHam;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Tools;

public class HamCanvas
extends BaseCanvas {
    SVar[] v;
    SVar vx;
    boolean showLabels = true;
    int gap = 0;
    Axis[] ai;

    public HamCanvas(int n, Frame frame, SVar[] sVarArray, SMarker sMarker) {
        super(n, frame, sMarker);
        this.setTitle("Hammock Plot");
        this.v = sVarArray;
        this.allow180 = false;
        this.vx = new SVarObj("Hammock.index", true);
        this.ay = new Axis(null, 1, 0);
        this.ay.addDepend(this);
        this.ay.setValueRange(0.0, 1.0);
        this.ai = new Axis[sVarArray.length];
        for (int i = 0; i < sVarArray.length; ++i) {
            this.ai[i] = new Axis(sVarArray[i], 1, sVarArray[i].isCat() ? 1 : 0);
            this.vx.add(sVarArray[i].getName());
        }
        this.ax = new Axis(this.vx, 0, 1);
        this.ax.addDepend(this);
        String[] stringArray = new String[]{"+", "File", "~File.Graph", "~Edit", "~Window", "0"};
        EzMenu.getEzMenu(frame, this, stringArray);
        this.setDefaultMargins(new int[]{10, 10, 10, 10});
        this.pp = null;
        this.dontPaint = false;
    }

    public void updateObjects() {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = this.getSize();
        int n5 = dimension.width;
        int n6 = dimension.height;
        int n7 = 0;
        while (n7 < this.ai.length) {
            this.ai[n7++].setGeometry(1, this.mLeft, n6 - this.mLeft * 2);
        }
        n5 -= this.mLeft * 2;
        n6 -= this.mLeft * 2;
        if (this.pp == null) {
            SVar sVar;
            int n8;
            n4 = 0;
            for (n8 = 0; n8 < this.v.length - 1; ++n8) {
                int n9;
                SVar sVar2 = this.v[n8];
                sVar = this.v[n8 + 1];
                int n10 = sVar2.getNumCats();
                n3 = sVar.getNumCats();
                n2 = sVar2.size();
                if (n10 <= 0 || n3 <= 0) continue;
                int[] nArray = new int[n10 * n3];
                for (n9 = 0; n9 < n2; ++n9) {
                    int n11 = sVar2.getCatIndex(n9);
                    int n12 = sVar.getCatIndex(n9);
                    if (n11 <= -1 || n12 <= -1) continue;
                    int n13 = n11 + n12 * n10;
                    nArray[n13] = nArray[n13] + 1;
                }
                for (n9 = 0; n9 < n10 * n3; ++n9) {
                    if (nArray[n9] <= 0) continue;
                    ++n4;
                }
            }
            this.pp = new PPrimHam[n4];
            n = 0;
            for (n8 = 0; n8 < this.v.length - 1; ++n8) {
                int n14;
                sVar = this.v[n8];
                SVar sVar3 = this.v[n8 + 1];
                n3 = sVar.getNumCats();
                n2 = sVar3.getNumCats();
                int n15 = sVar.size();
                if (n3 <= 0 || n2 <= 0) continue;
                int[] nArray = new int[n15];
                int[] nArray2 = new int[n3 * n2];
                int[] nArray3 = new int[n3 * n2];
                for (n14 = 0; n14 < n15; ++n14) {
                    int n16 = sVar.getCatIndex(n14);
                    int n17 = sVar3.getCatIndex(n14);
                    if (n16 <= -1 || n17 <= -1) continue;
                    int n18 = n16 + n17 * n3;
                    nArray2[n18] = nArray2[n18] + 1;
                    if (nArray3[n16 + n17 * n3] == 0) {
                        nArray3[n16 + n17 * n3] = ++n;
                    }
                    nArray[n14] = 1 + n16 + n17 * n3;
                }
                for (n14 = 0; n14 < n3 * n2; ++n14) {
                    if (nArray2[n14] <= 0) continue;
                    PPrimHam pPrimHam = new PPrimHam();
                    pPrimHam.ref = new int[nArray2[n14]];
                    pPrimHam.tmp = 0;
                    pPrimHam.total = n15;
                    pPrimHam.leftVar = n8;
                    this.pp[nArray3[n14] - 1] = pPrimHam;
                }
                for (n14 = 0; n14 < n15; ++n14) {
                    if (nArray[n14] <= 0) continue;
                    PPrimHam pPrimHam = (PPrimHam)this.pp[nArray3[nArray[n14] - 1] - 1];
                    pPrimHam.ref[pPrimHam.tmp] = n14;
                    ++pPrimHam.tmp;
                }
            }
        }
        for (n4 = 0; n4 < this.pp.length; ++n4) {
            PPrimHam pPrimHam = (PPrimHam)this.pp[n4];
            if (pPrimHam.ref == null || pPrimHam.ref.length <= 0) continue;
            n = pPrimHam.ref[0];
            int n19 = pPrimHam.leftVar;
            int n20 = this.ax.getValuePos(n19) + this.gap;
            n3 = this.ax.getValuePos(n19 + 1) - this.gap;
            n2 = this.ai[n19].getCasePos(n);
            int n21 = this.ai[n19 + 1].getCasePos(n);
            pPrimHam.updateAnchors(n20, n2, n3, n21, n6);
        }
        this.setUpdateRoot(0);
    }

    public void paintBack(PoGraSS poGraSS) {
        double d = this.ax.getSensibleTickDistance(50, 26);
        this.startAddingLabels();
        for (double d2 = this.ax.getSensibleTickStart(d); d2 < this.ax.vBegin + this.ax.vLen; d2 += d) {
            int n = this.ax.getValuePos(d2);
            if (!this.showLabels) continue;
            this.xLabels.add(n, this.H - this.mLeft, 0.5, 0.5, this.vx.isCat() ? this.vx.getCatAt((int)d2).toString() : this.ax.getDisplayableValue(d2));
        }
        this.endAddingLabels();
    }

    public String queryObject(int n) {
        PPrimHam pPrimHam = (PPrimHam)this.pp[n];
        double d = pPrimHam.getMarkedProportion(this.m, -1);
        int n2 = (int)((double)pPrimHam.cases() * d + 0.5);
        int n3 = pPrimHam.leftVar;
        return this.v[n3].getName() + ": " + this.v[n3].atS(pPrimHam.ref[0]) + "\n" + this.v[n3 + 1].getName() + ": " + this.v[n3 + 1].atS(pPrimHam.ref[0]) + "\n\n" + n2 + " of " + pPrimHam.cases() + " (" + Tools.getDisplayableValue(d * 100.0, 1) + "%) selected";
    }

    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
        if (keyEvent.getKeyChar() == 'l') {
            this.run(this, "labels");
        }
        if (keyEvent.getKeyChar() == 'a') {
            this.run(this, "alpha");
        }
        if (keyEvent.getKeyChar() == '.') {
            this.gap += 3;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
        if (keyEvent.getKeyChar() == ',') {
            this.gap -= 3;
            this.setUpdateRoot(0);
            this.updateObjects();
            this.repaint();
        }
    }

    public Object run(Object object, String string) {
        super.run(object, string);
        if (string == "labels") {
            this.showLabels = !this.showLabels;
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (string == "alpha" && this.pp != null && this.pp.length > 0) {
            boolean bl = !((PPrimHam)this.pp[0]).alwaysAlpha;
            int n = 0;
            while (n < this.pp.length) {
                ((PPrimHam)this.pp[n++]).alwaysAlpha = bl;
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
        return null;
    }

    public SVar getData(int n) {
        return n >= 0 && n < this.v.length ? this.v[n] : null;
    }
}

