## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(nnR)

## -----------------------------------------------------------------------------
layer_architecture = c(4,5,6,5)
create_nn(layer_architecture)


## -----------------------------------------------------------------------------
nn = create_nn(c(9,4,5,6))
dep(nn)


## -----------------------------------------------------------------------------
nn = create_nn(c(9,4,5,6))
param(nn)

## -----------------------------------------------------------------------------
nn = create_nn(c(9,4,5,6))
inn(nn)

## -----------------------------------------------------------------------------
nn = create_nn(c(9,4,5,6))
out(nn)

## -----------------------------------------------------------------------------
nn = create_nn(c(9,4,5,6))
hid(nn)

## -----------------------------------------------------------------------------
nn = create_nn(c(9,4,5,6))
lay(nn)

## -----------------------------------------------------------------------------
create_nn(c(1, 3, 5, 6)) |> inst(ReLU, 8)

## -----------------------------------------------------------------------------
create_nn(c(3,4,5,1)) |> inst(ReLU,c(1,2,3))

## -----------------------------------------------------------------------------
c(1,5,6,3,3) |> create_nn() -> nu_1
c(3,4,6,3,2) |> create_nn() -> nu_2
nu_2 |> comp(nu_1)


## -----------------------------------------------------------------------------
c(1,3,4,8,1) |> create_nn() -> nn
nn |> inst(ReLU,5)
2 |> slm(nn) |> inst(ReLU, 5)


## -----------------------------------------------------------------------------
c(1,3,4,8,1) |> create_nn() -> nn
nn |> inst(ReLU, 5)
nn |> srm(5) |> inst(ReLU,5)




## -----------------------------------------------------------------------------
c(3,4,6,3,7,1,3,4) |> create_nn() -> nn_1
c(2,6,4,5) |> create_nn() -> nn_2
(nn_1 |> stk(nn_2)) |> inst(ReLU, c(4,3,2,1,6))
print("Compare to:")
nn_1 |> inst(ReLU, c(4,3,2))
nn_2 |> inst(ReLU, c(1,6))



## -----------------------------------------------------------------------------
c(1,5,3,2,1) |> create_nn() -> nu
c(1,5,4,9,1) |> create_nn() -> mu

nu |> inst(ReLU,4) -> x_1
mu |> inst(ReLU,4) -> x_2
x_1 + x_2 -> result_1
print("The sum of the instantiated neural network is:")
print(result_1)

(nu |> nn_sum(mu)) |> inst(ReLU,4) -> result_2
print("The instation of their neural network sums")
print(result_2)

## -----------------------------------------------------------------------------
Sqr(2.1,0.1) |> inst(ReLU,5)

## -----------------------------------------------------------------------------
Prd(2.1,0.1) |> inst(ReLU, c(2,3))

## -----------------------------------------------------------------------------
Pwr(2.1, 0.1,3) |> inst(ReLU, 2)

## -----------------------------------------------------------------------------
Xpn(5,2.1,0.1) |> inst(ReLU, 2)
print("Compare to:")
exp(2)

## -----------------------------------------------------------------------------
Csn(3,2.1,0.1) |> inst(ReLU, 0.4)
print("Compare to:")
cos(0.4)

## -----------------------------------------------------------------------------
Sne(3,2.1,0.1) |> inst(ReLU, 0.4)
print("Compare to:")
sin(0.4)

## -----------------------------------------------------------------------------
h = 0.2
mesh = c(0,0+h)
samples = sin(mesh)
Trp(0.1) |> inst(ReLU, samples)
Trp(0.1) |> inst(Sigmoid, samples)
Trp(0.1) |> inst(Tanh, samples)

## -----------------------------------------------------------------------------
seq(0,pi, length.out = 1000) -> x
sin(x) -> samples

Etr(1000-1,pi/1000) |> inst(ReLU, samples)
print("Compare with:")
sin |> integrate(0,pi)

## -----------------------------------------------------------------------------
seq(0.01,5,length.out = 500) -> x 
sin(x) + log10(x) -> y
1 -> L
MC(x,y,L) |> inst(ReLU, 2.5)
print("Compare to:")
sin(2.5)+log10(2.5)

