/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.rule.extend.ExtensionStrategyEnum;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtendRuleConfig {
    public final double minImprovement;
    public final double minCondImprovement;
    public final double minConfidence;
    public final ExtensionStrategyEnum extType;
    private static final Logger LOGGER = Logger.getLogger(ExtendRuleConfig.class.getName());

    public ExtendRuleConfig(double minImprovement, double minCondImprovement, double minConfidence, ExtensionStrategyEnum extType) {
        this.minImprovement = minImprovement;
        this.minCondImprovement = minCondImprovement;
        this.minConfidence = minConfidence;
        this.extType = extType;
    }

    public ExtendRuleConfig() {
        this.minCondImprovement = -1.0;
        this.minImprovement = 0.0;
        this.minConfidence = 0.5;
        this.extType = ExtensionStrategyEnum.ConfImprovementAgainstLastConfirmedExtension;
    }

    public boolean conditionalAcceptRule(double curRuleconfidence, double lastConfirmedRuleConfidence) {
        if (curRuleconfidence - lastConfirmedRuleConfidence >= this.minCondImprovement) {
            LOGGER.finest("Change in confidence in conditional accept band, trying extensions");
            return true;
        }
        LOGGER.finest("Change in confidence outside conditional accept band, NOT trying extensions");
        return false;
    }

    public boolean acceptRule(double curRuleconfidence, double lastConfirmedRuleConfidence, double seedRuleConfidence, double curRuleSupport, double lastConfirmedRuleSupport) {
        LOGGER.log(Level.FINE, MessageFormat.format("Extension type: {0}, curRuleconfidence: {1}, lastConfirmedRuleConfidence: {2},  seedRuleConfidence:  {3}, curRuleSupport:  {4}, lastConfirmedRuleSupport: {5}", new Object[]{this.extType, curRuleconfidence, lastConfirmedRuleConfidence, seedRuleConfidence, curRuleSupport, lastConfirmedRuleSupport}));
        boolean returnVal = false;
        if (curRuleSupport < lastConfirmedRuleSupport) {
            returnVal = false;
        }
        switch (this.extType) {
            case ConfImprovementAgainstLastConfirmedExtension: {
                if (!(curRuleconfidence - lastConfirmedRuleConfidence >= this.minImprovement)) break;
                returnVal = true;
                break;
            }
            case ConfImprovementAgainstSeedRule: {
                if (!(curRuleconfidence - seedRuleConfidence >= this.minImprovement)) break;
                returnVal = true;
                break;
            }
            case MinConf: {
                if (!(curRuleconfidence >= this.minConfidence)) break;
                returnVal = true;
            }
        }
        if (returnVal) {
            LOGGER.finest("Improvement in confidence meeting criteria, not accepting");
        } else {
            LOGGER.finest("Improvement in confidence NOT meeting criteria, not accepting");
        }
        return returnVal;
    }
}

