/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.ring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smsd.ring.PathEdge;

@Deprecated
public class PathGraph {
    private final List<PathEdge> edges = new ArrayList<PathEdge>();
    private final List<IAtom> atoms = new ArrayList<IAtom>();
    private final IAtomContainer mol;

    public PathGraph(IAtomContainer molecule) {
        this.mol = molecule;
        this.loadEdges(molecule);
        this.loadNodes(molecule);
    }

    public void printPaths() {
        for (PathEdge edge : this.edges) {
            if (edge.isCycle()) {
                System.out.print("*");
            }
            for (IAtom atom : edge.getAtoms()) {
                System.out.print(this.mol.indexOf(atom) + "-");
            }
            System.out.println();
        }
    }

    public List<PathEdge> remove(IAtom atom) {
        List<PathEdge> oldEdges = this.getEdges(atom);
        ArrayList<PathEdge> result = new ArrayList<PathEdge>();
        for (PathEdge edge : oldEdges) {
            if (!edge.isCycle()) continue;
            result.add(edge);
        }
        oldEdges.removeAll(result);
        this.edges.removeAll(result);
        List<PathEdge> newEdges = this.spliceEdges(oldEdges);
        this.edges.removeAll(oldEdges);
        this.edges.addAll(newEdges);
        this.atoms.remove(atom);
        return result;
    }

    private List<PathEdge> spliceEdges(List<PathEdge> edges) {
        ArrayList<PathEdge> result = new ArrayList<PathEdge>();
        for (int i = 0; i < edges.size(); ++i) {
            for (int j = i + 1; j < edges.size(); ++j) {
                PathEdge splice = edges.get(j).splice(edges.get(i));
                if (splice == null) continue;
                result.add(splice);
            }
        }
        return result;
    }

    private List<PathEdge> getEdges(IAtom atom) {
        ArrayList<PathEdge> result = new ArrayList<PathEdge>();
        for (PathEdge edge : this.edges) {
            if (edge.isCycle()) {
                if (!edge.getAtoms().contains(atom)) continue;
                result.add(edge);
                continue;
            }
            if (!edge.getSource().equals(atom) && !edge.getTarget().equals(atom)) continue;
            result.add(edge);
        }
        return result;
    }

    private void loadEdges(IAtomContainer molecule) {
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            IBond bond = molecule.getBond(i);
            this.edges.add(new PathEdge(Arrays.asList(bond.getBegin(), bond.getEnd())));
        }
    }

    private void loadNodes(IAtomContainer molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            this.atoms.add(molecule.getAtom(i));
        }
    }
}

