/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

@Explained
public class PropDivXYZ
extends Propagator<IntVar> {
    private final IntVar X;
    private final IntVar Y;
    private final IntVar Z;
    private final IntVar absX;
    private final IntVar absY;
    private final IntVar absZ;

    public PropDivXYZ(IntVar x, IntVar y, IntVar z) {
        this(x, y, z, x.getModel().abs(x), x.getModel().abs(y), x.getModel().abs(z));
    }

    private PropDivXYZ(IntVar x, IntVar y, IntVar z, IntVar ax, IntVar ay, IntVar az) {
        super((Variable[])new IntVar[]{x, y, z, ax, ay, az}, (Priority)PropagatorPriority.TERNARY, false);
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.absX = ax;
        this.absY = ay;
        this.absZ = az;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean hasChanged;
        do {
            int mask = 0;
            mask += this.X.isInstantiated() ? 1 : 0;
            mask += this.Y.isInstantiated() ? 2 : 0;
            mask += this.Z.isInstantiated() ? 4 : 0;
            hasChanged = this.Y.removeValue(0, this, Reason.undef());
            if (this.outInterval(this.Y, 0, 0)) {
                return;
            }
            switch (mask) {
                case 0: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    break;
                }
                case 1: {
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    if (!this.X.isInstantiatedTo(0)) break;
                    hasChanged |= this.Z.instantiateTo(0, this, this.lcg() ? Reason.r(this.X.getValLit()) : Reason.undef());
                    break;
                }
                case 2: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsZ();
                    break;
                }
                case 3: {
                    int vx = this.X.getValue();
                    int vy = this.Y.getValue();
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    int vz = vx / vy;
                    if (!this.inInterval(this.Z, vz, vz, this.lcg() ? Reason.r(this.X.getValLit(), this.Y.getValLit()) : Reason.undef())) break;
                    return;
                }
                case 4: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    if (!this.Z.isInstantiatedTo(0) || this.X.contains(0)) break;
                    hasChanged |= this.absX.updateUpperBound(this.absY.getUB() - 1, this, this.lcg() ? Reason.r(0, this.Z.getValLit(), this.X.getLit(0, 0), this.absY.getMaxLit()) : Reason.undef());
                    break;
                }
                case 5: {
                    int vx = this.X.getValue();
                    int vz = this.Z.getValue();
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsZ();
                    if (vz != 0 && vx == 0) {
                        this.fails(this.lcg() ? Reason.r(this.Z.getValLit(), this.X.getValLit()) : Reason.undef());
                    }
                    hasChanged |= this.updateAbsY();
                    break;
                }
                case 6: {
                    int vy = this.Y.getValue();
                    int vz = this.Z.getValue();
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    if (vz == 0) {
                        if (!this.inInterval(this.X, -Math.abs(vy) + 1, Math.abs(vy) - 1, this.lcg() ? Reason.r(this.Z.getValLit(), this.Y.getValLit()) : Reason.undef())) break;
                        return;
                    }
                    hasChanged |= this.updateAbsX();
                    break;
                }
                case 7: {
                    int vx = this.X.getValue();
                    int vy = this.Y.getValue();
                    int vz = this.Z.getValue();
                    int val = vx / vy;
                    if (vz != val) {
                        this.fails(this.lcg() ? Reason.r(0, this.X.getValLit(), this.Y.getValLit(), this.Z.getValLit()) : Reason.undef());
                        break;
                    }
                    return;
                }
                default: {
                    throw new SolverException("Unexpected mask " + mask);
                }
            }
            if (this.absX.getUB() < this.absY.getLB()) {
                hasChanged |= this.Z.instantiateTo(0, this, this.lcg() ? Reason.r(this.absX.getMaxLit(), this.absY.getMinLit()) : Reason.undef());
                continue;
            }
            if (this.X.getLB() > 0 && this.absX.getLB() >= this.absY.getUB()) {
                Reason r = this.lcg() ? Reason.r(0, this.X.getMinLit(), this.absX.getMinLit(), this.absY.getMaxLit()) : Reason.undef();
                hasChanged |= this.sameSign(this.Z, this.Y, r);
                hasChanged |= this.sameSign(this.Y, this.Z, r);
                continue;
            }
            if (this.X.getUB() >= 0 || this.absX.getLB() < this.absY.getUB()) continue;
            Reason r = this.lcg() ? Reason.r(0, this.X.getMaxLit(), this.absX.getMinLit(), this.absY.getMaxLit()) : Reason.undef();
            hasChanged |= this.oppSign(this.Z, this.Y, r);
            hasChanged |= this.oppSign(this.Y, this.Z, r);
        } while (hasChanged);
    }

    @Override
    public ESat isEntailed() {
        boolean neg;
        boolean pos;
        if (this.Y.isInstantiatedTo(0)) {
            return ESat.FALSE;
        }
        if (this.X.isInstantiatedTo(0) && !this.Z.contains(0)) {
            return ESat.FALSE;
        }
        boolean bl = pos = this.X.getLB() >= 0 && this.Y.getLB() >= 0 || this.X.getUB() < 0 && this.Y.getUB() < 0;
        if (pos && this.Z.getUB() < 0) {
            return ESat.FALSE;
        }
        boolean bl2 = neg = this.X.getLB() >= 0 && this.Y.getUB() < 0 || this.X.getUB() < 0 && this.Y.getLB() >= 0;
        if (neg && this.Z.getLB() > 0) {
            return ESat.FALSE;
        }
        int minAbsX = this.X.getLB() > 0 ? this.X.getLB() : (this.X.getUB() < 0 ? -this.X.getUB() : 0);
        int maxAbsX = Math.max(this.X.getUB(), -this.X.getLB());
        int minAbsY = this.Y.getLB() > 0 ? this.Y.getLB() : (this.Y.getUB() < 0 ? -this.Y.getUB() : 1);
        int maxAbsY = Math.max(this.Y.getUB(), -this.Y.getLB());
        int minAbsZ = this.Z.getLB() > 0 ? this.Z.getLB() : (this.Z.getUB() < 0 ? -this.Z.getUB() : 0);
        int maxAbsZ = Math.max(this.Z.getUB(), -this.Z.getLB());
        if (minAbsZ > maxAbsX / minAbsY || maxAbsZ < minAbsX / maxAbsY) {
            return ESat.FALSE;
        }
        if (this.Z.isInstantiatedTo(0) && minAbsX > maxAbsY || maxAbsX < minAbsY && !this.Z.contains(0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.X.getValue() / this.Y.getValue() == this.Z.getValue());
        }
        return ESat.UNDEFINED;
    }

    private boolean inInterval(IntVar v, int lb, int ub, Reason r) throws ContradictionException {
        if (v.getLB() >= lb && v.getUB() <= ub) {
            this.setPassive();
            return true;
        }
        if (v.getLB() <= ub && v.getUB() >= lb) {
            v.updateLowerBound(lb, this, r);
            v.updateUpperBound(ub, this, r);
            this.setPassive();
            return true;
        }
        this.fails();
        return false;
    }

    private boolean outInterval(IntVar v, int lb, int ub) throws ContradictionException {
        if (lb > ub) {
            this.setPassive();
            return true;
        }
        if (lb < ub) {
            if (v.getLB() > ub || v.getUB() < lb) {
                this.setPassive();
                return true;
            }
            if (v.getLB() >= lb && v.getUB() <= ub) {
                this.fails(Reason.undef());
            } else {
                if (v.getLB() >= lb) {
                    v.updateLowerBound(ub + 1, this, Reason.undef());
                } else if (v.getUB() <= ub) {
                    v.updateUpperBound(lb - 1, this, Reason.undef());
                }
                this.setPassive();
                return true;
            }
        }
        return false;
    }

    private boolean updateAbsX() throws ContradictionException {
        return this.absX.updateLowerBound(MathUtils.safeMultiply(this.absZ.getLB(), this.absY.getLB()), this, this.lcg() ? Reason.r(this.absZ.getMinLit(), this.absY.getMinLit()) : Reason.undef()) | this.absX.updateUpperBound(MathUtils.safeAdd(MathUtils.safeMultiply(this.absZ.getUB(), this.absY.getUB()), this.absY.getUB() - 1), this, this.lcg() ? Reason.r(this.absZ.getMaxLit(), this.absY.getMaxLit()) : Reason.undef());
    }

    private boolean updateAbsY() throws ContradictionException {
        int yub;
        boolean res = this.absZ.getLB() != 0 && this.absY.updateUpperBound((int)Math.floor((double)this.absX.getUB() * 1.0 / (double)this.absZ.getLB()), this, this.lcg() ? Reason.r(this.absX.getMaxLit(), this.absZ.getMinLit()) : Reason.undef());
        int zlb = this.absZ.getLB();
        int zub = this.absZ.getUB();
        int xlb = this.absX.getLB();
        int num = xlb - ((yub = this.absY.getUB()) - 1);
        res = num >= 0 && zub != 0 ? (res |= this.absY.updateLowerBound((int)Math.ceil((double)num * 1.0 / (double)zub), this, this.lcg() ? Reason.r(0, this.absX.getMinLit(), this.absY.getMaxLit(), this.absZ.getMaxLit()) : Reason.undef())) : (res |= zlb != 0 && this.absY.updateLowerBound(-((int)Math.floor((double)(-xlb + (yub - 1)) * 1.0 / (double)zlb)), this, this.lcg() ? Reason.r(0, this.absX.getMinLit(), this.absY.getMaxLit(), this.absZ.getMinLit()) : Reason.undef()));
        return res;
    }

    private boolean updateAbsZ() throws ContradictionException {
        int ylb;
        int yub;
        boolean res = this.absY.getLB() != 0 && this.absZ.updateUpperBound((int)Math.floor((double)this.absX.getUB() * 1.0 / (double)this.absY.getLB()), this, this.lcg() ? Reason.r(this.absX.getMaxLit(), this.absY.getMinLit()) : Reason.undef());
        int xlb = this.absX.getLB();
        int num = xlb - ((yub = this.absY.getUB()) - 1);
        res = num >= 0 && yub != 0 ? (res |= this.absZ.updateLowerBound((int)Math.ceil((double)num * 1.0 / (double)yub), this, this.lcg() ? Reason.r(this.absX.getMinLit(), this.absY.getMaxLit()) : Reason.undef())) : (res |= (ylb = this.absY.getLB()) != 0 && this.absZ.updateLowerBound(-((int)Math.floor((double)(-xlb + (yub - 1)) * 1.0 / (double)ylb)), this, this.lcg() ? Reason.r(0, this.absX.getMinLit(), this.absY.getMinLit(), this.absY.getMaxLit()) : Reason.undef()));
        return res;
    }

    protected boolean sameSign(IntVar a, IntVar b, Reason r) throws ContradictionException {
        boolean res = false;
        if (b.getLB() >= 0) {
            res = a.updateLowerBound(0, this, this.lcg() ? Reason.gather(r, b.getMinLit()) : Reason.undef());
        }
        if (b.getUB() <= 0) {
            res |= a.updateUpperBound(0, this, this.lcg() ? Reason.gather(r, b.getMaxLit()) : Reason.undef());
        }
        if (!b.contains(0)) {
            res |= a.removeValue(0, this, this.lcg() ? Reason.gather(r, b.getLit(0, 0)) : Reason.undef());
        }
        return res;
    }

    protected boolean oppSign(IntVar a, IntVar b, Reason r) throws ContradictionException {
        boolean res = false;
        if (b.getLB() >= 0) {
            res = a.updateUpperBound(0, this, this.lcg() ? Reason.gather(r, b.getMinLit()) : Reason.undef());
        }
        if (b.getUB() <= 0) {
            res |= a.updateLowerBound(0, this, this.lcg() ? Reason.gather(r, b.getMaxLit()) : Reason.undef());
        }
        if (b.contains(0)) {
            res |= a.removeValue(0, this, this.lcg() ? Reason.gather(r, b.getLit(0, 0)) : Reason.undef());
        }
        return res;
    }
}

