/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.learn;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.chocosolver.sat.Clause;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.loop.learn.Learn;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.VariableUtils;

public class LazyClauseGeneration
implements Learn {
    public static boolean VERBOSE = false;
    private static final String ON_FAILURE = "On SAT failure,";
    private static final String ON_SOLUTION = "On solution,";
    private final Solver mSolver;
    private final MiniSat mSat;
    private final int max_learnts;
    private long nbSolutions = 0L;
    private long nbRestarts = 0L;
    private final TIntArrayList learnt_clause = new TIntArrayList();

    public LazyClauseGeneration(Solver solver, MiniSat sat) {
        this.mSolver = solver;
        this.mSat = sat;
        this.max_learnts = this.mSolver.getModel().getSettings().getNbMaxLearntClauses();
    }

    @Override
    public void init() {
        this.mSat.setRootLevel();
    }

    @Override
    public boolean record() {
        if (this.nbSolutions == this.mSolver.getSolutionCount()) {
            this.onFailure();
        } else {
            ++this.nbSolutions;
            this.onSolution();
        }
        return true;
    }

    @Override
    public void forget() {
        if (this.nbRestarts == this.mSolver.getRestartCount()) {
            this.mSolver.cancelTrail();
            this.mSolver.getDecisionPath().synchronize(true, this.learnt_clause.size() > 1);
            if (!this.learnt_clause.isEmpty()) {
                this.mSat.addLearnt(this.learnt_clause);
            }
        } else {
            this.nbRestarts = this.mSolver.getRestartCount();
            if (this.mSolver.getSearchWorldIndex() == this.mSolver.getEnvironment().getWorldIndex()) {
                this.mSat.topLevelCleanUp();
            }
        }
        if (this.mSat.nLearnts() >= this.max_learnts) {
            this.mSat.doReduceDB();
        }
    }

    private void onFailure() {
        ContradictionException cex = this.mSolver.getContradictionException();
        int backtrack_level = this.analyze(cex, ON_FAILURE);
        int upto = this.mSolver.getEnvironment().getWorldIndex() - backtrack_level;
        if (upto > 1) {
            this.mSolver.getMeasures().incBackjumpCount();
        }
        this.mSolver.setJumpTo(upto);
    }

    private void onSolution() {
        assert (this.mSat.confl == MiniSat.C_Undef);
        if (!this.mSolver.getObjectiveManager().isOptimization()) {
            this.learnt_clause.resetQuick();
            this.extractFromVariables();
            this.mSat.confl = new Clause(this.learnt_clause, false);
            int backtrack_level = this.analyze(this.mSolver.getContradictionException().set(Cause.Sat, null, null), ON_SOLUTION);
            int upto = this.mSolver.getEnvironment().getWorldIndex() - backtrack_level;
            if (upto > 1) {
                this.mSolver.getMeasures().incBackjumpCount();
            }
            this.mSolver.setJumpTo(upto);
        }
    }

    private void extractFromVariables() {
        IntVar[] ivars = this.mSolver.getModel().retrieveIntVars(true);
        for (int i = 0; i < ivars.length; ++i) {
            if (VariableUtils.isView(ivars[i])) continue;
            this.learnt_clause.add(ivars[i].getValLit());
        }
    }

    private void extractFromDecisions() {
        DecisionPath path = this.mSolver.getDecisionPath();
        if (path.size() > 1) {
            int i = path.size() - 1;
            IntDecision dec = (IntDecision)path.getDecision(i);
            while (i > 1 && !dec.hasNext() && dec.getArity() > 1) {
                dec = (IntDecision)path.getDecision(--i);
            }
            while (i > 0) {
                dec = (IntDecision)path.getDecision(i);
                Object dom = null;
                IntVar var = (IntVar)dec.getDecisionVariable();
                if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntEq())) {
                    if (dec.hasNext() || dec.getArity() == 1) {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue(), 0));
                    } else {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue(), 1));
                    }
                } else if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntNeq())) {
                    if (dec.hasNext() || dec.getArity() == 1) {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue(), 1));
                    } else {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue(), 0));
                    }
                } else if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntSplit())) {
                    if (dec.hasNext() || dec.getArity() == 1) {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue() + 1, 2));
                    } else {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue(), 3));
                    }
                } else if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntReverseSplit())) {
                    if (dec.hasNext() || dec.getArity() == 1) {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue() - 1, 3));
                    } else {
                        this.learnt_clause.add(var.getLit(dec.getDecisionValue(), 2));
                    }
                }
                --i;
            }
        } else {
            this.learnt_clause.add(0);
        }
    }

    private int analyze(ContradictionException cex, String message) {
        int level;
        this.learnt_clause.resetQuick();
        if (this.mSat.confl != MiniSat.C_Undef) {
            Clause cl = this.mSat.confl;
            level = this.mSat.findConflictLevel();
            this.mSat.cancelUntil(level);
            level = this.mSat.analyze(cl, this.learnt_clause);
            if (VERBOSE) {
                System.out.printf("%s learn %s\n", message, Arrays.stream(this.learnt_clause.toArray()).mapToObj(v -> this.mSat.printLit(v) + ", ").reduce("", (s1, s2) -> s1 + " " + s2));
            }
        } else {
            System.err.print("On CP failure -- no learn\n");
            throw new SolverException("Unexpected contradiction:" + cex);
        }
        this.mSat.confl = MiniSat.C_Undef;
        return level;
    }
}

