/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public class OneValueDeltaMonitor
extends TimeStampedObject
implements IIntDeltaMonitor {
    protected final IEnumDelta delta;
    protected boolean used;
    protected ICause propagator;

    public OneValueDeltaMonitor(IEnumDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.used = false;
        this.propagator = propagator;
    }

    @Override
    public void startMonitoring() {
        this.delta.lazyClear();
        this.resetStamp();
        this.used = false;
    }

    private void freeze() {
        if (this.getTimeStamp() == -1) {
            throw new SolverException("Delta Monitor created in this is not activated. This should be the last instruction of p.propagate(int) by calling `monitor.startMonitoring()`");
        }
        if (this.needReset()) {
            this.delta.lazyClear();
            this.used = false;
            this.resetStamp();
        }
        if (this.getTimeStamp() != ((TimeStampedObject)((Object)this.delta)).getTimeStamp()) {
            throw new SolverException("Delta and monitor are not synchronized. \ndeltamonitor.freeze() is called but no value has been removed since the last call.");
        }
        this.used = this.delta.size() == 1;
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        this.freeze();
        if (this.used && this.propagator != this.delta.getCause(0)) {
            proc.execute(this.delta.get(0));
        }
        this.used = false;
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        this.freeze();
        if (this.used && this.propagator != this.delta.getCause(0)) {
            proc.execute(this.delta.get(0));
        }
        this.used = false;
    }

    @Override
    public int sizeApproximation() {
        return this.used && this.propagator != this.delta.getCause(0) ? 1 : 0;
    }
}

