/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.connectivity;

import gnu.trove.list.array.TIntArrayList;
import java.util.Iterator;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class ConnectivityFinder {
    private final int n;
    private final IGraph graph;
    private int[] CCFirstNode;
    private int[] CCNextNode;
    private int[] nodeCC;
    private final int[] p;
    private final int[] fifo;
    private int[] sizeCC;
    private int nbCC;
    private int sizeMinCC;
    private int sizeMaxCC;
    private int[] numOfNode;
    private int[] nodeOfNum;
    private int[] inf;
    private final Iterator<Integer>[] iterators;
    TIntArrayList articulations;

    public ConnectivityFinder(IGraph g) {
        this.graph = g;
        this.n = g.getNbMaxNodes();
        this.p = new int[this.n];
        this.fifo = new int[this.n];
        this.iterators = new Iterator[this.n];
    }

    public int getNBCC() {
        return this.nbCC;
    }

    public int getSizeMinCC() {
        return this.sizeMinCC;
    }

    public int getSizeMaxCC() {
        return this.sizeMaxCC;
    }

    public int[] getSizeCC() {
        return this.sizeCC;
    }

    public int[] getCCFirstNode() {
        return this.CCFirstNode;
    }

    public int[] getCCNextNode() {
        return this.CCNextNode;
    }

    public int[] getNodeCC() {
        return this.nodeCC;
    }

    public void findAllCC() {
        if (this.nodeCC == null) {
            this.CCFirstNode = new int[this.n];
            this.CCNextNode = new int[this.n];
            this.nodeCC = new int[this.n];
            this.sizeCC = new int[this.n];
        }
        this.sizeMinCC = 0;
        this.sizeMaxCC = 0;
        ISet act = this.graph.getNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.p[i] = -1;
        }
        for (int i = 0; i < this.CCFirstNode.length; ++i) {
            this.CCFirstNode[i] = -1;
            this.sizeCC[i] = -1;
        }
        int cc = 0;
        ISetIterator iSetIterator2 = act.iterator();
        while (iSetIterator2.hasNext()) {
            int i = (Integer)iSetIterator2.next();
            if (this.p[i] != -1) continue;
            this.findCC(i, cc);
            if (this.sizeMinCC == 0 || this.sizeMinCC > this.sizeCC[cc]) {
                this.sizeMinCC = this.sizeCC[cc];
            }
            if (this.sizeMaxCC < this.sizeCC[cc]) {
                this.sizeMaxCC = this.sizeCC[cc];
            }
            ++cc;
        }
        this.nbCC = cc;
    }

    private void findCC(int start, int cc) {
        int first = 0;
        int last = 0;
        int size = 1;
        this.fifo[last++] = start;
        this.p[start] = start;
        this.add(start, cc);
        while (first < last) {
            int j;
            int i = this.fifo[first++];
            ISetIterator iSetIterator = this.graph.getSuccessorsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.p[j] != -1) continue;
                this.p[j] = i;
                this.add(j, cc);
                ++size;
                this.fifo[last++] = j;
            }
            if (!this.graph.isDirected()) continue;
            iSetIterator = this.graph.getPredecessorsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.p[j] != -1) continue;
                this.p[j] = i;
                this.add(j, cc);
                ++size;
                this.fifo[last++] = j;
            }
        }
        this.sizeCC[cc] = size;
    }

    private void add(int node, int cc) {
        this.nodeCC[node] = cc;
        this.CCNextNode[node] = this.CCFirstNode[cc];
        this.CCFirstNode[cc] = node;
    }

    public boolean isBiconnected() {
        int k;
        int start;
        int i;
        assert (!this.graph.isDirected());
        if (this.graph.getNodes().size() <= 1) {
            return false;
        }
        if (this.inf == null) {
            this.nodeOfNum = new int[this.n];
            this.numOfNode = new int[this.n];
            this.inf = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.inf[i] = Integer.MAX_VALUE;
            this.p[i] = -1;
            this.iterators[i] = this.graph.getSuccessorsOf(i).iterator();
        }
        i = start = act.iterator().next().intValue();
        this.numOfNode[start] = k = 0;
        this.nodeOfNum[k] = start;
        this.p[start] = start;
        int nbRootChildren = 0;
        while (true) {
            if (this.iterators[i].hasNext()) {
                int j = this.iterators[i].next();
                if (this.p[j] == -1) {
                    this.p[j] = i;
                    if (i == start && ++nbRootChildren > 1) {
                        return false;
                    }
                    i = j;
                    this.numOfNode[i] = ++k;
                    this.nodeOfNum[k] = i;
                    this.inf[i] = this.numOfNode[i];
                    continue;
                }
                if (this.p[i] == j) continue;
                this.inf[i] = Math.min(this.inf[i], this.numOfNode[j]);
                continue;
            }
            if (i == start) {
                return k >= act.size() - 1;
            }
            int q = this.inf[i];
            i = this.p[i];
            this.inf[i] = Math.min(q, this.inf[i]);
            if (q >= this.numOfNode[i] && i != start) break;
        }
        return false;
    }

    public TIntArrayList getArticulationPoints() {
        int k;
        int start;
        if (this.articulations == null) {
            this.articulations = new TIntArrayList();
        }
        if (this.inf == null) {
            this.nodeOfNum = new int[this.n];
            this.numOfNode = new int[this.n];
            this.inf = new int[this.n];
        }
        this.articulations.clear();
        ISet act = this.graph.getNodes();
        ISetIterator iter = act.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            this.inf[i] = Integer.MAX_VALUE;
            this.p[i] = -1;
            this.iterators[i] = this.graph.getSuccessorsOf(i).iterator();
        }
        int i = start = act.iterator().next().intValue();
        this.numOfNode[start] = k = 0;
        this.nodeOfNum[k] = start;
        this.p[start] = start;
        int nbRootChildren = 0;
        while (true) {
            if (this.iterators[i].hasNext()) {
                int j = this.iterators[i].next();
                if (this.p[j] == -1) {
                    this.p[j] = i;
                    if (i == start && ++nbRootChildren > 1) {
                        this.articulations.add(i);
                    }
                    i = j;
                    this.numOfNode[i] = ++k;
                    this.nodeOfNum[k] = i;
                    this.inf[i] = this.numOfNode[i];
                    continue;
                }
                if (this.p[i] == j) continue;
                this.inf[i] = Math.min(this.inf[i], this.numOfNode[j]);
                continue;
            }
            if (i == start) {
                if (k < act.size() - 1) {
                    throw new UnsupportedOperationException("disconnected graph");
                }
                return this.articulations;
            }
            int q = this.inf[i];
            i = this.p[i];
            this.inf[i] = Math.min(q, this.inf[i]);
            if (q < this.numOfNode[i] || i == start) continue;
            this.articulations.add(i);
        }
    }
}

