/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.variables.IntVar;

public abstract class AbstractIntObjManager
implements IObjectiveManager<IntVar> {
    private static final long serialVersionUID = 5539060355541720114L;
    protected final transient IntVar objective;
    protected final ResolutionPolicy policy;
    protected final int precision;
    protected int bestProvedLB;
    protected int bestProvedUB;
    protected transient IntUnaryOperator cutComputer = n -> n;

    public AbstractIntObjManager(AbstractIntObjManager objman) {
        this.objective = objman.objective;
        this.policy = objman.policy;
        this.precision = objman.precision;
        this.bestProvedLB = objman.bestProvedLB;
        this.bestProvedUB = objman.bestProvedUB;
        this.cutComputer = objman.cutComputer;
    }

    public AbstractIntObjManager(IntVar objective, ResolutionPolicy policy, int precision) {
        assert (Objects.nonNull(objective));
        this.objective = objective;
        assert (Objects.nonNull((Object)policy));
        this.policy = policy;
        this.precision = precision;
        this.bestProvedLB = objective.getLB() - 1;
        this.bestProvedUB = objective.getUB() + 1;
    }

    @Override
    public final IntVar getObjective() {
        return this.objective;
    }

    @Override
    public final ResolutionPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public final Number getBestLB() {
        return this.bestProvedLB;
    }

    @Override
    public final Number getBestUB() {
        return this.bestProvedUB;
    }

    @Override
    public final void setCutComputer(Function<Number, Number> cutComputer) {
        this.cutComputer = operand -> ((Number)cutComputer.apply(operand)).intValue();
    }

    public final void setCutComputer(IntUnaryOperator cutComputer) {
        this.cutComputer = cutComputer;
    }

    @Override
    public void setStrictDynamicCut() {
        this.cutComputer = n -> n + this.precision;
    }

    @Override
    public final void setWalkingDynamicCut() {
        this.cutComputer = n -> n;
    }

    public synchronized boolean updateBestLB(int lb) {
        if (this.bestProvedLB < lb) {
            this.bestProvedLB = lb;
            return true;
        }
        return false;
    }

    public synchronized boolean updateBestUB(int ub) {
        if (this.bestProvedUB > ub) {
            this.bestProvedUB = ub;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBestSolution(Number n) {
        return this.updateBestSolution(n.intValue());
    }

    public abstract boolean updateBestSolution(int var1);

    @Override
    public boolean updateBestSolution() {
        if (!this.objective.isInstantiated()) {
            throw new SolverException("objective variable (" + this.objective + ") is not instantiated on solution. Check constraints and/or decision variables.");
        }
        return this.updateBestSolution(this.objective.getValue());
    }

    @Override
    public void resetBestBounds() {
        this.bestProvedLB = this.objective.getLB() - 1;
        this.bestProvedUB = this.objective.getUB() + 1;
    }

    public String toString() {
        return String.format("%s %s = %d", new Object[]{this.policy, this.objective == null ? "?" : this.objective.getName(), this.getBestSolutionValue().intValue()});
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
        action.accept(this.objective);
    }
}

