/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack.structure;

import java.util.ArrayList;
import java.util.List;

public class FingerTree<NodeType, LeafType> {
    private ArrayList<NodeType> innerNodeTreeList;
    private ArrayList<LeafType> leafTreeList;

    public ArrayList<NodeType> getInnerNodeTreeList() {
        return this.innerNodeTreeList;
    }

    public ArrayList<LeafType> getLeafTreeList() {
        return this.leafTreeList;
    }

    public FingerTree(List<LeafType> sortedItems) {
        this.init(sortedItems);
    }

    protected FingerTree() {
    }

    protected void init(List<LeafType> sortedItems) {
        this.leafTreeList = new ArrayList<LeafType>(sortedItems);
        this.innerNodeTreeList = new ArrayList();
        int innerNodeSize = FingerTree.power2(1 + (int)(Math.log(sortedItems.size()) / Math.log(2.0))) - 1;
        this.innerNodeTreeList.ensureCapacity(innerNodeSize);
        for (int i = 0; i < innerNodeSize; ++i) {
            this.innerNodeTreeList.add(null);
        }
    }

    public int getLeafParentIndex(int leafIndex) {
        return this.getLeafParentIndex(leafIndex, true);
    }

    public int getLeafParentIndex(int leafIndex, boolean offset) {
        return Math.floorDiv((offset ? this.innerNodeTreeList.size() : 0) + leafIndex - 1, 2);
    }

    public int getParentIndex(int nodeIndex) {
        if (nodeIndex != 0 && (this.isLeaf(nodeIndex) || this.isInnerNode(nodeIndex))) {
            return Math.floorDiv(nodeIndex - 1, 2);
        }
        throw new IllegalArgumentException("Getting parent of an invalid index : " + Integer.toString(nodeIndex));
    }

    public int getFingerNeighboor(int nodeIndex, boolean right) {
        if (!FingerTree.isPowerOfTwo(right ? nodeIndex + 2 : nodeIndex + 1)) {
            int index = nodeIndex + (right ? 1 : -1);
            if (this.isLeaf(index) || this.isInnerNode(index)) {
                return index;
            }
            return -1;
        }
        return -1;
    }

    public int getLeftChild(int nodeIndex) {
        return 2 * nodeIndex + 1;
    }

    public int getBrother(int nodeIndex) {
        if (nodeIndex == 0) {
            return 0;
        }
        if (nodeIndex % 2 == 0) {
            return nodeIndex - 1;
        }
        if (nodeIndex == this.getInnerNodeTreeList().size() + this.getLeafTreeList().size() - 1) {
            return nodeIndex;
        }
        return nodeIndex + 1;
    }

    public int getRightChild(int nodeIndex) {
        return 2 * nodeIndex + 2;
    }

    public boolean isInnerNode(int index) {
        return index < this.innerNodeTreeList.size() && index >= 0;
    }

    public NodeType getInnerNode(int index) {
        return this.innerNodeTreeList.get(index);
    }

    public boolean isLeaf(int index) {
        return index >= this.innerNodeTreeList.size() && index < this.innerNodeTreeList.size() + this.leafTreeList.size();
    }

    public LeafType getLeaf(int index) {
        return this.leafTreeList.get(index - this.innerNodeTreeList.size());
    }

    public int getNextNode(int startingIndex, boolean right) {
        int index = startingIndex;
        while (index != 0 && index % 2 == (right ? 0 : 1)) {
            index = this.getParentIndex(index);
        }
        if (index == 0) {
            return -1;
        }
        return this.getFingerNeighboor(index, right);
    }

    public int leafToGlobalIndex(int index) {
        return index + this.getInnerNodeTreeList().size();
    }

    public int globalToLeaf(int index) {
        return index - this.getInnerNodeTreeList().size();
    }

    public int getNumberNodes() {
        return this.getLeafTreeList().size() + this.getInnerNodeTreeList().size();
    }

    public int getNumberLeaves() {
        return this.getLeafTreeList().size();
    }

    public static boolean isPowerOfTwo(int x) {
        return x != 0 && (x & x - 1) == 0;
    }

    public static int power2(int exponant) {
        return 1 << exponant;
    }
}

