/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.data.FilteringDataRecordIterator;
import org.vikamine.kernel.data.IncludingDataRecordFilter;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsBuilder;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.search.FPNode;
import org.vikamine.kernel.subgroup.search.FPTree;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.FastSelector;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SDMap
extends SDMethod {
    public static final String NAME = "SDMAP";
    private final boolean reorderByOptimisticEstimate = true;
    protected SGTarget target;
    double totalPopulationSize;
    double definedPositives;
    double definedNegatives;
    double populationMean;
    KBestSGSet result;

    private static List<? extends List<SGSelector>> computeCombinations(ArrayList<SGSelector> prefix, ArrayList<SGSelector> selectors, int maxSize, ArrayList<ArrayList<SGSelector>> result, List<SGSelector> conditionedSelectors) {
        result.add(prefix);
        if (prefix.size() == maxSize) {
            return result;
        }
        ArrayList newRemainingSelectors = (ArrayList)selectors.clone();
        int i = 0;
        while (i < selectors.size()) {
            ArrayList newSelectors = (ArrayList)prefix.clone();
            SGSelector curSel = selectors.get(i);
            if (curSel instanceof NegatedSGSelector || !SDMap.isAttributeContainedInSelectorSet(curSel.getAttribute(), prefix) && !SDMap.isAttributeContainedInSelectorSet(curSel.getAttribute(), conditionedSelectors)) {
                newSelectors.add(curSel);
                newRemainingSelectors.remove(curSel);
                SDMap.computeCombinations(newSelectors, newRemainingSelectors, maxSize, result, conditionedSelectors);
            }
            ++i;
        }
        return result;
    }

    private static List<? extends List<SGSelector>> computeCombinations(ArrayList<SGSelector> selectors, int maxSize, List<SGSelector> conditionedSelectors) {
        return SDMap.computeCombinations(new ArrayList<SGSelector>(), selectors, maxSize, new ArrayList<ArrayList<SGSelector>>(), conditionedSelectors);
    }

    private static boolean isAttributeContainedInSelectorSet(Attribute attribute, List<SGSelector> selectors) {
        for (SGSelector sel : selectors) {
            if (sel.getAttribute() != attribute) continue;
            return true;
        }
        return false;
    }

    private MissingAdjustment accumulateMissingAdjustment(FPTree missingTree, Collection<SGSelector> missingSelectors) {
        MissingAdjustment f = new MissingAdjustment();
        for (SGSelector s : missingSelectors) {
            FPNode n = missingTree.getFPNodeWithSameAttributeAsSelector(s);
            if (n == null) continue;
            f.posUndefined = (int)((double)f.posUndefined + n.tp);
            f.negUndefined = (int)((double)f.negUndefined + n.getFP());
        }
        ArrayList<SGSelector> missingSelectorsToTestAsStart = new ArrayList<SGSelector>(missingSelectors);
        FPNode start = missingTree.findMostUnfrequentFPNode(missingSelectors);
        if (start != null) {
            missingSelectorsToTestAsStart.remove(start.sel);
            this.subtractPrefixPathsRecursively(missingTree, missingSelectorsToTestAsStart, missingSelectors, start, f);
        }
        return f;
    }

    private MissingAdjustment calculateMissingAdjustment(FPTree missingTree, List refSelectors) {
        if (missingTree.root.children.isEmpty()) {
            return MissingAdjustment.EMPTY_MISSING_ADJUSTMENT;
        }
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (SGSelector sel : refSelectors) {
            attributes.add(sel.getAttribute());
        }
        if (!missingTree.containsAnyAttribute(attributes)) {
            return MissingAdjustment.EMPTY_MISSING_ADJUSTMENT;
        }
        Collection<SGSelector> missingSelectors = this.createMissingSelectorSet(attributes);
        return this.accumulateMissingAdjustment(missingTree, missingSelectors);
    }

    protected void convertSGDescription(SG sg) {
        SGDescription sgd = sg.getSGDescription();
        ArrayList<SGSelector> selectors = new ArrayList<SGSelector>();
        for (SGSelector sel : sgd) {
            if (sel instanceof FastSelector) {
                selectors.add(new DefaultSGSelector(sel.getAttribute(), ((FastSelector)sel).getValues()));
                continue;
            }
            selectors.add(sel);
        }
        SGDescription converted = new SGDescription();
        converted.addAll(selectors);
        sg.setSGDescription(converted);
    }

    public final void convertSGDescriptions(SGSet result) {
        for (SG sg : result) {
            this.convertSGDescription(sg);
        }
    }

    private Collection<SGSelector> createMissingSelectorSet(Collection attributes) {
        HashSet<SGSelector> selectors = new HashSet<SGSelector>();
        for (Attribute att : attributes) {
            Boolean b;
            Boolean bl = b = this.getOptions() == null ? null : Boolean.valueOf(this.getOptions().getBooleanAttributeOption(att, Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE));
            if (b == null || !b.booleanValue()) continue;
            SDMapMissingSelector sel = new SDMapMissingSelector(att, Value.missingValue(att));
            selectors.add(sel);
        }
        return selectors;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void growAndTestPatterns(FPTree tree, FPTree missingTree, SGDescription initialSGD) {
        if (this.getMethodStats() != null) {
            this.getMethodStats().increaseNodeCounter();
        }
        if (this.aborted) {
            return;
        }
        if (tree.root.children.isEmpty()) {
            return;
        }
        if (tree.treeHasSinglePath()) {
            this.testPatternsForSinglePath(tree, missingTree, initialSGD, Collections.EMPTY_LIST);
        } else {
            SG sg;
            HashMap<FPNode, SG> levelOneSubgroups = new HashMap<FPNode, SG>();
            ArrayList<FPNode> frequentNodes = new ArrayList<FPNode>(tree.frequentHeaderNodes);
            for (FPNode headerNode : frequentNodes) {
                SGSelector conditioningSelector = headerNode.sel;
                ArrayList<SGSelector> newSelectors = new ArrayList<SGSelector>();
                newSelectors.add(conditioningSelector);
                sg = new SG(this.getPopulation(), this.target);
                double tp = headerNode.tp;
                double n = headerNode.n;
                MissingAdjustment f = this.calculateMissingAdjustment(missingTree, newSelectors);
                if (this.target.isBoolean()) {
                    SGStatisticsBuilder.createSGStatistics(sg, tp, n - tp, this.definedPositives - (double)f.posUndefined, this.definedNegatives - (double)f.negUndefined, this.totalPopulationSize, newSelectors.size(), this.getOptions());
                } else {
                    SGStatisticsBuilder.createSGStatisticsNumeric(sg, tp, this.populationMean, n, this.totalPopulationSize);
                }
                sg.updateQuality(this.task.getQualityFunction());
                levelOneSubgroups.put(headerNode, sg);
                if (!this.result.isInKBestQualityRange(sg.getQuality())) continue;
                SGDescription newSGD = initialSGD.clone();
                newSGD.addAll(newSelectors);
                sg.setSGDescription(newSGD);
                if (this.task.isSuppressStrictlyIrrelevantSubgroups() && SGSets.isSGStrictlyIrrelevant(sg, this.result)) continue;
                this.addSubgroupToSGSet(this.result, sg);
            }
            ArrayList<Map.Entry<FPNode, SG>> sortedLevelOneSubgroups = new ArrayList<Map.Entry<FPNode, SG>>(levelOneSubgroups.entrySet());
            this.sortByOptimisticEstimateDescending(sortedLevelOneSubgroups);
            for (Map.Entry entry : sortedLevelOneSubgroups) {
                FPTree conditionalFPTree;
                FPNode headerNode = (FPNode)entry.getKey();
                sg = (SG)entry.getValue();
                SGStatistics statistics = sg.getStatistics();
                if (!this.target.isNumeric() && !this.result.isInKBestQualityRange(this.getOptimisticEstimate(statistics)) || (conditionalFPTree = tree.buildConditionalFPTree(headerNode)) == null) continue;
                this.growAndTestPatternsRecursive(conditionalFPTree, missingTree, initialSGD, Arrays.asList(headerNode.sel), 1);
            }
        }
    }

    private void growAndTestPatternsRecursive(FPTree tree, FPTree missingTree, SGDescription initialSGdescription, List<SGSelector> conditionedSelectors, int depth) {
        if (this.aborted) {
            return;
        }
        if (tree.root.children.isEmpty() || depth >= this.task.getMaxSGDSize()) {
            return;
        }
        if (tree.treeHasSinglePath()) {
            this.testPatternsForSinglePath(tree, missingTree, initialSGdescription, conditionedSelectors);
        } else {
            HashMap<FPNode, SG> refinements = new HashMap<FPNode, SG>();
            ArrayList<FPNode> frequentNodes = new ArrayList<FPNode>(tree.frequentHeaderNodes);
            for (FPNode headerNode : frequentNodes) {
                boolean allowsForMultipleSelectorsPerAttribute;
                SGSelector conditioningSelector = headerNode.sel;
                boolean bl = allowsForMultipleSelectorsPerAttribute = conditioningSelector instanceof NegatedSGSelector || conditioningSelector instanceof NumericSelector;
                if (!allowsForMultipleSelectorsPerAttribute && SDMap.isAttributeContainedInSelectorSet(conditioningSelector.getAttribute(), conditionedSelectors)) continue;
                ArrayList<SGSelector> newSelectors = new ArrayList<SGSelector>();
                newSelectors.addAll(conditionedSelectors);
                newSelectors.add(conditioningSelector);
                SG sg = new SG(this.getPopulation(), this.target);
                double tp = headerNode.tp;
                double n = headerNode.n;
                MissingAdjustment f = this.calculateMissingAdjustment(missingTree, newSelectors);
                if (this.target.isBoolean()) {
                    SGStatisticsBuilder.createSGStatistics(sg, tp, n - tp, this.definedPositives - (double)f.posUndefined, this.definedNegatives - (double)f.negUndefined, this.totalPopulationSize, newSelectors.size(), this.getOptions());
                } else {
                    SGStatisticsBuilder.createSGStatisticsNumeric(sg, tp, this.populationMean, n, this.totalPopulationSize);
                }
                sg.updateQuality(this.task.getQualityFunction());
                refinements.put(headerNode, sg);
                if (!this.result.isInKBestQualityRange(sg.getQuality())) continue;
                SGDescription newSGD = initialSGdescription.clone();
                newSGD.addAll(newSelectors);
                sg.setSGDescription(newSGD);
                if (this.task.isSuppressStrictlyIrrelevantSubgroups() && SGSets.isSGStrictlyIrrelevant(sg, this.result)) continue;
                this.addSubgroupToSGSet(this.result, sg);
            }
            ArrayList<Map.Entry<FPNode, SG>> sortedRefinements = new ArrayList<Map.Entry<FPNode, SG>>(refinements.entrySet());
            this.sortByOptimisticEstimateDescending(sortedRefinements);
            for (Map.Entry entry : sortedRefinements) {
                FPNode headerNode = (FPNode)entry.getKey();
                SG sg = (SG)entry.getValue();
                SGStatistics statistics = sg.getStatistics();
                if (!this.target.isNumeric() && !this.result.isInKBestQualityRange(this.getOptimisticEstimate(statistics))) continue;
                ArrayList<SGSelector> newSelectors = new ArrayList<SGSelector>();
                newSelectors.addAll(conditionedSelectors);
                newSelectors.add(headerNode.sel);
                FPTree conditionalFPTree = tree.buildConditionalFPTree(headerNode);
                if (conditionalFPTree == null) continue;
                this.growAndTestPatternsRecursive(conditionalFPTree, missingTree, initialSGdescription, newSelectors, depth + 1);
            }
        }
    }

    private void initDefaultTargetShareAndPopulationSize(SG initialSubgroup) {
        SGStatistics stats = initialSubgroup.getStatistics();
        if (this.target instanceof BooleanTarget) {
            SGStatisticsBinary statsBin = (SGStatisticsBinary)stats;
            this.definedPositives = statsBin.getPositives();
            this.definedNegatives = statsBin.getNegatives();
            this.populationMean = statsBin.getP0();
        } else if (this.target instanceof NumericTarget) {
            SGStatisticsNumeric statsNumeric = (SGStatisticsNumeric)stats;
            this.definedPositives = statsNumeric.getPopulationMean() * statsNumeric.getDefinedPopulationCount();
            this.definedNegatives = statsNumeric.getDefinedPopulationCount() - this.definedPositives;
            this.populationMean = statsNumeric.getPopulationMean();
        }
        this.totalPopulationSize = stats.getDefinedPopulationCount();
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return true;
    }

    @Override
    protected SGSet search(final SG initialSubgroup) {
        this.target = initialSubgroup.getTarget();
        this.initDefaultTargetShareAndPopulationSize(initialSubgroup);
        boolean allowPrune = true;
        this.result = SGSets.createKBestSGSet(this.task.getMaxSGCount(), this.task.getMinQualityLimit());
        FPTree tree = new FPTree(this.getSelectorSet(initialSubgroup, this.target), new DataRecordIteration(initialSubgroup.subgroupInstanceIterator()), allowPrune, this);
        DataRecordIteration missingInstancesIteration = new DataRecordIteration(new FilteringDataRecordIterator(this.getPopulation().instanceIterator(), new IncludingDataRecordFilter(){

            @Override
            public boolean isIncluded(DataRecord instance) {
                return initialSubgroup.getStatistics().isInstanceDefinedForSubgroupVars(instance);
            }
        }));
        FPTree missingTree = new FPTree(this.createMissingSelectorSet(tree.extractFrequentAttributes()), missingInstancesIteration, false, this);
        SGDescription initialSGDescription = initialSubgroup.getSGDescription();
        this.growAndTestPatterns(tree, missingTree, initialSGDescription);
        this.convertSGDescriptions(this.result);
        if (this.target instanceof NumericTarget) {
            for (SG sg : this.result) {
                sg.createStatistics(this.getOptions());
            }
        }
        return this.result;
    }

    protected void sortByOptimisticEstimateDescending(List<Map.Entry<FPNode, SG>> refinements) {
        Collections.sort(refinements, new Comparator<Map.Entry<FPNode, SG>>(){

            @Override
            public int compare(Map.Entry<FPNode, SG> e1, Map.Entry<FPNode, SG> e2) {
                double estimate1 = SDMap.this.getOptimisticEstimate(e1.getValue().getStatistics());
                double estimate2 = SDMap.this.getOptimisticEstimate(e2.getValue().getStatistics());
                return -Double.compare(estimate1, estimate2);
            }
        });
    }

    private void subtractPrefixPathsRecursively(FPTree missingTree, Collection missingSelectorsToTestAsStart, Collection missingSelectors, FPNode start, MissingAdjustment f) {
        List<? extends FPNode.FPTreePath> paths = start.getAllPrefixPaths();
        for (FPNode.FPTreePath fPTreePath : paths) {
            if (!fPTreePath.containsAnySelectors(missingSelectors)) continue;
            f.posUndefined = (int)((double)f.posUndefined - fPTreePath.tp);
            f.negUndefined = (int)((double)f.negUndefined - fPTreePath.getFP());
        }
        start = missingTree.findMostUnfrequentFPNode(missingSelectorsToTestAsStart);
        if (start != null) {
            missingSelectorsToTestAsStart.remove(start.sel);
            this.subtractPrefixPathsRecursively(missingTree, missingSelectorsToTestAsStart, missingSelectors, start, f);
        }
    }

    private void testPatternsForSinglePath(FPTree tree, FPTree missingTree, SGDescription sgd, List conditionedSelectors) {
        ArrayList<SGSelector> selectors = new ArrayList<SGSelector>();
        FPNode.FPTreeNode node = tree.root;
        while (!node.children.isEmpty()) {
            node = node.children.get(0);
            selectors.add(node.sel);
        }
        List<? extends List<SGSelector>> powerSetOfSelectors = SDMap.computeCombinations(selectors, this.task.getMaxSGDSize() - conditionedSelectors.size(), conditionedSelectors);
        for (List<SGSelector> list : powerSetOfSelectors) {
            if (list.isEmpty()) continue;
            ArrayList<SGSelector> newSelectors = new ArrayList<SGSelector>();
            newSelectors.addAll(conditionedSelectors);
            newSelectors.addAll(list);
            if (newSelectors.size() > this.task.getMaxSGDSize()) continue;
            SG sg = new SG(this.getPopulation(), this.target);
            FPNode mostUnfrequentNodeInCombination = tree.findMostUnfrequentFPNode(list);
            double tp = mostUnfrequentNodeInCombination.tp;
            double n = mostUnfrequentNodeInCombination.n;
            MissingAdjustment f = this.calculateMissingAdjustment(missingTree, newSelectors);
            if (this.target.isBoolean()) {
                SGStatisticsBuilder.createSGStatistics(sg, tp, n - tp, this.definedPositives - (double)f.posUndefined, this.definedNegatives - (double)f.negUndefined, this.totalPopulationSize, newSelectors.size(), this.getOptions());
            } else {
                SGStatisticsBuilder.createSGStatisticsNumeric(sg, tp, this.populationMean, n, this.totalPopulationSize);
            }
            sg.updateQuality(this.task.getQualityFunction());
            if (!this.result.isInKBestQualityRange(sg.getQuality())) continue;
            SGDescription newSGD = sgd.clone();
            newSGD.addAll(newSelectors);
            sg.setSGDescription(newSGD);
            if (this.task.isSuppressStrictlyIrrelevantSubgroups() && SGSets.isSGStrictlyIrrelevant(sg, this.result)) continue;
            this.addSubgroupToSGSet(this.result, sg);
        }
    }

    private static class MissingAdjustment {
        public int posUndefined;
        public int negUndefined;
        public static MissingAdjustment EMPTY_MISSING_ADJUSTMENT = new MissingAdjustment();

        private MissingAdjustment() {
        }
    }

    private static class SDMapMissingSelector
    extends DefaultSGSelector {
        private int cachedHashCode = 0;

        public SDMapMissingSelector(Attribute a, Set values) {
            super(a, values);
        }

        public SDMapMissingSelector(Attribute a, Value v) {
            super(a, v);
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            SDMapMissingSelector miss = (SDMapMissingSelector)other;
            return this.getAttribute() == miss.getAttribute();
        }

        @Override
        public int hashCode() {
            if (this.cachedHashCode == 0) {
                this.cachedHashCode = super.hashCode();
            }
            return this.cachedHashCode;
        }
    }
}

