/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.math.distributions.NormalDistribution;
import java.util.ArrayList;

public class DirichletProcessPriorLogger
implements Loggable {
    private Parameter precisionParameter;
    private Parameter categoriesParameter;
    private CompoundParameter uniquelyRealizedParameters;
    private int uniqueRealizationCount;
    private int realizationCount;
    private double[] categoryProbabilities;
    private int newCategoryIndex;
    private double meanForCategory;
    private double newX;

    public DirichletProcessPriorLogger(Parameter parameter, Parameter parameter2, CompoundParameter compoundParameter) {
        this.precisionParameter = parameter;
        this.uniquelyRealizedParameters = compoundParameter;
        this.categoriesParameter = parameter2;
        this.uniqueRealizationCount = compoundParameter.getDimension();
        this.realizationCount = parameter2.getDimension();
    }

    private double[] getCategoryProbs() {
        int n;
        double[] dArray = new double[this.uniqueRealizationCount];
        for (n = 0; n < this.realizationCount; ++n) {
            int n2 = (int)this.categoriesParameter.getParameterValue(n);
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (n = 0; n < this.uniqueRealizationCount; ++n) {
            dArray[n] = dArray[n] / (double)this.realizationCount;
        }
        return dArray;
    }

    @Override
    public LogColumn[] getColumns() {
        ArrayList<NumberColumn> arrayList = new ArrayList<NumberColumn>();
        arrayList.add(new NewLogger("x.new"));
        arrayList.add(new NewCategoryLogger("category.new"));
        arrayList.add(new NewMeanLogger("mean.new"));
        for (int i = 0; i < this.uniquelyRealizedParameters.getDimension(); ++i) {
            arrayList.add(new ProbabilitiesLogger("pi.", i));
        }
        LogColumn[] logColumnArray = new LogColumn[arrayList.size()];
        return arrayList.toArray(logColumnArray);
    }

    private void getNew() {
        this.categoryProbabilities = this.getCategoryProbs();
        this.newCategoryIndex = MathUtils.randomChoicePDF(this.categoryProbabilities);
        this.meanForCategory = this.uniquelyRealizedParameters.getParameterValue(this.newCategoryIndex);
        double d = this.precisionParameter.getParameterValue(0);
        NormalDistribution normalDistribution = new NormalDistribution(this.meanForCategory, d);
        this.newX = (Double)normalDistribution.nextRandom();
    }

    private class NewLogger
    extends NumberColumn {
        public NewLogger(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            DirichletProcessPriorLogger.this.getNew();
            return DirichletProcessPriorLogger.this.newX;
        }
    }

    private class NewCategoryLogger
    extends NumberColumn {
        public NewCategoryLogger(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return DirichletProcessPriorLogger.this.newCategoryIndex;
        }
    }

    private class NewMeanLogger
    extends NumberColumn {
        public NewMeanLogger(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return DirichletProcessPriorLogger.this.meanForCategory;
        }
    }

    private class ProbabilitiesLogger
    extends NumberColumn {
        private int i;

        public ProbabilitiesLogger(String string, int n) {
            super(string + n);
            this.i = n;
        }

        @Override
        public double getDoubleValue() {
            return DirichletProcessPriorLogger.this.categoryProbabilities[this.i];
        }
    }
}

