/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.util.Units;
import dr.evomodel.coalescent.PopulationSizeFunction;
import dr.evomodel.coalescent.PopulationSizeModel;
import dr.evomodelxml.coalescent.demographicmodel.ExponentialGrowthModelParser;
import dr.inference.model.Parameter;

public class ExponentialPopulationSizeModel
extends PopulationSizeModel {
    private final Parameter rateParameter;
    private PopulationSizeFunction populationSizeFunction = null;

    public ExponentialPopulationSizeModel(Parameter parameter, Parameter parameter2, Units.Type type) {
        this(ExponentialGrowthModelParser.EXPONENTIAL_GROWTH_MODEL, parameter, parameter2, type);
    }

    public ExponentialPopulationSizeModel(String string, Parameter parameter, Parameter parameter2, Units.Type type) {
        super(string, parameter, type);
        this.rateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
    }

    public double getGrowthRate() {
        return this.rateParameter.getParameterValue(0);
    }

    @Override
    public PopulationSizeFunction getPopulationSizeFunction() {
        if (this.populationSizeFunction == null) {
            this.populationSizeFunction = new PopulationSizeFunction(){

                @Override
                public double getLogDemographic(double d) {
                    return ExponentialPopulationSizeModel.this.getLogN0() + -d * ExponentialPopulationSizeModel.this.getGrowthRate();
                }

                @Override
                public double getIntegral(double d, double d2) {
                    double d3 = ExponentialPopulationSizeModel.this.getGrowthRate();
                    if (d3 == 0.0) {
                        return (d2 - d) / ExponentialPopulationSizeModel.this.getN0();
                    }
                    return (Math.exp(d2 * d3) - Math.exp(d * d3)) / ExponentialPopulationSizeModel.this.getN0() / d3;
                }

                @Override
                public Units.Type getUnits() {
                    return ExponentialPopulationSizeModel.this.getUnits();
                }

                @Override
                public void setUnits(Units.Type type) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.populationSizeFunction;
    }
}

