/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.util.Units;
import dr.evomodel.epidemiology.LogisticGrowthN0Model;
import dr.evoxml.util.XMLUnits;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class LogisticGrowthN0ModelParser
extends AbstractXMLObjectParser {
    public static String POPULATION_SIZE = "populationSize";
    public static String LOGISTIC_GROWTH_MODEL = "logisticGrowthN0";
    public static String GROWTH_RATE = "growthRate";
    public static String DOUBLING_TIME = "doublingTime";
    public static String TIME_50 = "t50";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{XMLUnits.SYNTAX_RULES[0], new ElementRule(POPULATION_SIZE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the present day population size."), new XORRule(new ElementRule(GROWTH_RATE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the rate of growth during the exponential phase. See exponentialGrowth for details."), new ElementRule(DOUBLING_TIME, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the doubling time at peak growth rate.")), new ElementRule(TIME_50, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the time in the past (or future) when the population had (or will have) half of the carrying capacity (maximum population size). It is a positive number if half the carrying capacity was attained in the past or a negative number if it will be attained in the future.")};

    @Override
    public String getParserName() {
        return LOGISTIC_GROWTH_MODEL;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
        XMLObject xMLObject2 = xMLObject.getChild(POPULATION_SIZE);
        Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
        boolean bl = true;
        Parameter parameter2 = null;
        if (xMLObject.getChild(GROWTH_RATE) != null) {
            xMLObject2 = xMLObject.getChild(GROWTH_RATE);
            parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
        } else {
            xMLObject2 = xMLObject.getChild(DOUBLING_TIME);
            parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            bl = false;
        }
        xMLObject2 = xMLObject.getChild(TIME_50);
        Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
        return new LogisticGrowthN0Model(parameter, parameter2, parameter3, type, bl);
    }

    @Override
    public String getParserDescription() {
        return "Logistic growth demographic model.";
    }

    @Override
    public Class getReturnType() {
        return LogisticGrowthN0Model.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

