/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.LogAdditiveCtmcRateProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LogRateSubstitutionModel
extends ComplexSubstitutionModel {
    private final LogAdditiveCtmcRateProvider lrm;
    private final double[] testProbabilities;

    public LogRateSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, LogAdditiveCtmcRateProvider logAdditiveCtmcRateProvider) {
        super(string, dataType, frequencyModel, (Parameter)null);
        this.lrm = logAdditiveCtmcRateProvider;
        this.addModel(logAdditiveCtmcRateProvider);
        this.testProbabilities = new double[this.stateCount * this.stateCount];
    }

    @Override
    public LogAdditiveCtmcRateProvider getRateProvider() {
        return this.lrm;
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        System.arraycopy(this.lrm.getLogRateParameter().getParameterValues(), 0, dArray, 0, dArray.length);
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this, this.lrm));
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.lrm) {
            this.updateMatrix = true;
            this.fireModelChanged();
        } else {
            super.handleModelChangedEvent(model, object, n);
        }
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.lrm.getColumns().length + 2];
        int n = 0;
        LogColumn[] logColumnArray2 = this.lrm.getColumns();
        int n2 = logColumnArray2.length;
        for (int i = 0; i < n2; ++i) {
            LogColumn logColumn;
            logColumnArray[n] = logColumn = logColumnArray2[i];
            ++n;
        }
        logColumnArray[n++] = new ComplexSubstitutionModel.LikelihoodColumn(this.getId() + ".L");
        logColumnArray[n] = new ComplexSubstitutionModel.NormalizationColumn(this.getId() + ".Norm");
        return logColumnArray;
    }

    @Override
    public double getLogLikelihood() {
        double d = super.getLogLikelihood();
        if (d == 0.0 && BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.testProbabilities, this)) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public String getDescription() {
        return "Log Rate Substitution Model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2014_UNIFYING);
    }
}

