/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class SpaceTime {
    double[] space;
    double time;

    public SpaceTime(SpaceTime spaceTime) {
        this.space = new double[spaceTime.space.length];
        System.arraycopy(spaceTime.space, 0, this.space, 0, spaceTime.space.length);
        this.time = spaceTime.time;
    }

    public SpaceTime(double d, Point2D point2D) {
        this.time = d;
        this.space = new double[]{point2D.getX(), point2D.getY()};
    }

    public SpaceTime(double d, double[] dArray) {
        this.time = d;
        this.space = dArray;
    }

    public double[] getX() {
        return this.space;
    }

    public double getX(int n) {
        return this.space[n];
    }

    public double getTime() {
        return this.time;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.time);
        for (double d : this.space) {
            stringBuilder.append("\t").append(d);
        }
        return stringBuilder.toString();
    }

    public static void paintDot(SpaceTime spaceTime, double d, AffineTransform affineTransform, Graphics2D graphics2D) {
        Point2D.Double double_ = new Point2D.Double(spaceTime.getX(0), spaceTime.getX(1));
        Point2D.Double double_2 = new Point2D.Double();
        affineTransform.transform(double_, double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(((Point2D)double_2).getX() - d, ((Point2D)double_2).getY() - d, 2.0 * d, 2.0 * d);
        graphics2D.fill(double_3);
    }
}

