/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModel;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.GammaFunction;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MultivariatePolyaDistributionLikelihood
extends AbstractModel
implements Likelihood {
    protected Parameter frequencies;
    protected Parameter dispersion;
    protected Parameter alphas;
    protected boolean usingAlphas;
    protected boolean isAlphasKnown;
    protected MatrixParameter data;
    protected double fixedNorm;
    protected double variableNorm;
    protected double storedFixedNorm;
    protected double storedVariableNorm;
    protected double logLikelihood;
    protected double storedLogLikelihood;
    protected boolean isLogLikelihoodKnown;
    protected boolean isFixedNormKnown;
    protected boolean isVariableNormKnown;
    protected double[] rowSums;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)}, false), new XORRule(new ElementRule("alpha", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, false), new ElementRule("frequencies", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, false)), new ElementRule("dispersion", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true)};

        @Override
        public String getParserName() {
            return MultivariatePolyaDistributionLikelihood.MVPLIKE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter;
            if (!xMLObject.hasChildNamed(MultivariatePolyaDistributionLikelihood.DATA)) {
                throw new XMLParseException("Missing data element!");
            }
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getChild(MultivariatePolyaDistributionLikelihood.DATA).getChild(MatrixParameter.class);
            if (xMLObject.hasChildNamed(MultivariatePolyaDistributionLikelihood.RATES)) {
                parameter = (Parameter)xMLObject.getChild(MultivariatePolyaDistributionLikelihood.RATES).getChild(Parameter.class);
                if (parameter.getDimension() != matrixParameter.getColumnDimension()) {
                    throw new XMLParseException("The number of data columns must match the dimension of alpha parameter (" + matrixParameter.getColumnDimension() + " != " + parameter.getDimension() + "!");
                }
            } else {
                if (xMLObject.hasChildNamed(MultivariatePolyaDistributionLikelihood.FREQ)) {
                    Parameter parameter2 = (Parameter)xMLObject.getChild(MultivariatePolyaDistributionLikelihood.FREQ).getChild(Parameter.class);
                    if (!xMLObject.hasChildNamed(MultivariatePolyaDistributionLikelihood.DISPERSION)) {
                        throw new XMLParseException("dispersion element has to be specified when using frequencies parametrization");
                    }
                    Parameter parameter3 = (Parameter)xMLObject.getChild(MultivariatePolyaDistributionLikelihood.DISPERSION).getChild(Parameter.class);
                    if (parameter3.getDimension() != 1) {
                        throw new XMLParseException("Dispersion parameter must be of dimmension exactly 1!");
                    }
                    if (parameter2.getDimension() != matrixParameter.getColumnDimension()) {
                        throw new XMLParseException("The number of data columns must match the dimension of frequencies parameter (" + matrixParameter.getColumnDimension() + " != " + parameter2.getDimension() + "!");
                    }
                    return new MultivariatePolyaDistributionLikelihood(MultivariatePolyaDistributionLikelihood.MVPLIKE, matrixParameter, parameter2, parameter3);
                }
                throw new XMLParseException("Either frequencies or alphaelement has to be specified!");
            }
            return new MultivariatePolyaDistributionLikelihood(MultivariatePolyaDistributionLikelihood.MVPLIKE, matrixParameter, parameter);
        }

        @Override
        public String getParserDescription() {
            return "A matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MatrixParameter.class;
        }
    };
    public static final String MVPLIKE = "mvPolyaLikelihood";
    public static final String DATA = "data";
    public static final String DISPERSION = "dispersion";
    public static final String FREQ = "frequencies";
    public static final String RATES = "alpha";

    public MultivariatePolyaDistributionLikelihood(String string, MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2) {
        super(string);
        this.frequencies = parameter;
        this.dispersion = parameter2;
        this.alphas = new Parameter.Default(parameter.getDimension());
        this.computeAlphas();
        this.data = matrixParameter;
        this.isFixedNormKnown = false;
        this.isVariableNormKnown = false;
        this.addVariable(this.frequencies);
        this.addVariable(this.dispersion);
        this.addVariable(this.data);
        if (this.alphas.getDimension() != matrixParameter.getColumnDimension()) {
            System.err.println("Dimensions of the frequency vector and number of columns do not match!");
        }
    }

    public MultivariatePolyaDistributionLikelihood(String string, MatrixParameter matrixParameter, Parameter parameter) {
        super(string);
        this.alphas = parameter;
        this.isAlphasKnown = true;
        this.usingAlphas = true;
        this.frequencies = new Parameter.Default(parameter.getDimension());
        this.dispersion = new Parameter.Default(1);
        this.data = matrixParameter;
        this.isFixedNormKnown = false;
        this.isVariableNormKnown = false;
        this.addVariable(this.alphas);
        this.addVariable(this.data);
        if (this.alphas.getDimension() != matrixParameter.getColumnDimension()) {
            System.err.println("Dimensions of the frequency vector and number of columns do not match!");
        }
    }

    protected void computeAlphas() {
        double d = this.dispersion.getParameterValue(0);
        double[] dArray = this.frequencies.getParameterValues();
        for (int i = 0; i < this.alphas.getDimension(); ++i) {
            this.alphas.setParameterValueQuietly(i, d * dArray[i]);
        }
        this.alphas.setParameterValueNotifyChangedAll(0, this.alphas.getParameterValue(0));
        this.isAlphasKnown = true;
    }

    public MultivariatePolyaDistributionLikelihood(String string) {
        super(string);
    }

    public double calculateLogLikelihood() {
        int n;
        if (!this.isAlphasKnown) {
            this.computeAlphas();
        }
        if (!this.isFixedNormKnown) {
            this.computeFixedNorm();
        }
        if (!this.isVariableNormKnown) {
            this.computeVariableNorm();
        }
        double d = this.fixedNorm + this.variableNorm;
        double d2 = 0.0;
        double[] dArray = this.alphas.getParameterValues();
        for (n = 0; n < this.alphas.getDimension(); ++n) {
            d2 += dArray[n];
        }
        for (n = 0; n < this.data.getRowDimension(); ++n) {
            for (int i = 0; i < this.data.getColumnDimension(); ++i) {
                d += GammaFunction.lnGamma(this.data.getParameterValue(n, i) + dArray[i]);
            }
            d -= GammaFunction.lnGamma(this.rowSums[n] + d2);
        }
        return d;
    }

    protected void computeFixedNorm() {
        int n;
        int n2;
        this.rowSums = new double[this.data.getRowDimension()];
        for (n2 = 0; n2 < this.data.getRowDimension(); ++n2) {
            this.rowSums[n2] = 0.0;
            for (n = 0; n < this.data.getColumnDimension(); ++n) {
                int n3 = n2;
                this.rowSums[n3] = this.rowSums[n3] + this.data.getParameterValue(n2, n);
            }
        }
        this.fixedNorm = 0.0;
        for (n2 = 0; n2 < this.data.getRowDimension(); ++n2) {
            for (n = 0; n < this.data.getColumnDimension(); ++n) {
                this.fixedNorm -= GammaFunction.lnGamma(this.data.getParameterValue(n2, n) + 1.0);
            }
            this.fixedNorm += GammaFunction.lnGamma(this.rowSums[n2] + 1.0);
        }
        this.isFixedNormKnown = true;
    }

    protected void computeVariableNorm() {
        int n;
        double d = 0.0;
        double[] dArray = this.alphas.getParameterValues();
        for (n = 0; n < this.alphas.getDimension(); ++n) {
            d += dArray[n];
        }
        this.variableNorm = GammaFunction.lnGamma(d);
        for (n = 0; n < this.alphas.getDimension(); ++n) {
            this.variableNorm -= GammaFunction.lnGamma(dArray[n]);
        }
        this.variableNorm *= (double)this.data.getRowDimension();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable.getVariableName().equals(this.frequencies.getVariableName()) || variable.getVariableName().equals(this.dispersion.getVariableName())) {
            this.isAlphasKnown = false;
            this.isVariableNormKnown = false;
        } else if (variable.getVariableName().equals(this.data.getVariableName())) {
            this.isFixedNormKnown = false;
        } else if (variable.getVariableName().equals(this.alphas.getVariableName())) {
            this.isVariableNormKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedVariableNorm = this.variableNorm;
        this.storedFixedNorm = this.fixedNorm;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.variableNorm = this.storedVariableNorm;
        this.fixedNorm = this.storedFixedNorm;
        this.logLikelihood = this.storedLogLikelihood;
        if (!this.usingAlphas) {
            this.computeAlphas();
        }
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.isLogLikelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.isLogLikelihoodKnown = false;
        this.isVariableNormKnown = false;
        this.isFixedNormKnown = false;
    }

    @Override
    public String prettyName() {
        return "Multivariate Polya Distribution Likelihood";
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public void setUsed() {
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new NumberColumn(this.getId()){

            @Override
            public double getDoubleValue() {
                return MultivariatePolyaDistributionLikelihood.this.getLogLikelihood();
            }
        }};
    }
}

