/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.GGA;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.OutputFS;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Algorithms.Preprocess.Feature_Selection.Shared.Chromosome;
import keel.Algorithms.Preprocess.Feature_Selection.Shared.FSAlgorithm;
import org.core.Files;
import org.core.Randomize;

public class GGA
extends FSAlgorithm {
    private long seed;
    private double crossProb;
    private double mutationProb;
    private int popSize;
    private int evaluations;
    private int maxEvaluations;
    private double beta;
    private int k;
    private boolean elitism;
    private Chromosome ace;
    private Chromosome[] population;
    private Chromosome[] newPop;

    public GGA(String script) {
        this.readDataFiles(script);
        this.name = "FS-GGA";
        this.evaluations = 0;
        Chromosome.setData((double[][])this.trainData, (int[])this.trainOutput);
        Chromosome.setK((int)this.k);
        Chromosome.setNClasses((int)this.nClasses);
        Chromosome.setMutationProb((double)this.mutationProb);
        Chromosome.setBeta((double)this.beta);
        this.population = new Chromosome[this.popSize];
        this.newPop = new Chromosome[this.popSize];
        for (int i = 0; i < this.popSize; ++i) {
            this.population[i] = new Chromosome(this.inputAtt);
            this.population[i].evaluate();
        }
        Arrays.sort(this.population);
        if (this.elitism) {
            this.ace = new Chromosome(this.population[0].getGenes(), this.population[0].getFitness());
        }
        Randomize.setSeed(this.seed);
        this.setInitialTime();
    }

    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.seed = Long.parseLong(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.crossProb = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.mutationProb = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.popSize = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.maxEvaluations = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.beta = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.elitism = tokens.nextToken().substring(1).equalsIgnoreCase("Yes");
    }

    public void execute() {
        while (this.evaluations < this.maxEvaluations) {
            for (int i = 0; i < this.popSize; i += 2) {
                int candidate2;
                int candidate1 = Randomize.Randint(0, this.popSize - 1);
                while ((candidate2 = Randomize.Randint(0, this.popSize - 1)) == candidate1) {
                }
                int selected1 = this.population[candidate1].getFitness() > this.population[candidate2].getFitness() ? candidate1 : candidate2;
                candidate1 = Randomize.Randint(0, this.popSize - 1);
                while ((candidate2 = Randomize.Randint(0, this.popSize - 1)) == candidate1) {
                }
                int selected2 = this.population[candidate1].getFitness() > this.population[candidate2].getFitness() ? candidate1 : candidate2;
                if (Randomize.Rand() < this.crossProb) {
                    this.newPop[i] = new Chromosome(this.population[selected1].getGenes());
                    this.newPop[i + 1] = new Chromosome(this.newPop[i].crossPMX(this.population[selected2].getGenes()));
                } else {
                    this.newPop[i] = new Chromosome(this.population[selected1].getGenes(), this.population[selected1].getFitness());
                    this.newPop[i + 1] = new Chromosome(this.population[selected2].getGenes(), this.population[selected2].getFitness());
                }
                this.newPop[i].mutation();
                this.newPop[i + 1].mutation();
                if (!this.newPop[i].getValid()) {
                    this.newPop[i].evaluate();
                    ++this.evaluations;
                }
                if (this.newPop[i + 1].getValid()) continue;
                this.newPop[i + 1].evaluate();
                ++this.evaluations;
            }
            System.arraycopy(this.newPop, 0, this.population, 0, this.popSize);
            Arrays.sort(this.population);
            if (!this.elitism) continue;
            if (this.population[0].getFitness() > this.ace.getFitness()) {
                this.ace = new Chromosome(this.population[0].getGenes(), this.population[0].getFitness());
                continue;
            }
            this.population[this.popSize - 1] = new Chromosome(this.ace.getGenes(), this.ace.getFitness());
        }
        Arrays.sort(this.population);
        int[] featSelected = new int[this.inputAtt];
        featSelected = this.population[0].getGenes();
        System.out.println(this.name + " " + this.relation + " Train " + (double)(System.currentTimeMillis() - this.initialTime) / 1000.0 + "s");
        OutputFS.writeTrainOutput(this.outFile[0], this.trainReal, this.trainNominal, this.trainNulls, this.trainOutput, featSelected, this.inputs, this.output, this.inputAtt, this.relation);
        OutputFS.writeTestOutput(this.outFile[1], this.test, featSelected, this.inputs, this.output, this.inputAtt, this.relation);
        OutputIS.escribeSalidaAux(this.outFile[1] + ".txt", (double)(System.currentTimeMillis() - this.initialTime) / 1000.0, 1.0 - (double)this.population[0].getNGenes() / (double)this.trainData[0].length, this.relation);
    }
}

