/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.freitas;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.FilteredRecombinator;
import net.sourceforge.jclec.problem.classification.Classifier;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.IClassifier;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.freitas.FreitasEvaluator;
import net.sourceforge.jclec.problem.classification.freitas.FreitasSyntaxTreeSpecies;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.AbstractRandGenFactory;
import net.sourceforge.jclec.util.random.RanecuFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class FreitasAlgorithm
extends PopulationAlgorithm {
    private static final long serialVersionUID = -8711970425735016406L;
    protected ISelector parentsSelector;
    protected ISelector recombinatorSelector;
    protected FilteredRecombinator recombinator;
    protected IClassifier classifier = new Classifier();
    protected int classesNumber;
    private IDataset trainSet;
    private IDataset testSet;
    private IMetadata trainMetadata;
    private IMetadata testMetadata;
    private double copyProb;
    protected BettersSelector bettersSelector = new BettersSelector(this);

    public ISelector getParentsSelector() {
        return this.parentsSelector;
    }

    public void setParentsSelector(ISelector parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public FilteredRecombinator getRecombinator() {
        return this.recombinator;
    }

    public void setRecombinator(IRecombinator recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public int getClassesNumber() {
        return this.classesNumber;
    }

    public void setClassesNumber(int classesNumber) {
        this.classesNumber = classesNumber;
    }

    public IClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(IClassifier classifier) {
        this.classifier = classifier;
    }

    public double getCopyProb() {
        return this.copyProb;
    }

    public void setCopyProb(double copyProb) {
        this.copyProb = copyProb;
    }

    public IDataset getTrainSet() {
        return this.trainSet;
    }

    public void setTrainSet(IDataset train) {
        this.trainSet = train;
    }

    public IDataset getTestSet() {
        return this.testSet;
    }

    public void setTestSet(IDataset test) {
        this.testSet = test;
    }

    public IMetadata getTrainMetadata() {
        return this.trainMetadata;
    }

    public void setTrainMetadata(IMetadata train) {
        this.trainMetadata = train;
    }

    public IMetadata getTestMetadata() {
        return this.testMetadata;
    }

    public void setTestMetadata(IMetadata test) {
        this.testMetadata = test;
    }

    private void setRecombinationProb(double recProb) {
        this.recombinator.setRecProb(recProb);
    }

    private boolean checkClass(double class1, List<Double> classes) {
        int i = 0;
        while (i < classes.size()) {
            if (class1 == classes.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setDatasetSetting(Configuration settings) {
        try {
            String datasetClassname = settings.getString("dataset[@type]");
            Class<?> datasetClass = Class.forName(datasetClassname);
            this.setTrainSet((IDataset)datasetClass.newInstance());
            Configuration datasetSettings = settings.subset("dataset.train-data");
            this.getTrainSet().configure(datasetSettings);
            this.setTestSet((IDataset)datasetClass.newInstance());
            datasetSettings = settings.subset("dataset.test-data");
            this.getTestSet().configure(datasetSettings);
            this.getTrainSet().open();
            this.setTrainMetadata(this.getTrainSet().getMetadata());
            this.getTrainSet().loadInstances();
            this.getTrainSet().close();
            this.getTestSet().open();
            this.setTestMetadata(this.getTestSet().getMetadata());
            this.getTestSet().loadInstances();
            this.getTestSet().close();
            String attributeClass = settings.getString("dataset.attribute-class-name");
            if (attributeClass != null) {
                int attributeClassIndex = this.getTrainMetadata().getIndex(attributeClass);
                this.getTrainMetadata().setClassIndex(attributeClassIndex);
                this.getTestMetadata().setClassIndex(attributeClassIndex);
            } else {
                this.getTrainMetadata().setClassIndex(this.trainMetadata.numberOfAttributes() - 1);
                this.getTestMetadata().setClassIndex(this.testMetadata.numberOfAttributes() - 1);
            }
            CategoricalAttribute catAttribute = (CategoricalAttribute)this.getTrainMetadata().getAttribute(this.trainMetadata.getClassIndex());
            int classesN = catAttribute.getCategories().size();
            this.setClassesNumber(classesN);
            ((Classifier)this.classifier).setDefaultClass(0.0);
            ((FreitasSyntaxTreeSpecies)this.getSpecies()).setMetadata(this.getTrainMetadata());
            ((FreitasEvaluator)this.evaluator).setDataset(this.getTrainSet());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (DatasetException e) {
            e.printStackTrace();
        }
    }

    private void setParentsSelectorSetting(Configuration settings) {
        try {
            String parentsSelectorClassname = settings.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = settings.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
    }

    private void setRecombinatorSetting(Configuration settings) {
        try {
            String recombinatorClassname = settings.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = settings.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        double recProb = settings.getDouble("recombinator[@rec-prob]");
        this.setRecombinationProb(recProb);
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        this.setDatasetSetting(settings);
        int maxDerivSize = settings.getInt("max-deriv-size");
        ((FreitasSyntaxTreeSpecies)this.getSpecies()).setFreitasGrammar();
        ((FreitasSyntaxTreeSpecies)this.getSpecies()).setMaxDerivSize(maxDerivSize);
        RanecuFactory randGenFactory = new RanecuFactory();
        int seed = ((AbstractRandGenFactory)this.getRandGenFactory()).getSeed();
        randGenFactory.setSeed(seed);
        ((FreitasEvaluator)this.evaluator).setRandGen(randGenFactory.createRandGen());
        ((FreitasEvaluator)this.evaluator).setMaxDerivSize(maxDerivSize);
        this.setParentsSelectorSetting(settings);
        this.setRecombinatorSetting(settings);
        double copyProb = settings.getDouble("copy-prob", 0.1);
        this.setCopyProb(copyProb);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FreitasAlgorithm) {
            FreitasAlgorithm cother = (FreitasAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset, this.bset.size());
    }

    @Override
    protected void doGeneration() {
        this.cset = this.recombinator.recombine(this.pset);
        this.cset.addAll(this.recombinator.getSterile());
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        this.rset = this.bset;
    }

    @Override
    protected void doUpdate() {
        int numIndividuals = this.bset.size();
        for (IIndividual individual : this.bset) {
            if (!this.getRandGenFactory().createRandGen().coin(this.copyProb)) continue;
            this.cset.add(individual);
        }
        List<IIndividual> bests = this.bettersSelector.select(this.bset, this.bset.size());
        ArrayList<IClassificationRule> classificationRule = new ArrayList<IClassificationRule>();
        ArrayList<Double> classes = new ArrayList<Double>();
        this.bset = this.cset;
        if (this.bset.size() + this.classesNumber > numIndividuals) {
            this.bset = this.bettersSelector.select(this.cset, numIndividuals - this.classesNumber);
        }
        int i = 0;
        while (i < bests.size() && classes.size() != this.classesNumber) {
            Individual ind = (Individual)bests.get(i);
            if (this.checkClass(ind.getPhenotype().getConsequent(), classes)) {
                classificationRule.add(ind.getPhenotype());
                classes.add(ind.getPhenotype().getConsequent());
                this.bset.add(bests.get(i));
            }
            ++i;
        }
        ((Classifier)this.classifier).setClassificationRules(classificationRule);
        int currentNumber = this.bset.size();
        int contador = 0;
        if (currentNumber < numIndividuals) {
            int i2 = currentNumber;
            while (i2 < numIndividuals) {
                this.bset.add(bests.get(contador++));
                ++i2;
            }
        }
        this.rset = null;
        this.pset = null;
        this.cset = null;
    }
}

