/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.KStar;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import keel.Algorithms.Lazy_Learning.LazyAlgorithm;
import org.core.Files;
import org.core.Randomize;

public class KStar
extends LazyAlgorithm {
    int selectionMethod;
    double blendFactor;
    double[] trainDistances;
    double[] classProb;
    ArrayList<Hashtable<Double, Double>> scaleTable;
    private static final double EPSILON = 1.0E-5;
    private static final double ROOT_FINDER_ACCURACY = 0.01;
    private static final int ROOT_FINDER_MAX_ITER = 30;
    private static final int RANDOM = 1;
    private static final int FIXED = 2;

    public KStar(String script) {
        this.readDataFiles(script);
        this.name = "KStar";
        this.classProb = new double[this.nClasses];
        this.trainDistances = new double[this.trainData.length];
        this.scaleTable = new ArrayList();
        for (int i = 0; i < this.trainData.length; ++i) {
            this.scaleTable.add(new Hashtable());
        }
        Randomize.setSeed(this.seed);
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.seed = Long.parseLong(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.selectionMethod = tokens.nextToken().substring(1).equalsIgnoreCase("Random") ? 1 : 2;
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.blendFactor = Double.parseDouble(tokens.nextToken().substring(1));
    }

    @Override
    protected int evaluate(double[] example) {
        int i;
        int output = -1;
        for (i = 0; i < this.classProb.length; ++i) {
            this.classProb[i] = 0.0;
        }
        double probability = 0.0;
        for (i = 0; i < this.trainData.length; ++i) {
            probability = this.calcTransProb(i, example);
            int n = this.trainOutput[i];
            this.classProb[n] = this.classProb[n] + probability;
        }
        switch (this.selectionMethod) {
            case 1: {
                output = this.findRandomOutput(example);
                break;
            }
            case 2: {
                output = this.findFixedOutput(example);
            }
        }
        return output;
    }

    private int findFixedOutput(double[] example) {
        int output = -1;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.classProb.length; ++i) {
            if (!(max < this.classProb[i])) continue;
            max = this.classProb[i];
            output = i;
        }
        return output;
    }

    private int findRandomOutput(double[] example) {
        int i;
        int output = -1;
        boolean found = false;
        double sum = 0.0;
        for (i = 0; i < this.classProb.length; ++i) {
            sum += this.classProb[i];
        }
        double value = Randomize.Randdouble(0.0, sum);
        sum = 0.0;
        for (i = 0; i < this.classProb.length && !found; ++i) {
            if (!((sum += this.classProb[i]) > value)) continue;
            output = i;
            found = true;
        }
        return output;
    }

    private double calcTransProb(int instance, double[] example) {
        double probability = 0.0;
        for (int i = 0; i < example.length; ++i) {
            probability += this.calcAttTransProb(this.trainData[instance][i], example[i], i);
        }
        return probability;
    }

    private double calcAttTransProb(double train, double test, int feature) {
        double scale;
        double probability = 0.0;
        Hashtable<Double, Double> auxTable = this.scaleTable.get(feature);
        if (auxTable.containsKey(test)) {
            scale = auxTable.get(test);
        } else {
            scale = this.calcScale(train, test, feature);
            this.scaleTable.get(feature).put(test, scale);
        }
        double distance = Math.abs(test - train);
        probability = this.PStar(distance, scale);
        return probability;
    }

    private double PStar(double x, double scale) {
        double value = scale * Math.exp(-2.0 * x * scale);
        return value;
    }

    private double calcScale(double train, double test, int feature) {
        boolean finish = false;
        double lowest = -1.0;
        double nearest = -1.0;
        int lowestcount = 0;
        double scale = -1.0;
        for (int i = 0; i < this.trainData.length; ++i) {
            this.trainDistances[i] = Math.abs(this.trainData[i][feature] - test);
            if (!(this.trainDistances[i] + 1.0E-5 < nearest) && nearest != -1.0) continue;
            if (this.trainDistances[i] + 1.0E-5 < lowest || lowest == -1.0) {
                nearest = lowest;
                lowest = this.trainDistances[i];
                lowestcount = 1;
                continue;
            }
            if (Math.abs(this.trainDistances[i] - lowest) < 1.0E-5) {
                ++lowestcount;
                continue;
            }
            nearest = this.trainDistances[i];
        }
        if (nearest == -1.0 || lowest == -1.0) {
            scale = 1.0;
        } else {
            double root = 1.0 / (nearest - lowest);
            double desiredInstances = (double)lowestcount + (double)(this.trainData.length - lowestcount) * this.blendFactor;
            if (this.blendFactor == 0.0) {
                desiredInstances += 1.0;
            }
            double bottomRoot = 0.005;
            double upRoot = root * 16.0;
            double bottomSphere = this.calculateSphereSize(bottomRoot);
            double upSphere = this.calculateSphereSize(upRoot);
            if (bottomSphere < 0.0) {
                scale = bottomRoot;
            }
            if (upSphere > 0.0) {
                scale = upRoot;
            }
            if (scale == -1.0) {
                scale = 1.0;
                double best = Double.MAX_VALUE;
                int iterations = 0;
                while (!finish) {
                    double actualSphere = this.calculateSphereSize(root);
                    double zero = actualSphere - desiredInstances;
                    if (Math.abs(zero) < best) {
                        best = Math.abs(zero);
                        scale = root;
                    }
                    if (Math.abs(zero) <= 0.01) {
                        finish = true;
                    }
                    if (zero > 0.0) {
                        bottomRoot = root;
                        root = (root + upRoot) / 2.0;
                    } else {
                        upRoot = root;
                        root = (root + bottomRoot) / 2.0;
                    }
                    if (iterations <= 30) continue;
                    System.out.println("Warning: ROOT_FINDER_MAX_ITER exceeded");
                }
            }
        }
        return scale;
    }

    private double calculateSphereSize(double scale) {
        double pstarSum = 0.0;
        double pstarSquareSum = 0.0;
        for (int i = 0; i < this.trainData.length; ++i) {
            double pstar;
            double inc = pstar = this.PStar(this.trainDistances[i], scale);
            pstarSum += inc;
            pstarSquareSum += inc * inc;
        }
        double sphereSize = pstarSquareSum != 0.0 ? pstarSum * pstarSum / pstarSquareSum : 0.0;
        return sphereSize;
    }
}

